/*
 * Decompiled with CFR 0.152.
 */
package codechicken.asm;

import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.io.LineProcessor;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class ObfMapping {
    private static boolean isUnitTest = Boolean.getBoolean("ccl.unit_testing");
    public static ObfRemapper obfMapper = new ObfRemapper();
    public static Remapper mcpMapper = null;
    public static final boolean obfuscated;
    public String s_owner;
    public String s_name;
    public String s_desc;

    public static void loadMCPRemapper() {
        if (mcpMapper == null) {
            mcpMapper = new MCPRemapper();
        }
    }

    public ObfMapping(String owner) {
        this(owner, "", "");
    }

    public ObfMapping(String owner, String name) {
        this(owner, name, "");
    }

    public ObfMapping(String owner, String name, String desc) {
        this.s_owner = owner;
        this.s_name = name;
        this.s_desc = desc;
        if (this.s_owner.contains(".")) {
            throw new IllegalArgumentException(this.s_owner);
        }
    }

    public ObfMapping(ObfMapping descmap, String subclass) {
        this(subclass, descmap.s_name, descmap.s_desc);
    }

    public static ObfMapping fromDesc(String s) {
        int sep;
        int lastDot = s.lastIndexOf(46);
        if (lastDot < 0) {
            return new ObfMapping(s, "", "");
        }
        int sep_end = sep = s.indexOf(40);
        if (sep < 0) {
            sep = s.indexOf(32);
            sep_end = sep + 1;
        }
        if (sep < 0) {
            sep = s.indexOf(58);
            sep_end = sep + 1;
        }
        if (sep < 0) {
            return new ObfMapping(s.substring(0, lastDot), s.substring(lastDot + 1), "");
        }
        return new ObfMapping(s.substring(0, lastDot), s.substring(lastDot + 1, sep), s.substring(sep_end));
    }

    public ObfMapping subclass(String subclass) {
        return new ObfMapping(this, subclass);
    }

    public boolean matches(MethodNode node) {
        return this.s_name.equals(node.name) && this.s_desc.equals(node.desc);
    }

    public boolean matches(MethodInsnNode node) {
        return this.s_owner.equals(node.owner) && this.s_name.equals(node.name) && this.s_desc.equals(node.desc);
    }

    public AbstractInsnNode toInsn(int opcode) {
        if (this.isClass()) {
            return new TypeInsnNode(opcode, this.s_owner);
        }
        if (this.isMethod()) {
            return new MethodInsnNode(opcode, this.s_owner, this.s_name, this.s_desc, opcode == 185);
        }
        return new FieldInsnNode(opcode, this.s_owner, this.s_name, this.s_desc);
    }

    public void visitTypeInsn(MethodVisitor mv, int opcode) {
        mv.visitTypeInsn(opcode, this.s_owner);
    }

    public void visitMethodInsn(MethodVisitor mv, int opcode) {
        mv.visitMethodInsn(opcode, this.s_owner, this.s_name, this.s_desc, opcode == 185);
    }

    public void visitFieldInsn(MethodVisitor mv, int opcode) {
        mv.visitFieldInsn(opcode, this.s_owner, this.s_name, this.s_desc);
    }

    public MethodVisitor visitMethod(ClassVisitor visitor, int access, String[] exceptions) {
        return visitor.visitMethod(access, this.s_name, this.s_desc, null, exceptions);
    }

    public FieldVisitor visitField(ClassVisitor visitor, int access, Object value) {
        return visitor.visitField(access, this.s_name, this.s_desc, null, value);
    }

    public boolean isClass(String name) {
        return name.replace('.', '/').equals(this.s_owner);
    }

    public boolean matches(String name, String desc) {
        return this.s_name.equals(name) && this.s_desc.equals(desc);
    }

    public boolean matches(FieldNode node) {
        return this.s_name.equals(node.name) && this.s_desc.equals(node.desc);
    }

    public boolean matches(FieldInsnNode node) {
        return this.s_owner.equals(node.owner) && this.s_name.equals(node.name) && this.s_desc.equals(node.desc);
    }

    public String javaClass() {
        return this.s_owner.replace('/', '.');
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ObfMapping)) {
            return false;
        }
        ObfMapping desc = (ObfMapping)obj;
        return this.s_owner.equals(desc.s_owner) && this.s_name.equals(desc.s_name) && this.s_desc.equals(desc.s_desc);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.s_desc, this.s_name, this.s_owner});
    }

    public String toString() {
        if (this.s_name.length() == 0) {
            return "[" + this.s_owner + "]";
        }
        if (this.s_desc.length() == 0) {
            return "[" + this.s_owner + "." + this.s_name + "]";
        }
        return "[" + (this.isMethod() ? this.methodDesc() : this.fieldDesc()) + "]";
    }

    public String methodDesc() {
        return this.s_owner + "." + this.s_name + this.s_desc;
    }

    public String fieldDesc() {
        return this.s_owner + "." + this.s_name + ":" + this.s_desc;
    }

    public boolean isClass() {
        return this.s_name.length() == 0;
    }

    public boolean isMethod() {
        return this.s_desc.contains("(");
    }

    public boolean isField() {
        return !this.isClass() && !this.isMethod();
    }

    public ObfMapping map(Remapper mapper) {
        if (mapper == null) {
            return this;
        }
        if (this.isMethod()) {
            this.s_name = mapper.mapMethodName(this.s_owner, this.s_name, this.s_desc);
        } else if (this.isField()) {
            this.s_name = mapper.mapFieldName(this.s_owner, this.s_name, this.s_desc);
        }
        this.s_owner = mapper.mapType(this.s_owner);
        if (this.isMethod()) {
            this.s_desc = mapper.mapMethodDesc(this.s_desc);
        } else if (this.s_desc.length() > 0) {
            this.s_desc = mapper.mapDesc(this.s_desc);
        }
        return this;
    }

    public ObfMapping toRuntime() {
        this.map(mcpMapper);
        return this;
    }

    public ObfMapping toClassloading() {
        if (!obfuscated) {
            this.map(mcpMapper);
        } else if (obfMapper.isObf(this.s_owner)) {
            this.map(obfMapper);
        }
        return this;
    }

    public ObfMapping copy() {
        return new ObfMapping(this.s_owner, this.s_name, this.s_desc);
    }

    static {
        boolean obf = true;
        try {
            obf = Launch.classLoader.getClassBytes("net.minecraft.world.World") == null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        obfuscated = obf;
        if (!obf) {
            ObfMapping.loadMCPRemapper();
        }
    }

    public static class MCPRemapper
    extends Remapper
    implements LineProcessor<Void> {
        private HashMap<String, String> fields = new HashMap();
        private HashMap<String, String> funcs = new HashMap();

        public static File[] getConfFiles() {
            File notchSrg = new File(System.getProperty("net.minecraftforge.gradle.GradleStart.srg.notch-srg"));
            File csvDir = new File(System.getProperty("net.minecraftforge.gradle.GradleStart.csvDir"));
            if (notchSrg.exists() && csvDir.exists()) {
                File fieldCsv = new File(csvDir, "fields.csv");
                File methodCsv = new File(csvDir, "methods.csv");
                if (notchSrg.exists() && fieldCsv.exists() && methodCsv.exists()) {
                    return new File[]{notchSrg, fieldCsv, methodCsv};
                }
            }
            throw new RuntimeException("Failed to grab mappings from GradleStart args.");
        }

        public MCPRemapper() {
            File[] mappings = MCPRemapper.getConfFiles();
            try {
                Resources.readLines((URL)mappings[1].toURI().toURL(), (Charset)Charsets.UTF_8, (LineProcessor)this);
                Resources.readLines((URL)mappings[2].toURI().toURL(), (Charset)Charsets.UTF_8, (LineProcessor)this);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public String mapMethodName(String owner, String name, String desc) {
            String s = this.funcs.get(name);
            return s == null ? name : s;
        }

        public String mapFieldName(String owner, String name, String desc) {
            String s = this.fields.get(name);
            return s == null ? name : s;
        }

        public boolean processLine(@Nonnull String line) throws IOException {
            int i = line.indexOf(44);
            String srg = line.substring(0, i);
            int i2 = i + 1;
            i = line.indexOf(44, i2);
            String mcp = line.substring(i2, i);
            (srg.startsWith("func") ? this.funcs : this.fields).put(srg, mcp);
            return true;
        }

        public Void getResult() {
            return null;
        }
    }

    public static class ObfRemapper
    extends Remapper {
        private HashMap<String, String> fields = new HashMap();
        private HashMap<String, String> funcs = new HashMap();

        public ObfRemapper() {
            if (isUnitTest) {
                return;
            }
            try {
                Field rawFieldMapsField = FMLDeobfuscatingRemapper.class.getDeclaredField("rawFieldMaps");
                Field rawMethodMapsField = FMLDeobfuscatingRemapper.class.getDeclaredField("rawMethodMaps");
                rawFieldMapsField.setAccessible(true);
                rawMethodMapsField.setAccessible(true);
                Map rawFieldMaps = (Map)rawFieldMapsField.get(FMLDeobfuscatingRemapper.INSTANCE);
                Map rawMethodMaps = (Map)rawMethodMapsField.get(FMLDeobfuscatingRemapper.INSTANCE);
                if (rawFieldMaps == null) {
                    throw new IllegalStateException("codechicken.lib.asm.ObfMapping loaded too early. Make sure all references are in or after the asm transformer load stage");
                }
                for (Map map : rawFieldMaps.values()) {
                    for (Map.Entry entry : map.entrySet()) {
                        if (!((String)entry.getValue()).startsWith("field")) continue;
                        this.fields.put((String)entry.getValue(), ((String)entry.getKey()).substring(0, ((String)entry.getKey()).indexOf(58)));
                    }
                }
                for (Map map : rawMethodMaps.values()) {
                    for (Map.Entry entry : map.entrySet()) {
                        if (!((String)entry.getValue()).startsWith("func")) continue;
                        this.funcs.put((String)entry.getValue(), ((String)entry.getKey()).substring(0, ((String)entry.getKey()).indexOf(40)));
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public String mapMethodName(String owner, String name, String desc) {
            String s = this.funcs.get(name);
            return s == null ? name : s;
        }

        public String mapFieldName(String owner, String name, String desc) {
            String s = this.fields.get(name);
            return s == null ? name : s;
        }

        public String map(String typeName) {
            return FMLDeobfuscatingRemapper.INSTANCE.unmap(typeName);
        }

        public String unmap(String typeName) {
            return FMLDeobfuscatingRemapper.INSTANCE.map(typeName);
        }

        public boolean isObf(String typeName) {
            return !this.map(typeName).equals(typeName) || !this.unmap(typeName).equals(typeName);
        }
    }
}

