/*
 * Decompiled with CFR 0.152.
 */
package codechicken.asm;

import codechicken.asm.ASMHelper;
import codechicken.asm.LocalVariablesSorterVisitor;
import codechicken.asm.ObfMapping;
import codechicken.asm.transformers.ClassNodeTransformer;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

public class ModularASMTransformer {
    public static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("ccl.asm.debug", "false"));
    public static final boolean DUMP_RAW = Boolean.parseBoolean(System.getProperty("ccl.asm.debug.dump_raw", "false")) && DEBUG;
    public static final boolean DUMP_TEXT = Boolean.parseBoolean(System.getProperty("ccl.asm.debug.dump_text", "false")) && DEBUG;
    public static final File dumpFolderBase = new File("asm/ccl_modular/");
    public File dumpFolder;
    public HashMap<String, ClassNodeTransformerList> transformers = new HashMap();
    public String name;

    public ModularASMTransformer(String name) {
        this.name = name;
        this.dumpFolder = new File(dumpFolderBase, name);
    }

    public void add(@Nonnull ClassNodeTransformer t) {
        ClassNodeTransformerList list = this.transformers.computeIfAbsent(t.className(), k -> new ClassNodeTransformerList());
        list.add(t);
    }

    @Nullable
    public byte[] transform(@Nonnull String name, @Nullable byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ClassNodeTransformerList list = this.transformers.get(name);
        return list == null ? bytes : list.transform(bytes);
    }

    public static void log(Object object) {
        ModularASMTransformer.log(String.valueOf(object), "");
    }

    public static void log(String format, Object ... params) {
        Level level = DEBUG ? Level.INFO : Level.DEBUG;
        ASMHelper.logger.log(level, String.format(format, params));
    }

    public class ClassNodeTransformerList {
        List<ClassNodeTransformer> transformers = new LinkedList<ClassNodeTransformer>();
        HashSet<ObfMapping> methodsToSort = new HashSet();

        public void add(ClassNodeTransformer t) {
            this.transformers.add(t);
            t.addMethodsToSort(this.methodsToSort);
        }

        public byte[] transform(byte[] bytes) {
            ClassNode cnode = new ClassNode();
            ClassReader reader = new ClassReader(bytes);
            Object cv = cnode;
            if (!this.methodsToSort.isEmpty()) {
                cv = new LocalVariablesSorterVisitor(this.methodsToSort, (ClassVisitor)cv);
            }
            reader.accept((ClassVisitor)cv, 8);
            try {
                int writeFlags = 0;
                for (ClassNodeTransformer t : this.transformers) {
                    t.transform(cnode);
                    writeFlags |= t.writeFlags;
                }
                bytes = ASMHelper.createBytes(cnode, writeFlags);
                if (DUMP_RAW) {
                    File file = new File(ModularASMTransformer.this.dumpFolder, cnode.name.replace('/', '#') + ".class");
                    if (!file.exists()) {
                        if (!file.getParentFile().exists()) {
                            file.getParentFile().mkdirs();
                        }
                        file.createNewFile();
                    }
                    FileOutputStream fos = new FileOutputStream(file);
                    fos.write(bytes);
                    fos.flush();
                    fos.close();
                } else if (DUMP_TEXT) {
                    ASMHelper.dump(bytes, new File(ModularASMTransformer.this.dumpFolder, cnode.name.replace('/', '#') + ".txt"), false, false);
                }
                return bytes;
            }
            catch (Exception e) {
                ASMHelper.dump(bytes, new File(ModularASMTransformer.this.dumpFolder, cnode.name.replace('/', '#') + ".txt"), false, false);
                throw new RuntimeException(e);
            }
        }
    }
}

