/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui.grid.stack;

import com.raoulvdberge.refinedstorage.api.storage.IStorageTracker;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.storage.StorageTrackerEntry;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.grid.stack.IGridStack;
import com.raoulvdberge.refinedstorage.util.RenderUtils;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.oredict.OreDictionary;

public class GridStackItem
implements IGridStack {
    private int hash;
    private ItemStack stack;
    private String cachedName;
    private boolean craftable;
    private boolean displayCraftText;
    private String[] oreIds = null;
    @Nullable
    private IStorageTracker.IStorageTrackerEntry entry;
    private String modId;
    private String modName;
    private String tooltip;

    public GridStackItem(ItemStack stack) {
        this.stack = stack;
    }

    public GridStackItem(ByteBuf buf) {
        this.stack = StackUtils.readItemStack(buf);
        this.hash = buf.readInt();
        this.craftable = buf.readBoolean();
        this.setDisplayCraftText(buf.readBoolean());
        if (buf.readBoolean()) {
            this.entry = new StorageTrackerEntry(buf);
        }
    }

    @Nullable
    static String getModNameByModId(String modId) {
        ModContainer container = Loader.instance().getActiveModList().stream().filter(m -> m.getModId().toLowerCase().equals(modId)).findFirst().orElse(null);
        return container == null ? null : container.getName();
    }

    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public boolean isCraftable() {
        return this.craftable;
    }

    @Override
    public boolean doesDisplayCraftText() {
        return this.displayCraftText;
    }

    @Override
    public void setDisplayCraftText(boolean displayCraftText) {
        this.displayCraftText = displayCraftText;
        if (displayCraftText) {
            this.stack.func_190920_e(1);
        }
    }

    @Override
    public int getHash() {
        return this.hash;
    }

    @Override
    public String getName() {
        try {
            if (this.cachedName == null) {
                this.cachedName = this.stack.func_82833_r();
            }
            return this.cachedName;
        }
        catch (Throwable t) {
            return "";
        }
    }

    @Override
    public String getModId() {
        if (this.modId == null) {
            this.modId = this.stack.func_77973_b().getCreatorModId(this.stack);
            if (this.modId == null) {
                this.modId = "???";
            }
        }
        return this.modId;
    }

    @Override
    public String getModName() {
        if (this.modName == null) {
            this.modName = GridStackItem.getModNameByModId(this.getModId());
            if (this.modName == null) {
                this.modName = "???";
            }
        }
        return this.modName;
    }

    @Override
    public String[] getOreIds() {
        if (this.oreIds == null) {
            this.oreIds = this.stack.func_190926_b() ? new String[0] : (String[])Arrays.stream(OreDictionary.getOreIDs((ItemStack)this.stack)).mapToObj(OreDictionary::getOreName).toArray(String[]::new);
        }
        return this.oreIds;
    }

    @Override
    public String getTooltip() {
        if (this.tooltip == null) {
            try {
                this.tooltip = RenderUtils.getItemTooltip(this.stack).stream().collect(Collectors.joining("\n"));
            }
            catch (Throwable t) {
                this.tooltip = "";
            }
        }
        return this.tooltip;
    }

    @Override
    public int getQuantity() {
        return this.doesDisplayCraftText() ? 0 : this.stack.func_190916_E();
    }

    @Override
    public String getFormattedFullQuantity() {
        return API.instance().getQuantityFormatter().format(this.getQuantity());
    }

    @Override
    public void draw(GuiBase gui, int x, int y) {
        String text = null;
        if (this.displayCraftText) {
            text = I18n.func_135052_a((String)"gui.refinedstorage:grid.craft", (Object[])new Object[0]);
        } else if (this.stack.func_190916_E() > 1) {
            text = API.instance().getQuantityFormatter().formatWithUnits(this.getQuantity());
        }
        gui.drawItem(x, y, this.stack, true, text);
    }

    @Override
    public Object getIngredient() {
        return this.stack;
    }

    @Override
    @Nullable
    public IStorageTracker.IStorageTrackerEntry getTrackerEntry() {
        return this.entry;
    }

    @Override
    public void setTrackerEntry(@Nullable IStorageTracker.IStorageTrackerEntry entry) {
        this.entry = entry;
    }
}

