/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.oc.client;

import java.util.Arrays;
import java.util.List;
import li.cil.oc.api.event.RackMountableRenderEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import pl.asie.computronics.item.ItemOpenComputers;
import pl.asie.computronics.oc.driver.DriverBoardLight;

public class RackMountableRenderer {
    private final ResourceLocation boomBoardActive = new ResourceLocation("computronics", "textures/blocks/boom_board_on.png");
    private final ResourceLocation boomBoardTicking = new ResourceLocation("computronics", "textures/blocks/boom_board_ticking.png");
    private final ResourceLocation switchBoardActive = new ResourceLocation("computronics", "textures/blocks/switch_board_on.png");
    private TextureAtlasSprite boomBoard;
    private TextureAtlasSprite rackCapacitor;
    private TextureAtlasSprite switchBoard;
    private static final List<Integer> mountables = Arrays.asList(10, 11, 12, 13);

    @Optional.Method(modid="opencomputers")
    private boolean isRackMountable(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof ItemOpenComputers && mountables.contains(stack.func_77952_i());
    }

    @SubscribeEvent
    @Optional.Method(modid="opencomputers")
    public void onRackMountableRender(RackMountableRenderEvent.TileEntity e) {
        ItemStack stack = e.rack.func_70301_a(e.mountable);
        if (!this.isRackMountable(stack)) {
            return;
        }
        switch (stack.func_77952_i()) {
            case 10: {
                if (e.data == null) {
                    return;
                }
                this.enableLight();
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)770, (int)771);
                DriverBoardLight.Mode mode = DriverBoardLight.Mode.fromIndex(e.data.func_74762_e("m"));
                if (mode == null) {
                    mode = DriverBoardLight.Mode.Default;
                }
                for (int index = 1; index <= mode.lightcount; ++index) {
                    int color;
                    if (!e.data.func_74767_n("r_" + index) || (color = e.data.func_74762_e("c_" + index)) < 0) continue;
                    GlStateManager.func_179124_c((float)((float)((color &= 0xFFFFFF) >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f));
                    float u0 = mode.getU0(index);
                    float v0 = mode.getV0(index, e.v0, e.v1);
                    this.renderOverlay(mode.foreground, u0, mode.getU1(index, u0), v0, mode.getV1(index, v0, e.v1));
                }
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179084_k();
                this.disableLight();
                break;
            }
            case 11: {
                if (e.data == null) {
                    return;
                }
                this.enableLight();
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)770, (int)771);
                if (e.data.func_74767_n("r")) {
                    e.renderOverlay(this.boomBoardActive);
                }
                if (e.data.func_74767_n("t") && (e.rack.world().func_82737_E() + (long)e.rack.hashCode() + (long)(e.mountable * 10)) % 20L < 10L) {
                    e.renderOverlay(this.boomBoardTicking);
                }
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179084_k();
                this.disableLight();
                break;
            }
            case 13: {
                if (e.data == null) {
                    return;
                }
                this.enableLight();
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)770, (int)771);
                byte switchData = e.data.func_74771_c("s");
                for (int i = 0; i < 4; ++i) {
                    if ((switchData >> i & 1) != 1) continue;
                    float u0 = (float)(i * 4) / 16.0f;
                    float u1 = u0 + 0.25f;
                    e.renderOverlay(this.switchBoardActive, u0, u1);
                }
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179084_k();
                this.disableLight();
                break;
            }
        }
    }

    private void renderOverlay(ResourceLocation texture, float u0, float u1, float v0, float v1) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder r = t.func_178180_c();
        r.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        r.func_181662_b((double)u0, (double)v1, 0.0).func_187315_a((double)u0, (double)v1).func_181675_d();
        r.func_181662_b((double)u1, (double)v1, 0.0).func_187315_a((double)u1, (double)v1).func_181675_d();
        r.func_181662_b((double)u1, (double)v0, 0.0).func_187315_a((double)u1, (double)v0).func_181675_d();
        r.func_181662_b((double)u0, (double)v0, 0.0).func_187315_a((double)u0, (double)v0).func_181675_d();
        t.func_78381_a();
    }

    private void enableLight() {
        Minecraft.func_71410_x().field_71460_t.func_175072_h();
        RenderHelper.func_74518_a();
    }

    private void disableLight() {
        Minecraft.func_71410_x().field_71460_t.func_180436_i();
        RenderHelper.func_74519_b();
    }

    @SubscribeEvent
    @Optional.Method(modid="opencomputers")
    public void onRackMountableRender(RackMountableRenderEvent.Block e) {
        ItemStack stack = e.rack.func_70301_a(e.mountable);
        if (!this.isRackMountable(stack)) {
            return;
        }
        switch (stack.func_77952_i()) {
            case 10: {
                if (e.data == null) {
                    return;
                }
                DriverBoardLight.Mode mode = DriverBoardLight.Mode.fromIndex(e.data.func_74762_e("m"));
                if (mode == null) {
                    mode = DriverBoardLight.Mode.Default;
                }
                e.setFrontTextureOverride(mode.background);
                break;
            }
            case 11: {
                e.setFrontTextureOverride(this.boomBoard);
                break;
            }
            case 12: {
                e.setFrontTextureOverride(this.rackCapacitor);
                break;
            }
            case 13: {
                e.setFrontTextureOverride(this.switchBoard);
            }
        }
    }

    @SubscribeEvent
    @Optional.Method(modid="opencomputers")
    public void textureHook(TextureStitchEvent.Pre e) {
        for (DriverBoardLight.Mode mode : DriverBoardLight.Mode.VALUES) {
            mode.registerIcons(e.getMap());
        }
        this.boomBoard = e.getMap().func_174942_a(new ResourceLocation("computronics:blocks/boom_board"));
        this.rackCapacitor = e.getMap().func_174942_a(new ResourceLocation("computronics:blocks/rack_capacitor"));
        this.switchBoard = e.getMap().func_174942_a(new ResourceLocation("computronics:blocks/switch_board"));
    }
}

