/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.charset.wires;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.redstone.IBundledRedstoneProvider;
import dan200.computercraft.shared.computer.blocks.IComputerTile;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import pl.asie.charset.api.wires.IBundledEmitter;
import pl.asie.charset.api.wires.IBundledReceiver;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.integration.charset.wires.IntegrationCharsetWires;

@Optional.Interface(iface="import dan200.computercraft.api.redstone.IBundledRedstoneProvider", modid="computercraft")
public class CCBundledRedstoneIntegration
implements IBundledRedstoneProvider {
    private static Capability<IBundledEmitter> CHARSET_EMITTER = null;
    private static Capability<IBundledReceiver> CHARSET_RECEIVER = null;
    private boolean registered = false;
    private static final ResourceLocation charsetBundledRedstoneID = new ResourceLocation("computronics", "charset_bundled_rs_cc");

    @CapabilityInject(value=IBundledEmitter.class)
    private static void onBundledEmitterrInject(Capability<IBundledEmitter> c) {
        Computronics.log.info("Adding Charset Bundled Cable support to ComputerCraft. Bundled Cables can now transmit ComputerCraft bundled signals!");
        CHARSET_EMITTER = c;
        IntegrationCharsetWires.bundledRedstoneCC.register();
    }

    @CapabilityInject(value=IBundledReceiver.class)
    private static void onBundledReceiverInject(Capability<IBundledReceiver> c) {
        Computronics.log.info("Adding Charset Bundled Cable support to ComputerCraft. ComputerCraft can now read values from Bundled Cables!");
        CHARSET_RECEIVER = c;
        ComputerCraftAPI.registerBundledRedstoneProvider((IBundledRedstoneProvider)IntegrationCharsetWires.bundledRedstoneCC);
        IntegrationCharsetWires.bundledRedstoneCC.register();
    }

    private void register() {
        if (!this.registered) {
            MinecraftForge.EVENT_BUS.register((Object)this);
            this.registered = true;
        }
    }

    @SubscribeEvent
    @Optional.Method(modid="computercraft")
    public void onCapabilityAttach(AttachCapabilitiesEvent<TileEntity> e) {
        if (e.getObject() instanceof IComputerTile) {
            e.addCapability(charsetBundledRedstoneID, (ICapabilityProvider)new CharsetCapabilityProvider((TileEntity)e.getObject()));
        }
    }

    @Optional.Method(modid="computercraft")
    public int getBundledRedstoneOutput(World world, BlockPos pos, EnumFacing side) {
        IBundledEmitter emitter;
        byte[] data;
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile.hasCapability(CHARSET_EMITTER, side) && (data = (emitter = (IBundledEmitter)tile.getCapability(CHARSET_EMITTER, side)).getBundledSignal()) != null) {
            int out = 0;
            for (int j = 0; j < data.length; ++j) {
                if (data[j] == 0) continue;
                out |= 1 << j;
            }
            return out;
        }
        return -1;
    }

    private static class CharsetCapabilityProvider
    implements ICapabilityProvider {
        private final TileEntity tile;
        private final CCBundledEmitter[] EMITTERS = new CCBundledEmitter[6];
        private final CCBundledReceiver[] RECEIVERS = new CCBundledReceiver[6];

        public CharsetCapabilityProvider(TileEntity tile) {
            this.tile = tile;
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability != null && (capability == CHARSET_EMITTER || capability == CHARSET_RECEIVER);
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (capability == null) {
                return null;
            }
            if (capability == CHARSET_EMITTER) {
                return (T)this.getEmitter(facing);
            }
            if (capability == CHARSET_RECEIVER) {
                return (T)this.getReceiver(facing);
            }
            return null;
        }

        private CCBundledEmitter getEmitter(EnumFacing facing) {
            if (this.EMITTERS[facing.ordinal()] == null) {
                this.EMITTERS[facing.ordinal()] = new CCBundledEmitter(this.tile, facing);
            }
            return this.EMITTERS[facing.ordinal()];
        }

        private CCBundledReceiver getReceiver(EnumFacing facing) {
            if (this.RECEIVERS[facing.ordinal()] == null) {
                this.RECEIVERS[facing.ordinal()] = new CCBundledReceiver(this.tile, facing);
            }
            return this.RECEIVERS[facing.ordinal()];
        }
    }

    public static class CCBundledReceiver
    extends TileCache
    implements IBundledReceiver {
        protected CCBundledReceiver(TileEntity tile, EnumFacing side) {
            super(tile, side);
        }

        public void onBundledInputChange() {
            this.tile.func_145831_w().func_190524_a(this.tile.func_174877_v(), this.tile.func_145831_w().func_180495_p(this.tile.func_174877_v().func_177972_a(this.side)).func_177230_c(), this.tile.func_174877_v().func_177972_a(this.side));
        }
    }

    public static class CCBundledEmitter
    extends TileCache
    implements IBundledEmitter {
        protected CCBundledEmitter(TileEntity tile, EnumFacing side) {
            super(tile, side);
        }

        public byte[] getBundledSignal() {
            int out = ComputerCraftAPI.getBundledRedstoneOutput((World)this.tile.func_145831_w(), (BlockPos)this.tile.func_174877_v(), (EnumFacing)this.side);
            if (out < 0) {
                return new byte[16];
            }
            byte[] data = new byte[16];
            for (int i = 0; i < 16; ++i) {
                data[i] = (byte)((out & 1 << i) != 0 ? 15 : 0);
            }
            return data;
        }
    }

    public static class TileCache {
        protected final EnumFacing side;
        protected final TileEntity tile;

        protected TileCache(TileEntity tile, EnumFacing side) {
            this.tile = tile;
            this.side = side;
        }
    }
}

