/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.charset.audio;

import io.netty.buffer.ByteBuf;
import pl.asie.charset.api.audio.IAudioDataPCM;
import pl.asie.computronics.api.audio.AudioPacket;
import pl.asie.computronics.integration.charset.audio.AudioDataDummy;
import pl.asie.lib.audio.DFPWM;

public class AudioDataDFPWM
extends AudioDataDummy
implements IAudioDataPCM {
    protected byte[] decodedData;
    private byte[] data;
    private int time;
    private static final DFPWM dfpwm = new DFPWM();

    public AudioDataDFPWM() {
        super(null);
    }

    public AudioDataDFPWM(AudioPacket wrapped, byte[] data, int time) {
        super(wrapped);
        this.data = data;
        this.time = time;
    }

    public int getSampleRate() {
        int samples = this.data.length * 8;
        return samples * 1000 / this.time;
    }

    public int getSampleSize() {
        return 1;
    }

    public boolean isSampleSigned() {
        return true;
    }

    public boolean isSampleBigEndian() {
        return false;
    }

    public byte[] getSamplePCMData() {
        if (this.decodedData == null) {
            this.decodedData = new byte[this.data.length * 8];
            dfpwm.decompress(this.decodedData, this.data, 0, 0, this.data.length);
        }
        return this.decodedData;
    }

    @Override
    public int getTime() {
        return this.time;
    }

    @Override
    public void readData(ByteBuf buf) {
        this.time = buf.readUnsignedMedium();
        this.data = new byte[buf.readUnsignedShort()];
        buf.readBytes(this.data);
    }

    @Override
    public void writeData(ByteBuf buf) {
        buf.writeMedium(this.time);
        buf.writeShort(this.data.length);
        buf.writeBytes(this.data);
    }
}

