/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.superiorshields.shield;

import epicsquid.superiorshields.config.ConfigManager;
import epicsquid.superiorshields.shield.IEnergyShield;
import epicsquid.superiorshields.shield.effect.IShieldEffect;
import epicsquid.superiorshields.shield.effect.ShieldEffectFireNova;
import epicsquid.superiorshields.shield.effect.ShieldEffectNone;
import epicsquid.superiorshields.shield.effect.ShieldEffectPotionNova;
import javax.annotation.Nonnull;
import net.minecraft.init.MobEffects;

public enum ThermalShield implements IEnergyShield
{
    BASIC(ConfigManager.thermal.basicMaxHp, ConfigManager.thermal.basicRechargeDelay, ConfigManager.thermal.basicRechargeRate, ConfigManager.thermal.basicEnergy),
    HARDENED(ConfigManager.thermal.hardenedMaxHp, ConfigManager.thermal.hardenedRechargeDelay, ConfigManager.thermal.hardenedRechargeRate, ConfigManager.thermal.hardenedEnergy),
    REINFORCED(ConfigManager.thermal.reinforcedMaxHp, ConfigManager.thermal.reinforcedRechargeDelay, ConfigManager.thermal.reinforcedRechargeRate, ConfigManager.thermal.reinforcedEnergy),
    SIGNALUM(ConfigManager.thermal.signalumMaxHp, ConfigManager.thermal.signalumRechargeDelay, ConfigManager.thermal.signaulmRechargeRate, ConfigManager.thermal.signalumEnergy),
    ENDERIUM(ConfigManager.thermal.enderiumMaxHp, ConfigManager.thermal.enderiumRechargeDelay, ConfigManager.thermal.enderiumRechargeRate, ConfigManager.thermal.enderiumEnergy),
    PYROTHEUM(ConfigManager.thermal.pyrotheumMaxHp, ConfigManager.thermal.pyrotheumRechargeDelay, ConfigManager.thermal.pyrotheumRechargeRate, ConfigManager.thermal.pyrotheumEnergy, new ShieldEffectFireNova(5, 10.0)),
    CRYOTHEUM(ConfigManager.thermal.cryotheumMaxHp, ConfigManager.thermal.cryotheumRechargeDelay, ConfigManager.thermal.cryotheumRechargeRate, ConfigManager.thermal.cryotheumEnergy, new ShieldEffectPotionNova(MobEffects.field_76421_d, 5, 10.0, "shield.effect.nova.potion.slowness")),
    AEROTHEUM(ConfigManager.thermal.aerotheumMaxHp, ConfigManager.thermal.aerotheumRechargeDelay, ConfigManager.thermal.aerotheumRechargeRate, ConfigManager.thermal.aerotheumEnergy, new ShieldEffectPotionNova(MobEffects.field_76440_q, 5, 10.0, "shield.effect.nova.potion.blindness")),
    PETROTHEUM(ConfigManager.thermal.petrotheumMaxHp, ConfigManager.thermal.petrotheumRechargeDelay, ConfigManager.thermal.petrotheumRechargeRate, ConfigManager.thermal.petrotheumEnergy, new ShieldEffectPotionNova(MobEffects.field_76437_t, 5, 10.0, "shield.effect.nova.potion.weakness"));

    private float maxHp;
    private int shieldRechargeDelay;
    private int shieldRechargeRate;
    private int maxEnergy;
    private IShieldEffect effect;

    private ThermalShield(float maxHp, int shieldRechargeDelay, int shieldRechargeRate, int maxEnergy) {
        this(maxHp, shieldRechargeDelay, shieldRechargeRate, maxEnergy, new ShieldEffectNone());
    }

    private ThermalShield(float maxHp, int shieldRechargeDelay, @Nonnull int shieldRechargeRate, int maxEnergy, IShieldEffect effect) {
        this.maxHp = maxHp;
        this.shieldRechargeDelay = shieldRechargeDelay;
        this.shieldRechargeRate = shieldRechargeRate;
        this.maxEnergy = maxEnergy;
        this.effect = effect;
    }

    @Override
    @Nonnull
    public IShieldEffect getEffect() {
        return this.effect;
    }

    @Override
    public float getMaxShieldHp() {
        return this.maxHp;
    }

    @Override
    public int getShieldRechargeDelay() {
        return this.shieldRechargeDelay;
    }

    @Override
    public int getShieldRechargeRate() {
        return this.shieldRechargeRate;
    }

    @Override
    public int getColor() {
        return 0xFF0000;
    }

    @Override
    public int getMaxEnergy() {
        return this.maxEnergy;
    }
}

