/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.superiorshields.item;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import epicsquid.mysticallib.item.ItemBase;
import epicsquid.superiorshields.capability.shield.IShieldCapability;
import epicsquid.superiorshields.capability.shield.SuperiorShieldsCapabilityManager;
import epicsquid.superiorshields.event.ShieldEquippedEvent;
import epicsquid.superiorshields.item.ISuperiorShield;
import epicsquid.superiorshields.network.PacketHandler;
import epicsquid.superiorshields.network.PacketShieldUpdate;
import epicsquid.superiorshields.shield.IShieldType;
import epicsquid.superiorshields.shield.effect.EffectTrigger;
import epicsquid.superiorshields.shield.effect.ShieldEffectNone;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSuperiorShield<T extends IShieldType>
extends ItemBase
implements ISuperiorShield,
IBauble {
    private int ticksSinceLastRecharge = 0;
    protected T shieldType;
    private int onTickEventTrigger = 0;

    public ItemSuperiorShield(@Nonnull String name, @Nonnull T shieldType) {
        super(name);
        this.func_77625_d(1);
        this.shieldType = shieldType;
    }

    @Override
    public float applyShield(@Nonnull EntityPlayer player, @Nonnull ItemStack stack, float damage, @Nonnull DamageSource source) {
        if (player.hasCapability(SuperiorShieldsCapabilityManager.shieldCapability, null)) {
            IShieldCapability shield = (IShieldCapability)player.getCapability(SuperiorShieldsCapabilityManager.shieldCapability, null);
            if (shield.getCurrentHp() > 0.0f) {
                this.triggerShieldEffect(player, stack, source, damage, EffectTrigger.DAMAGE);
                if (damage > shield.getCurrentHp()) {
                    this.triggerShieldEffect(player, stack, source, damage, EffectTrigger.EMPTY);
                }
            }
            return this.absorbDamage(player, shield, shield.getCurrentHp() - damage);
        }
        return damage;
    }

    protected float absorbDamage(@Nonnull EntityPlayer player, @Nonnull IShieldCapability shield, float absorbed) {
        shield.setCurrentHp(absorbed);
        this.resetShieldDelay(shield);
        this.updateClient(player, shield);
        return absorbed < 0.0f ? -1.0f * absorbed : 0.0f;
    }

    @Override
    public void rechargeShield(@Nonnull IShieldCapability shield, @Nonnull ItemStack stack, @Nonnull EntityPlayer player) {
        if (shield.getCurrentHp() < shield.getMaxHp() && this.useEnergyToRecharge(stack, player)) {
            shield.setCurrentHp(shield.getCurrentHp() + 1.0f);
        }
    }

    protected boolean useEnergyToRecharge(@Nonnull ItemStack stack, @Nonnull EntityPlayer player) {
        return true;
    }

    @Override
    public void resetShieldDelay(@Nonnull IShieldCapability shield) {
        shield.setTimeWithoutDamage(0);
    }

    public BaubleType getBaubleType(@Nonnull ItemStack itemStack) {
        return BaubleType.CHARM;
    }

    public void onWornTick(@Nonnull ItemStack stack, @Nonnull EntityLivingBase player) {
        if (player instanceof EntityPlayer && player.hasCapability(SuperiorShieldsCapabilityManager.shieldCapability, null)) {
            if (player.field_70170_p.field_72995_K) {
                return;
            }
            IShieldCapability shield = (IShieldCapability)player.getCapability(SuperiorShieldsCapabilityManager.shieldCapability, null);
            if (shield.getTimeWithoutDamage() >= this.shieldType.getShieldRechargeDelay() && shield.getCurrentHp() < shield.getMaxHp()) {
                if (this.ticksSinceLastRecharge < this.shieldType.getShieldRechargeRate()) {
                    ++this.ticksSinceLastRecharge;
                } else {
                    this.ticksSinceLastRecharge = 0;
                    this.rechargeShield(shield, stack, (EntityPlayer)player);
                    this.updateClient((EntityPlayer)player, shield);
                    this.triggerShieldEffect((EntityPlayer)player, stack, null, 0.0f, EffectTrigger.RECHARGE);
                    if (shield.getCurrentHp() >= shield.getMaxHp()) {
                        this.triggerShieldEffect((EntityPlayer)player, stack, null, 0.0f, EffectTrigger.FILLED);
                    }
                }
            } else {
                shield.setTimeWithoutDamage(shield.getTimeWithoutDamage() + 1);
                if (shield.getCurrentHp() >= shield.getMaxHp()) {
                    if (this.onTickEventTrigger >= 20) {
                        this.onTickEventTrigger = 0;
                        this.triggerShieldEffect((EntityPlayer)player, stack, null, 0.0f, EffectTrigger.FULL);
                        this.updateClient((EntityPlayer)player, shield);
                    } else {
                        ++this.onTickEventTrigger;
                    }
                }
            }
        }
    }

    public void onEquipped(@Nonnull ItemStack itemstack, @Nonnull EntityLivingBase player) {
        if (player instanceof EntityPlayer && player.hasCapability(SuperiorShieldsCapabilityManager.shieldCapability, null) && !player.field_70170_p.field_72995_K) {
            IShieldCapability shield = (IShieldCapability)player.getCapability(SuperiorShieldsCapabilityManager.shieldCapability, null);
            shield.setMaxHp(this.shieldType.getMaxShieldHp());
            shield.setCurrentHp(0.0f);
            shield.setTimeWithoutDamage(0);
            MinecraftForge.EVENT_BUS.post((Event)new ShieldEquippedEvent((EntityPlayer)player, shield));
            if (!player.field_70170_p.field_72995_K) {
                this.updateClient((EntityPlayer)player, shield);
            }
        }
    }

    public void onUnequipped(@Nonnull ItemStack itemstack, @Nonnull EntityLivingBase player) {
        if (player instanceof EntityPlayer && player.hasCapability(SuperiorShieldsCapabilityManager.shieldCapability, null) && !player.field_70170_p.field_72995_K) {
            IShieldCapability shield = (IShieldCapability)player.getCapability(SuperiorShieldsCapabilityManager.shieldCapability, null);
            shield.setMaxHp(0.0f);
            shield.setCurrentHp(0.0f);
            shield.setTimeWithoutDamage(0);
            this.updateClient((EntityPlayer)player, shield);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"superiorshields.tooltip.hp", (Object[])new Object[0]) + " " + this.shieldType.getMaxShieldHp() + " " + I18n.func_135052_a((String)"superiorshields.tooltip.hpDetail", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"superiorshields.tooltip.rechargeDelay", (Object[])new Object[0]) + " " + (float)this.shieldType.getShieldRechargeDelay() / 20.0f + " " + I18n.func_135052_a((String)"superiorshields.tooltip.rechargeDelayTime", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"superiorshields.tooltip.rechargeRate", (Object[])new Object[0]) + " " + 1.0f / ((float)this.shieldType.getShieldRechargeRate() / 20.0f) + " " + I18n.func_135052_a((String)"superiorshields.tooltip.rechargeRateTime", (Object[])new Object[0]));
        if (!(this.shieldType.getEffect() instanceof ShieldEffectNone)) {
            tooltip.add(this.shieldType.getEffect().getDescription());
        }
    }

    protected void updateClient(@Nonnull EntityPlayer player, @Nonnull IShieldCapability shield) {
        if (player instanceof EntityPlayerMP) {
            PacketHandler.INSTANCE.sendTo((IMessage)new PacketShieldUpdate(shield.getCurrentHp(), shield.getMaxHp()), (EntityPlayerMP)player);
        }
    }

    public void triggerShieldEffect(@Nonnull EntityPlayer player, @Nonnull ItemStack stack, @Nullable DamageSource source, float damage, EffectTrigger trigger) {
        if (player.hasCapability(SuperiorShieldsCapabilityManager.shieldCapability, null)) {
            IShieldCapability shield = (IShieldCapability)player.getCapability(SuperiorShieldsCapabilityManager.shieldCapability, null);
            this.shieldType.getEffect().applyEffect(shield, player, source, damage, trigger);
        }
    }
}

