/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.superiorshields.item;

import epicsquid.superiorshields.capability.EnergyCapabilityProvider;
import epicsquid.superiorshields.item.ItemSuperiorShield;
import epicsquid.superiorshields.shield.IEnergyShield;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class ItemEnergyShield
extends ItemSuperiorShield<IEnergyShield> {
    private int energyToConsume = 400;

    public ItemEnergyShield(@Nonnull String name, @Nonnull IEnergyShield shieldType) {
        super(name, shieldType);
    }

    @Override
    protected boolean useEnergyToRecharge(@Nonnull ItemStack stack, @Nonnull EntityPlayer player) {
        IEnergyStorage energy = this.getEnergyStorage(stack);
        if (energy != null && energy.getEnergyStored() > this.energyToConsume) {
            energy.extractEnergy(this.energyToConsume, false);
            return true;
        }
        return false;
    }

    public int getRGBDurabilityForDisplay(@Nonnull ItemStack stack) {
        return ((IEnergyShield)this.shieldType).getColor();
    }

    public boolean showDurabilityBar(@Nonnull ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(@Nonnull ItemStack stack) {
        IEnergyStorage energy = this.getEnergyStorage(stack);
        NBTTagCompound tag = stack.func_77978_p();
        return MathHelper.func_151237_a((double)(1.0 - (double)tag.func_74762_e("energy") / (double)energy.getMaxEnergyStored()), (double)0.0, (double)1.0);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new EnergyCapabilityProvider(((IEnergyShield)this.shieldType).getMaxEnergy(), 0, ((IEnergyShield)this.shieldType).getMaxEnergy(), ((IEnergyShield)this.shieldType).getMaxEnergy(), stack);
    }

    @Nullable
    private IEnergyStorage getEnergyStorage(@Nonnull ItemStack stack) {
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            return (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        }
        return null;
    }
}

