/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.superiorshields.capability.shield;

import epicsquid.superiorshields.capability.shield.IShieldCapability;
import epicsquid.superiorshields.capability.shield.SuperiorShieldsCapabilityManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;

public class ShieldCapabilityProvider
implements ICapabilityProvider,
INBTSerializable,
IShieldCapability {
    private float currentHp;
    private float maxHp;
    private int timeWithoutDamage;

    public ShieldCapabilityProvider(boolean isNewShield) {
        if (isNewShield) {
            this.currentHp = 0.0f;
            this.maxHp = 0.0f;
            this.timeWithoutDamage = 0;
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return SuperiorShieldsCapabilityManager.shieldCapability != null && capability == SuperiorShieldsCapabilityManager.shieldCapability;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == SuperiorShieldsCapabilityManager.shieldCapability) {
            return (T)this;
        }
        return null;
    }

    public NBTBase serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74776_a("maxShieldHp", this.getMaxHp());
        tag.func_74776_a("shieldHp", this.getCurrentHp());
        tag.func_74768_a("timeWithoutDamage", this.getTimeWithoutDamage());
        return tag;
    }

    public void deserializeNBT(NBTBase nbt) {
        if (nbt instanceof NBTTagCompound) {
            NBTTagCompound tag = (NBTTagCompound)nbt;
            if (tag.func_74764_b("maxShieldHp")) {
                this.setMaxHp(tag.func_74760_g("maxShieldHp"));
            }
            if (tag.func_74764_b("shieldHp")) {
                this.setCurrentHp(tag.func_74760_g("shieldHp"));
            }
            if (tag.func_74764_b("timeWithoutDamage")) {
                this.setTimeWithoutDamage(tag.func_74762_e("timeWithoutDamage"));
            }
        }
    }

    @Override
    public float getMaxHp() {
        return this.maxHp;
    }

    @Override
    public float getCurrentHp() {
        return this.currentHp;
    }

    @Override
    public int getTimeWithoutDamage() {
        return this.timeWithoutDamage;
    }

    @Override
    public void setCurrentHp(float currentHp) {
        this.currentHp = currentHp;
        if (this.currentHp < 0.0f) {
            this.currentHp = 0.0f;
        } else if (this.currentHp > this.maxHp) {
            this.currentHp = this.maxHp;
        }
    }

    @Override
    public void setMaxHp(float maxHp) {
        this.maxHp = maxHp;
    }

    @Override
    public void setTimeWithoutDamage(int timeWithoutDamage) {
        this.timeWithoutDamage = timeWithoutDamage;
    }
}

