/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.superiorshields.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyCapabilityProvider
implements ICapabilityProvider,
INBTSerializable,
IEnergyStorage {
    private int maxEnergy;
    private int currentEnergy;
    private int input;
    private int output;
    private ItemStack stack;

    public EnergyCapabilityProvider(int maxEnergy, int currentEnergy, int input, int output, @Nonnull ItemStack stack) {
        this.maxEnergy = maxEnergy > 0 ? maxEnergy : 0;
        this.currentEnergy = currentEnergy > 0 ? currentEnergy : 0;
        this.input = input > 0 ? input : 0;
        this.output = output > 0 ? output : 0;
        this.stack = stack;
        if (stack.func_77978_p() == null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("energy", currentEnergy);
            stack.func_77982_d(tag);
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this;
        }
        return null;
    }

    public NBTBase serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("maxEnergy", this.maxEnergy);
        tag.func_74768_a("currentEnergy", this.currentEnergy);
        tag.func_74768_a("input", this.input);
        tag.func_74768_a("output", this.output);
        return tag;
    }

    public void deserializeNBT(NBTBase nbt) {
        if (nbt instanceof NBTTagCompound) {
            NBTTagCompound tag = (NBTTagCompound)nbt;
            this.maxEnergy = tag.func_74762_e("maxEnergy");
            this.currentEnergy = tag.func_74762_e("currentEnergy");
            this.input = tag.func_74762_e("input");
            this.output = tag.func_74762_e("output");
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyToUpdate = this.currentEnergy;
        if ((energyToUpdate += maxReceive) > this.maxEnergy) {
            return 0;
        }
        if (!simulate) {
            this.currentEnergy = energyToUpdate;
            this.stack.func_77978_p().func_74768_a("energy", this.currentEnergy);
        }
        return maxReceive;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int energyToUpdate = this.currentEnergy;
        if ((energyToUpdate -= maxExtract) < 0) {
            return 0;
        }
        if (!simulate) {
            this.currentEnergy = energyToUpdate;
            this.stack.func_77978_p().func_74768_a("energy", this.currentEnergy);
        }
        return maxExtract;
    }

    public int getEnergyStored() {
        return this.currentEnergy;
    }

    public int getMaxEnergyStored() {
        return this.maxEnergy;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }
}

