/*
 * Decompiled with CFR 0.152.
 */
package tfar.classicbar.overlays.vanillaoverlays;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import tfar.classicbar.ColorUtils;
import tfar.classicbar.ModUtils;
import tfar.classicbar.config.ModConfig;
import tfar.classicbar.overlays.IBarOverlay;

public class MountHealthRenderer
implements IBarOverlay {
    private long healthUpdateCounter = 0L;
    private double mountHealth = 0.0;
    public boolean side;

    @Override
    public IBarOverlay setSide(boolean side) {
        this.side = side;
        return this;
    }

    @Override
    public boolean rightHandSide() {
        return this.side;
    }

    @Override
    public boolean shouldRender(EntityPlayer player) {
        return player.func_184187_bx() instanceof EntityLivingBase;
    }

    @Override
    public void renderBar(EntityPlayer player, int width, int height) {
        boolean highlight;
        int updateCounter = ModUtils.mc.field_71456_v.func_73834_c();
        EntityLivingBase mount = (EntityLivingBase)player.func_184187_bx();
        if (mount.field_70128_L) {
            return;
        }
        double mountHealth = mount.func_110143_aJ();
        boolean bl = highlight = this.healthUpdateCounter > (long)updateCounter && (this.healthUpdateCounter - (long)updateCounter) / 3L % 2L == 1L;
        if (mountHealth < this.mountHealth && player.field_70172_ad > 0) {
            this.healthUpdateCounter = updateCounter + 20;
        } else if (mountHealth > this.mountHealth && player.field_70172_ad > 0) {
            this.healthUpdateCounter = updateCounter + 10;
        }
        this.mountHealth = mountHealth;
        int xStart = width / 2 + 10;
        int yStart = height - this.getSidedOffset();
        double maxHealth = mount.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e();
        ModUtils.mc.field_71424_I.func_76320_a("mountHealth");
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        int i4 = highlight ? 18 : 0;
        ModUtils.drawTexturedModalRect(xStart, yStart, 0, i4, 81, 9);
        ColorUtils.calculateScaledColor(mountHealth, maxHealth, 16).color2Gl();
        float f = xStart + 79 - ModUtils.getWidth(mountHealth, maxHealth);
        ModUtils.drawTexturedModalRect(f, yStart + 1, 1, 10, ModUtils.getWidth(mountHealth, maxHealth), 7);
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        ModUtils.mc.field_71424_I.func_76319_b();
    }

    @Override
    public boolean shouldRenderText() {
        return ModConfig.numbers.showMountHealthNumbers;
    }

    @Override
    public void renderText(EntityPlayer player, int width, int height) {
        int i3;
        int h1 = (int)Math.ceil(this.mountHealth);
        int xStart = width / 2 + 10;
        int yStart = height - this.getSidedOffset();
        EntityLivingBase mount = (EntityLivingBase)player.func_184187_bx();
        double maxHealth = mount.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e();
        int n = i3 = ModConfig.general.displayIcons ? 1 : 0;
        if (ModConfig.numbers.showPercent) {
            h1 = (int)(100.0 * this.mountHealth / maxHealth);
        }
        ModUtils.drawStringOnHUD(h1 + "", xStart + 9 * i3 + 82, yStart - 1, ColorUtils.calculateScaledColor(this.mountHealth, maxHealth, 16).colorToText());
    }

    @Override
    public void renderIcon(EntityPlayer player, int width, int height) {
        int xStart = width / 2 + 10;
        int yStart = height - this.getSidedOffset();
        ModUtils.drawTexturedModalRect(xStart + 82, yStart, 16, 0, 9, 9);
        ModUtils.drawTexturedModalRect(xStart + 82, yStart, 88, 9, 9, 9);
    }

    @Override
    public String name() {
        return "healthmount";
    }
}

