/*
 * Decompiled with CFR 0.152.
 */
package tfar.classicbar.overlays.vanillaoverlays;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import tfar.classicbar.ClassicBar;
import tfar.classicbar.Color;
import tfar.classicbar.ColorUtils;
import tfar.classicbar.ModUtils;
import tfar.classicbar.compat.HungerHelper;
import tfar.classicbar.compat.VampireHelper;
import tfar.classicbar.config.ModConfig;
import tfar.classicbar.overlays.IBarOverlay;

public class HungerRenderer
implements IBarOverlay {
    private float foodAlpha = 0.0f;
    private boolean foodIncrease = true;
    public boolean side;

    @Override
    public IBarOverlay setSide(boolean side) {
        this.side = side;
        return this;
    }

    @Override
    public boolean rightHandSide() {
        return this.side;
    }

    @Override
    public boolean shouldRender(EntityPlayer player) {
        return !ClassicBar.VAMPIRISM || !VampireHelper.isVampire(player);
    }

    @Override
    public void renderBar(EntityPlayer player, int width, int height) {
        double hunger = player.func_71024_bL().func_75116_a();
        double maxHunger = HungerHelper.getMaxHunger(player);
        double currentSat = player.func_71024_bL().func_75115_e();
        float exhaustion = ModUtils.getExhaustion(player);
        int xStart = width / 2 + 10;
        int yStart = height - this.getSidedOffset();
        ModUtils.mc.field_71424_I.func_76320_a("hunger");
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        float alpha2 = hunger / maxHunger <= ModConfig.general.overlays.lowHungerThreshold && ModConfig.general.overlays.lowHungerWarning ? (float)((int)(Minecraft.func_71386_F() / 250L) % 2) : 1.0f;
        Color.reset();
        ModUtils.drawTexturedModalRect(xStart, yStart, 0, 0, 81, 9);
        float f = xStart + 79 - ModUtils.getWidth(hunger, maxHunger);
        boolean hungerActive = player.func_70644_a(MobEffects.field_76438_s);
        ColorUtils.hex2Color(hungerActive ? ModConfig.colors.hungerBarDebuffColor : ModConfig.colors.hungerBarColor).color2Gla(alpha2);
        ModUtils.drawTexturedModalRect(f, yStart + 1, 1, 10, ModUtils.getWidth(hunger, maxHunger), 7);
        if (currentSat > 0.0 && ModConfig.general.overlays.hunger.showSaturationBar) {
            ColorUtils.hex2Color(hungerActive ? ModConfig.colors.saturationBarDebuffColor : ModConfig.colors.saturationBarColor).color2Gla(alpha2);
            ModUtils.drawTexturedModalRect(f += (float)(ModUtils.getWidth(hunger, maxHunger) - ModUtils.getWidth(currentSat, maxHunger)), yStart + 1, 1, 10, ModUtils.getWidth(currentSat, maxHunger), 7);
        }
        if (ModConfig.general.overlays.hunger.showHeldFoodOverlay && player.func_184614_ca().func_77973_b() instanceof ItemFood) {
            ItemStack stack = player.func_184614_ca();
            this.foodAlpha = this.foodIncrease ? (this.foodAlpha += ModConfig.general.overlays.hunger.transitionSpeed) : (this.foodAlpha -= ModConfig.general.overlays.hunger.transitionSpeed);
            if (this.foodAlpha >= 1.0f) {
                this.foodIncrease = false;
            } else if (this.foodAlpha <= 0.0f) {
                this.foodIncrease = true;
            }
            ItemFood foodItem = (ItemFood)stack.func_77973_b();
            double hungerOverlay = foodItem.func_150905_g(stack);
            double saturationMultiplier = foodItem.func_150906_h(stack);
            double potentialSat = 2.0 * hungerOverlay * saturationMultiplier;
            double hungerWidth = Math.min(maxHunger - hunger, hungerOverlay);
            if (hunger < maxHunger) {
                f = xStart - ModUtils.getWidth(hungerWidth + hunger, maxHunger) + 78;
                ColorUtils.hex2Color(hungerActive ? ModConfig.colors.hungerBarDebuffColor : ModConfig.colors.hungerBarColor).color2Gla(this.foodAlpha);
                ModUtils.drawTexturedModalRect(f + 1.0f, yStart + 1, 1, 10, ModUtils.getWidth(hunger + hungerOverlay, maxHunger), 7);
            }
            if (ModConfig.general.overlays.hunger.showSaturationBar) {
                double saturationWidth = Math.min(potentialSat, maxHunger - currentSat);
                saturationWidth = Math.min(saturationWidth, hunger + hungerWidth);
                saturationWidth = Math.min(saturationWidth, hungerOverlay + hunger);
                if (potentialSat + currentSat > hunger + hungerWidth) {
                    double diff = potentialSat + currentSat - (hunger + hungerWidth);
                    saturationWidth = potentialSat - diff;
                }
                f = xStart - ModUtils.getWidth(saturationWidth + currentSat, maxHunger) + 78;
                ColorUtils.hex2Color(hungerActive ? ModConfig.colors.saturationBarDebuffColor : ModConfig.colors.saturationBarColor).color2Gla(this.foodAlpha);
                ModUtils.drawTexturedModalRect(f + 1.0f, yStart + 1, 1, 10, ModUtils.getWidth(saturationWidth + currentSat, maxHunger), 7);
            }
        }
        if (ModConfig.general.overlays.hunger.showExhaustionOverlay) {
            exhaustion = Math.min(exhaustion, 4.0f);
            f = xStart - ModUtils.getWidth(exhaustion, 4.0) + 80;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
            ModUtils.drawTexturedModalRect(f, yStart + 1, 1, 28, ModUtils.getWidth(exhaustion, 4.0), 9);
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        ModUtils.mc.field_71424_I.func_76319_b();
    }

    @Override
    public boolean shouldRenderText() {
        return ModConfig.numbers.showHungerNumbers;
    }

    @Override
    public void renderText(EntityPlayer player, int width, int height) {
        int i3;
        int xStart = width / 2 + 10;
        int yStart = height - this.getSidedOffset();
        double hunger = player.func_71024_bL().func_75116_a();
        boolean hungerActive = player.func_70644_a(MobEffects.field_76438_s);
        int h1 = (int)Math.floor(hunger);
        int n = i3 = ModConfig.general.displayIcons ? 1 : 0;
        if (ModConfig.numbers.showPercent) {
            h1 = (int)hunger * 5;
        }
        int c = Integer.decode(hungerActive ? ModConfig.colors.hungerBarDebuffColor : ModConfig.colors.hungerBarColor);
        if (ModConfig.numbers.showHungerNumbers) {
            ModUtils.drawStringOnHUD(h1 + "", xStart + 9 * i3 + 82, yStart - 1, c);
        }
    }

    @Override
    public void renderIcon(EntityPlayer player, int width, int height) {
        int xStart = width / 2 + 10;
        int yStart = height - this.getSidedOffset();
        ModUtils.mc.func_110434_K().func_110577_a(Gui.field_110324_m);
        boolean hungerActive = player.func_70644_a(MobEffects.field_76438_s);
        int k5 = 52;
        int k6 = 16;
        if (hungerActive) {
            k6 = (k5 += 36) + 45;
        }
        ModUtils.drawTexturedModalRect(xStart + 82, yStart, k6, 27, 9, 9);
        ModUtils.drawTexturedModalRect(xStart + 82, yStart, k5, 27, 9, 9);
    }

    @Override
    public String name() {
        return "food";
    }
}

