/*
 * Decompiled with CFR 0.152.
 */
package tfar.classicbar.overlays.vanillaoverlays;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraftforge.client.GuiIngameForge;
import tfar.classicbar.Color;
import tfar.classicbar.ColorUtils;
import tfar.classicbar.ModUtils;
import tfar.classicbar.config.ModConfig;
import tfar.classicbar.overlays.IBarOverlay;

public class HealthRenderer
implements IBarOverlay {
    private final Minecraft mc = Minecraft.func_71410_x();
    private double playerHealth = 0.0;
    private long healthUpdateCounter = 0L;
    private double lastPlayerHealth = 0.0;
    public boolean side;

    @Override
    public IBarOverlay setSide(boolean side) {
        this.side = side;
        return this;
    }

    @Override
    public boolean rightHandSide() {
        return this.side;
    }

    @Override
    public boolean shouldRender(EntityPlayer player) {
        return true;
    }

    @Override
    public void renderBar(EntityPlayer player, int width, int height) {
        int alpha;
        boolean highlight;
        int updateCounter = this.mc.field_71456_v.func_73834_c();
        double health = player.func_110143_aJ();
        boolean bl = highlight = this.healthUpdateCounter > (long)updateCounter && (this.healthUpdateCounter - (long)updateCounter) / 3L % 2L == 1L;
        if (health < this.playerHealth && player.field_70172_ad > 0) {
            this.healthUpdateCounter = updateCounter + 20;
            this.lastPlayerHealth = this.playerHealth;
        } else if (health > this.playerHealth && player.field_70172_ad > 0) {
            this.healthUpdateCounter = updateCounter + 10;
        }
        this.playerHealth = health;
        double displayHealth = health + (this.lastPlayerHealth - health) * ((double)player.field_70172_ad / (double)player.field_70771_an);
        int xStart = width / 2 - 91;
        int yStart = height - GuiIngameForge.left_height;
        double maxHealth = player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e();
        this.mc.field_71424_I.func_76320_a("health");
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        int k5 = 16;
        if (player.func_70644_a(MobEffects.field_76436_u)) {
            k5 += 36;
        } else if (player.func_70644_a(MobEffects.field_82731_v)) {
            k5 += 72;
        }
        int i4 = highlight ? 18 : 0;
        ModUtils.drawTexturedModalRect(xStart, yStart, 0, i4, 81, 9);
        int n = health <= 0.0 ? 1 : (alpha = health / maxHealth <= ModConfig.general.overlays.lowHealthThreshold && ModConfig.general.overlays.lowHealthWarning ? (int)(Minecraft.func_71386_F() / 250L) % 2 : 1);
        if (displayHealth != health) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            if (displayHealth > health) {
                ModUtils.drawTexturedModalRect(xStart + 1, yStart + 1, 1, 10, ModUtils.getWidth(displayHealth, maxHealth), 7);
            }
        }
        ColorUtils.calculateScaledColor(health, maxHealth, k5).color2Gla(alpha);
        ModUtils.drawTexturedModalRect(xStart + 1, yStart + 1, 1, 10, ModUtils.getWidth(health, maxHealth), 7);
        if (k5 == 52) {
            GlStateManager.func_179131_c((float)0.0f, (float)0.5f, (float)0.0f, (float)0.5f);
            ModUtils.drawTexturedModalRect(xStart + 1, yStart + 1, 1, 36, ModUtils.getWidth(health, maxHealth), 7);
        }
        Color.reset();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        this.mc.field_71424_I.func_76319_b();
    }

    @Override
    public boolean shouldRenderText() {
        return ModConfig.numbers.showHealthNumbers;
    }

    @Override
    public void renderText(EntityPlayer player, int width, int height) {
        int i2;
        double health = player.func_110143_aJ();
        int xStart = width / 2 - 91;
        int yStart = height - GuiIngameForge.left_height;
        double maxHealth = player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e();
        int k5 = 16;
        if (player.func_70644_a(MobEffects.field_76436_u)) {
            k5 += 36;
        } else if (player.func_70644_a(MobEffects.field_82731_v)) {
            k5 += 72;
        }
        int h1 = (int)Math.round(health);
        int n = i2 = ModConfig.general.displayIcons ? 1 : 0;
        if (ModConfig.numbers.showPercent) {
            h1 = (int)(100.0 * health / maxHealth);
        }
        int i1 = ModUtils.getStringLength(h1 + "");
        ModUtils.drawStringOnHUD(h1 + "", xStart - 9 * i2 - i1 + -5, yStart - 1, ColorUtils.calculateScaledColor(health, maxHealth, k5).colorToText());
    }

    @Override
    public void renderIcon(EntityPlayer player, int width, int height) {
        this.mc.func_110434_K().func_110577_a(Gui.field_110324_m);
        int k5 = 16;
        if (player.func_70644_a(MobEffects.field_76436_u)) {
            k5 += 36;
        } else if (player.func_70644_a(MobEffects.field_82731_v)) {
            k5 += 72;
        }
        int xStart = width / 2 - 91;
        int yStart = height - GuiIngameForge.left_height;
        int i5 = player.field_70170_p.func_72912_H().func_76093_s() ? 5 : 0;
        Color.reset();
        ModUtils.drawTexturedModalRect(xStart - 10, yStart, 16, 9 * i5, 9, 9);
        ModUtils.drawTexturedModalRect(xStart - 10, yStart, 36 + k5, 9 * i5, 9, 9);
    }

    @Override
    public String name() {
        return "health";
    }
}

