/*
 * Decompiled with CFR 0.152.
 */
package tfar.classicbar.overlays.modoverlays;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import tfar.classicbar.Color;
import tfar.classicbar.ColorUtils;
import tfar.classicbar.ModUtils;
import tfar.classicbar.config.ModConfig;
import tfar.classicbar.overlays.IBarOverlay;
import toughasnails.api.TANCapabilities;
import toughasnails.api.TANPotions;
import toughasnails.api.config.GameplayOption;
import toughasnails.api.config.ISyncedOption;
import toughasnails.api.config.SyncedConfig;
import toughasnails.api.stat.capability.IThirst;
import toughasnails.handler.thirst.ThirstOverlayHandler;

public class ThirstBarRenderer
implements IBarOverlay {
    public boolean side;

    @Override
    public IBarOverlay setSide(boolean side) {
        this.side = side;
        return this;
    }

    @Override
    public boolean rightHandSide() {
        return this.side;
    }

    @Override
    public boolean shouldRender(EntityPlayer player) {
        return SyncedConfig.getBooleanValue((ISyncedOption)GameplayOption.ENABLE_THIRST);
    }

    @Override
    public void renderBar(EntityPlayer player, int width, int height) {
        IThirst thirstStats = (IThirst)player.getCapability(TANCapabilities.THIRST, null);
        double thirst = thirstStats.getThirst();
        double hydration = thirstStats.getHydration();
        double thirstExhaustion = thirstStats.getExhaustion();
        int xStart = width / 2 + 10;
        int yStart = height - this.getSidedOffset();
        ModUtils.mc.field_71424_I.func_76320_a("thirst");
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        boolean dehydration = player.func_70644_a(TANPotions.thirst);
        Color.reset();
        ModUtils.drawTexturedModalRect(xStart, yStart, 0, 0, 81, 9);
        float f = xStart + 79 - ModUtils.getWidth(thirst, 20.0);
        ColorUtils.hex2Color(dehydration ? ModConfig.mods.deHydrationBarColor : ModConfig.mods.thirstBarColor).color2Gl();
        ModUtils.drawTexturedModalRect(f, yStart + 1, 1, 10, ModUtils.getWidth(thirst, 20.0), 7);
        if (hydration > 0.0) {
            f = xStart + 79 - ModUtils.getWidth(hydration, 20.0);
            ColorUtils.hex2Color(dehydration ? ModConfig.mods.deHydrationSecondaryBarColor : ModConfig.mods.hydrationBarColor).color2Gl();
            ModUtils.drawTexturedModalRect(f, yStart + 1, 1, 10, ModUtils.getWidth(hydration, 20.0), 7);
        }
        thirstExhaustion = Math.min(thirstExhaustion, 4.0);
        f = xStart - ModUtils.getWidth(thirstExhaustion, 4.0) + 80;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
        ModUtils.drawTexturedModalRect(f, yStart + 1, 1, 28, ModUtils.getWidth(thirstExhaustion, 4.0), 9);
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        ModUtils.mc.field_71424_I.func_76319_b();
    }

    @Override
    public boolean shouldRenderText() {
        return ModConfig.numbers.showThirstNumbers;
    }

    @Override
    public void renderText(EntityPlayer player, int width, int height) {
        int xStart = width / 2 + 10;
        int yStart = height - this.getSidedOffset();
        boolean dehydration = player.func_70644_a(TANPotions.thirst);
        IThirst thirstStats = (IThirst)player.getCapability(TANCapabilities.THIRST, null);
        double thirst = thirstStats.getThirst();
        int h1 = (int)Math.floor(thirst);
        int c = Integer.decode(dehydration ? ModConfig.mods.deHydrationBarColor : ModConfig.mods.thirstBarColor);
        if (ModConfig.numbers.showPercent) {
            h1 = (int)thirst * 5;
        }
        ModUtils.drawStringOnHUD(h1 + "", xStart + 9 * (ModConfig.general.displayIcons ? 1 : 0) + 82, yStart - 1, c);
    }

    @Override
    public void renderIcon(EntityPlayer player, int width, int height) {
        int xStart = width / 2 + 10;
        int yStart = height - this.getSidedOffset();
        int backgroundOffset = 0;
        int iconIndex = 0;
        if (player.func_70644_a(TANPotions.thirst)) {
            iconIndex += 4;
            backgroundOffset += 117;
        }
        ModUtils.mc.func_110434_K().func_110577_a(ThirstOverlayHandler.OVERLAY);
        ModUtils.drawTexturedModalRect(xStart + 82, yStart, backgroundOffset, 16, 9, 9);
        ModUtils.drawTexturedModalRect(xStart + 82, yStart, (iconIndex + 4) * 9, 16, 9, 9);
    }

    @Override
    public String name() {
        return "thirst";
    }
}

