/*
 * Decompiled with CFR 0.152.
 */
package tfar.classicbar.overlays.modoverlays;

import lumien.randomthings.item.ItemLavaCharm;
import lumien.randomthings.item.ItemLavaWader;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import tfar.classicbar.ClassicBar;
import tfar.classicbar.Color;
import tfar.classicbar.ColorUtils;
import tfar.classicbar.ModUtils;
import tfar.classicbar.compat.BaublesHelper;
import tfar.classicbar.config.ModConfig;
import tfar.classicbar.overlays.IBarOverlay;

public class LavaCharmRenderer
implements IBarOverlay {
    @GameRegistry.ObjectHolder(value="randomthings:lavacharm")
    public static final Item lava_charm = null;
    public boolean side;
    public static final ResourceLocation ICON_LAVA = new ResourceLocation("randomthings", "textures/gui/lavacharmbar.png");

    @Override
    public boolean rightHandSide() {
        return this.side;
    }

    @Override
    public IBarOverlay setSide(boolean side) {
        this.side = side;
        return this;
    }

    @Override
    public boolean shouldRender(EntityPlayer player) {
        NBTTagCompound nbt;
        ItemStack stack = ItemStack.field_190927_a;
        if (ClassicBar.BAUBLES) {
            stack = BaublesHelper.getLavaWader(player);
        }
        if (stack.func_190926_b()) {
            stack = LavaCharmRenderer.getLavaCharm(player);
        }
        return (nbt = stack.func_77978_p()) != null;
    }

    @Override
    public void renderBar(EntityPlayer player, int width, int height) {
        ItemStack stack = ItemStack.field_190927_a;
        if (ClassicBar.BAUBLES) {
            stack = BaublesHelper.getLavaWader(player);
        }
        if (stack.func_190926_b()) {
            stack = LavaCharmRenderer.getLavaCharm(player);
        }
        NBTTagCompound nbt = stack.func_77978_p();
        int charge = nbt.func_74762_e("charge");
        int xStart = width / 2 - 91;
        int yStart = height - this.getSidedOffset();
        ModUtils.mc.field_71424_I.func_76320_a("charge");
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        Color.reset();
        ModUtils.drawTexturedModalRect(xStart, yStart, 0, 0, 81, 9);
        ColorUtils.hex2Color(ModConfig.mods.lavaBarColor).color2Gl();
        ModUtils.drawTexturedModalRect(xStart + 1, yStart + 1, 1, 10, ModUtils.getWidth(charge, 200.0), 7);
        Color.reset();
        GlStateManager.func_179121_F();
        ModUtils.mc.field_71424_I.func_76319_b();
    }

    @Override
    public boolean shouldRenderText() {
        return ModConfig.numbers.showLavaNumbers;
    }

    @Override
    public void renderText(EntityPlayer player, int width, int height) {
        int xStart = width / 2 - 91;
        int yStart = height - this.getSidedOffset();
        ItemStack stack = ItemStack.field_190927_a;
        if (ClassicBar.BAUBLES) {
            stack = BaublesHelper.getLavaWader(player);
        }
        if (stack.func_190926_b()) {
            stack = LavaCharmRenderer.getLavaCharm(player);
        }
        NBTTagCompound nbt = stack.func_77978_p();
        int charge = nbt.func_74762_e("charge");
        int i2 = charge / 20;
        if (ModConfig.numbers.showPercent) {
            i2 /= 3;
        }
        int i3 = ModUtils.getStringLength(i2 + "");
        int i4 = ModConfig.general.displayIcons ? 1 : 0;
        int c = Integer.decode(ModConfig.mods.lavaBarColor);
        ModUtils.drawStringOnHUD(i2 + "", xStart - 9 * i4 - i3 + -5, yStart - 1, c);
    }

    @Override
    public void renderIcon(EntityPlayer player, int width, int height) {
        ModUtils.mc.func_110434_K().func_110577_a(ICON_LAVA);
        int xStart = width / 2 - 91;
        int yStart = height - this.getSidedOffset();
        ModUtils.drawTexturedModalRect(xStart - 10, yStart, 1, 1, 9, 9);
    }

    @Override
    public String name() {
        return "lavacharm";
    }

    public static ItemStack getLavaCharm(EntityPlayer player) {
        ItemStack stack1 = player.func_184582_a(EntityEquipmentSlot.FEET);
        return LavaCharmRenderer.isWader(stack1) ? stack1 : player.field_71071_by.field_70462_a.stream().filter(LavaCharmRenderer::isCharm).findFirst().orElse(ItemStack.field_190927_a);
    }

    private static boolean isCharm(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemLavaCharm;
    }

    private static boolean isWader(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemLavaWader;
    }
}

