/*
 * Decompiled with CFR 0.152.
 */
package tfar.classicbar.network;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import tfar.classicbar.ClassicBar;
import tfar.classicbar.ModUtils;
import tfar.classicbar.compat.ToughAsNailsHelper;
import tfar.classicbar.network.MessageExhaustionSync;
import tfar.classicbar.network.MessageHungerSync;
import tfar.classicbar.network.MessageHydrationSync;
import tfar.classicbar.network.MessageSaturationSync;
import tfar.classicbar.network.MessageThirstExhaustionSync;

public class SyncHandler {
    public static final SimpleNetworkWrapper CHANNEL = NetworkRegistry.INSTANCE.newSimpleChannel("classicbar");
    private static final Map<UUID, Float> lastSaturationLevels = new HashMap<UUID, Float>();
    private static final Map<UUID, Float> lastExhaustionLevels = new HashMap<UUID, Float>();
    private static final Map<UUID, Float> lastHydrationLevels = new HashMap<UUID, Float>();
    private static final Map<UUID, Float> lastThirstExhaustionLevels = new HashMap<UUID, Float>();
    private static final Map<UUID, Integer> lastHungerLevels = new HashMap<UUID, Integer>();

    public static void init() {
        CHANNEL.registerMessage(MessageExhaustionSync.class, MessageExhaustionSync.class, 1, Side.CLIENT);
        CHANNEL.registerMessage(MessageSaturationSync.class, MessageSaturationSync.class, 2, Side.CLIENT);
        if (ClassicBar.TOUGHASNAILS) {
            CHANNEL.registerMessage(MessageHydrationSync.class, MessageHydrationSync.class, 3, Side.CLIENT);
            CHANNEL.registerMessage(MessageThirstExhaustionSync.class, MessageThirstExhaustionSync.class, 4, Side.CLIENT);
        }
        if (ClassicBar.IBLIS || ClassicBar.RANDOMTWEAKS) {
            CHANNEL.registerMessage(MessageHungerSync.class, MessageHungerSync.class, 5, Side.CLIENT);
        }
        MinecraftForge.EVENT_BUS.register((Object)new SyncHandler());
    }

    @SubscribeEvent
    public void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntity() instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
        Float lastSaturationLevel = lastSaturationLevels.get(player.func_110124_au());
        Float lastHydrationLevel = lastHydrationLevels.get(player.func_110124_au());
        Float lastExhaustionLevel = lastExhaustionLevels.get(player.func_110124_au());
        Float lastThirstExhaustionLevel = lastThirstExhaustionLevels.get(player.func_110124_au());
        Integer lastHungerLevel = lastHungerLevels.get(player.func_110124_au());
        if (lastSaturationLevel == null || lastSaturationLevel.floatValue() != player.func_71024_bL().func_75115_e()) {
            CHANNEL.sendTo((IMessage)new MessageSaturationSync(player.func_71024_bL().func_75115_e()), player);
            lastSaturationLevels.put(player.func_110124_au(), Float.valueOf(player.func_71024_bL().func_75115_e()));
        }
        float exhaustionLevel = ModUtils.getExhaustion((EntityPlayer)player);
        if (lastExhaustionLevel == null || Math.abs(lastExhaustionLevel.floatValue() - exhaustionLevel) >= 0.01f) {
            CHANNEL.sendTo((IMessage)new MessageExhaustionSync(exhaustionLevel), player);
            lastExhaustionLevels.put(player.func_110124_au(), Float.valueOf(exhaustionLevel));
        }
        if (ClassicBar.TOUGHASNAILS) {
            if (lastHydrationLevel == null || lastHydrationLevel.floatValue() != ToughAsNailsHelper.getHandler((EntityPlayer)player).getHydration()) {
                CHANNEL.sendTo((IMessage)new MessageHydrationSync(ToughAsNailsHelper.getHandler((EntityPlayer)player).getHydration()), player);
                lastHydrationLevels.put(player.func_110124_au(), Float.valueOf(ToughAsNailsHelper.getHandler((EntityPlayer)player).getHydration()));
            }
            if (lastThirstExhaustionLevel == null || lastThirstExhaustionLevel.floatValue() != ToughAsNailsHelper.getHandler((EntityPlayer)player).getExhaustion()) {
                CHANNEL.sendTo((IMessage)new MessageThirstExhaustionSync(ToughAsNailsHelper.getHandler((EntityPlayer)player).getExhaustion()), player);
                lastThirstExhaustionLevels.put(player.func_110124_au(), Float.valueOf(ToughAsNailsHelper.getHandler((EntityPlayer)player).getExhaustion()));
            }
        }
        if ((ClassicBar.IBLIS || ClassicBar.RANDOMTWEAKS) && (lastHungerLevel == null || lastHungerLevel.intValue() != player.func_71024_bL().func_75116_a() || player.func_71024_bL().func_75116_a() > 20)) {
            CHANNEL.sendTo((IMessage)new MessageHungerSync(player.func_71024_bL().func_75116_a()), player);
            lastHungerLevels.put(player.func_110124_au(), player.func_71024_bL().func_75116_a());
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!(event.player instanceof EntityPlayerMP)) {
            return;
        }
        lastSaturationLevels.remove(event.player.func_110124_au());
        lastExhaustionLevels.remove(event.player.func_110124_au());
        if (ClassicBar.TOUGHASNAILS) {
            lastHydrationLevels.remove(event.player.func_110124_au());
            lastThirstExhaustionLevels.remove(event.player.func_110124_au());
        }
        if (ClassicBar.IBLIS || ClassicBar.RANDOMTWEAKS) {
            lastHungerLevels.remove(event.player.func_110124_au());
        }
    }
}

