/*
 * Decompiled with CFR 0.152.
 */
package tfar.classicbar.config;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import tfar.classicbar.ClassicBar;
import tfar.classicbar.EventHandler;
import tfar.classicbar.config.IdiotHandler;

@Config(modid="classicbar")
public class ModConfig {
    @Config.Comment(value={"General Options"})
    public static ConfigGeneral general = new ConfigGeneral();
    @Config.Comment(value={"Color Options"})
    public static ConfigColors colors = new ConfigColors();
    @Config.Comment(value={"Number Options"})
    public static ConfigNumbers numbers = new ConfigNumbers();
    @Config.Comment(value={"Warnings"})
    public static ConfigWarnings warnings = new ConfigWarnings();
    @Config.Comment(value={"Mod Options"})
    public static ConfigMods mods = new ConfigMods();

    public static class ConfigMods {
        @Config.Name(value="Lava Bar Color")
        public String lavaBarColor = "#FF8000";
        @Config.Name(value="Thirst Bar Color")
        public String thirstBarColor = "#1C5EE4";
        @Config.Name(value="Flight Bar Color")
        public String flightBarColor = "#FFFFFF";
        @Config.Name(value="Hydration Bar Color")
        public String hydrationBarColor = "#00A3E2";
        @Config.Name(value="Dehydration Bar Color")
        @Config.Comment(value={"This is the overlay for thirst when underneath the effect"})
        public String deHydrationBarColor = "#5A891C";
        @Config.Name(value="Dehydration Secondary Bar Color")
        @Config.Comment(value={"This is the overlay for hydration when underneath the effect"})
        public String deHydrationSecondaryBarColor = "#85CF25";
    }

    @Mod.EventBusSubscriber(modid="classicbar")
    public static class ConfigEventHandler {
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("classicbar")) {
                ConfigManager.sync((String)"classicbar", (Config.Type)Config.Type.INSTANCE);
                IdiotHandler.idiots.idiotsTryingToParseBadHexColorsDOTJpeg();
                IdiotHandler.idiots.emptyArrayFixer();
                EventHandler.setup();
                ClassicBar.logger.info("Syncing Classic Bar Configs");
            }
        }

        @SubscribeEvent
        public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent e) {
            IdiotHandler.idiots.idiotsTryingToParseBadHexColorsDOTJpeg();
            EntityPlayer p = e.player;
            if (Loader.isModLoaded((String)"advancedrocketry") && ModConfig.warnings.advancedRocketryWarning && ModConfig.general.overlays.displayToughnessBar) {
                p.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Toughness bar may not display correctly, change the placement in advanced rocketry config. This is NOT a bug."));
            }
            if (Loader.isModLoaded((String)"rustic") && ModConfig.warnings.rusticWarning) {
                p.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Armor bar may not display correctly, disable Rustic's extra armor overlay amd restart the game. This is NOT a bug."));
            }
        }
    }

    public static class ConfigWarnings {
        @Config.Name(value="Show Advanced Rocketry warning")
        @Config.Comment(value={"Warning when advanced rocketry is installed"})
        public boolean advancedRocketryWarning = true;
        @Config.Name(value="Show Rustic warning")
        @Config.Comment(value={"Warning when Rustic is installed"})
        public boolean rusticWarning = true;
    }

    public static class ConfigColors {
        @Config.Name(value="Advanced Options")
        public AdvancedColors advancedColors = new AdvancedColors();
        @Config.Name(value="Hunger Bar Color")
        public String hungerBarColor = "#B34D00";
        @Config.Name(value="Hunger Debuff Color")
        public String hungerBarDebuffColor = "#249016";
        @Config.Name(value="Oxygen Bar Color")
        public String oxygenBarColor = "#00E6E6";
        @Config.Name(value="Saturation Bar Color")
        public String saturationBarColor = "#FFCC00";
        @Config.Name(value="Saturation Debuff Color")
        public String saturationBarDebuffColor = "#87BC00";

        public class AdvancedColors {
            @Config.Comment(value={"Colors must be specified in #RRGGBB format"})
            @Config.Name(value="Armor color values")
            public String[] armorColorValues = new String[]{"#AAAAAA", "#FF5500", "#FFC747", "#27FFE3", "#00FF00", "#7F00FF"};
            @Config.Name(value="Armor Toughness Bar Color")
            public String[] armorToughnessColorValues = new String[]{"#AAAAAA", "#FF5500", "#FFC747", "#27FFE3", "#00FF00", "#7F00FF"};
            @Config.Name(value="Absorption Bar Color")
            public String[] absorptionColorValues = new String[]{"#D4AF37", "#C2C73B", "#8DC337", "#36BA77", "#4A5BC4", "#D89AE2", "#DF9DC7", "#DFA99D", "#D4DF9D", "#3E84C6", "#B8C1E8", "#DFDFDF"};
            @Config.Name(value="Absorption Poison Bar Color")
            public String[] absorptionPoisonColorValues = new String[]{"#D4AF37", "#C2C73B", "#8DC337", "#36BA77", "#4A5BC4", "#D89AE2", "#DF9DC7", "#DFA99D", "#D4DF9D", "#3E84C6", "#B8C1E8", "#DFDFDF"};
            @Config.Name(value="Absorption Wither Bar Color")
            public String[] absorptionWitherColorValues = new String[]{"#D4AF37", "#C2C73B", "#8DC337", "#36BA77", "#4A5BC4", "#D89AE2", "#DF9DC7", "#DFA99D", "#D4DF9D", "#3E84C6", "#B8C1E8", "#DFDFDF"};
            @Config.Name(value="Health fractions")
            public double[] normalFractions = new double[]{0.25, 0.5, 0.75};
            @Config.Name(value="Colors")
            public String[] normalColors = new String[]{"#FF0000", "#FFFF00", "#00FF00"};
            @Config.Name(value="Poisoned fractions")
            public double[] poisonedFractions = new double[]{0.25, 0.5, 0.75};
            @Config.Name(value="Poisoned Colors")
            public String[] poisonedColors = new String[]{"#00FF00", "#55FF55", "#00FF00"};
            @Config.Name(value="Withered fractions")
            public double[] witheredFractions = new double[]{0.25, 0.5, 0.75};
            @Config.Name(value="Withered Colors")
            public String[] witheredColors = new String[]{"#555555", "#AAAAAA", "#555555"};
        }
    }

    public static class ConfigNumbers {
        private static final String s = "Show Numbers For ";
        @Config.Name(value="Percentage based")
        public boolean showPercent = false;
        @Config.Comment(value={"Numbers info"})
        @Config.Name(value="Show Numbers For Health")
        public boolean showHealthNumbers = true;
        @Config.Name(value="Show Numbers For Lava")
        public boolean showLavaNumbers = true;
        @Config.Name(value="Show Numbers For Hunger")
        public boolean showHungerNumbers = true;
        @Config.Name(value="Show Numbers For Thirst")
        public boolean showThirstNumbers = true;
        @Config.Name(value="Show Numbers For Tiara")
        public boolean showTiaraNumbers = true;
        @Config.Name(value="Show Numbers For Armor Toughness")
        public boolean showArmorToughnessNumbers = true;
        @Config.Name(value="Show Numbers For Armor")
        public boolean showArmorNumbers = true;
        @Config.Name(value="Show Numbers For Mount Health")
        public boolean showMountHealthNumbers;
        @Config.Name(value="Show Numbers For Oxygen Bar")
        public boolean showOxygenNumbers;
        @Config.Name(value="Numbers scale")
        @Config.Comment(value={"unused"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double numberScale = 0.75;
    }

    public static class ConfigGeneral {
        @Config.Name(value="Bar Overlays")
        @Config.Comment(value={"Tweak the bars themselves"})
        public BarOverlays overlays = new BarOverlays();
        @Config.Name(value="Show Icons")
        @Config.Comment(value={"Whether to show icons next to the bars"})
        public boolean displayIcons = true;

        public class BarOverlays {
            @Config.Name(value="Hunger Bar Overlays")
            public HungerBarConfig hunger = new HungerBarConfig();
            @Config.Name(value="Display Armor Toughness Bar")
            public boolean displayToughnessBar = true;
            @Config.Name(value="Draw full absorption Bar")
            public boolean fullAbsorptionBar = false;
            @Config.Name(value="Draw full armor Bar")
            public boolean fullArmorBar = false;
            @Config.Name(value="Draw full toughness Bar")
            public boolean fullToughnessBar = false;
            @Config.Name(value="Display low armor warning")
            public boolean lowArmorWarning = false;
            @Config.Name(value="Display low health warning")
            public boolean lowHealthWarning = true;
            @Config.Name(value="Low health warning threshold")
            @Config.RangeDouble(min=0.0, max=1.0)
            public double lowHealthThreshold = 0.2;
            @Config.Name(value="Display low hunger warning")
            public boolean lowHungerWarning = true;
            @Config.Name(value="Bar left order")
            public String[] leftorder = new String[]{"health", "armor", "absorption", "lavacharm", "lavacharm2"};
            @Config.Name(value="Bar right order")
            public String[] rightorder = new String[]{"blood", "healthmount", "food", "armortoughness", "thirst", "air", "flighttiara", "decay"};
            @Config.Name(value="Low hunger warning threshold")
            public double lowHungerThreshold = 0.3;

            public class HungerBarConfig {
                @Config.Name(value="Show Saturation Bar")
                public boolean showSaturationBar = true;
                @Config.Name(value="Show Hunger Bar While on Mount")
                public boolean showHungerBarOnMount = false;
                @Config.Name(value="Show Held Food Overlay")
                public boolean showHeldFoodOverlay = true;
                @Config.Name(value="Show Exhaustion Overlay")
                public boolean showExhaustionOverlay = true;
                @Config.Name(value="Transistion speed of bar")
                @Config.RangeDouble(min=0.001, max=0.2)
                public float transitionSpeed = 0.02f;
            }
        }
    }
}

