/*
 * Decompiled with CFR 0.152.
 */
package tfar.classicbar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import tfar.classicbar.ModUtils;
import tfar.classicbar.config.ModConfig;
import tfar.classicbar.overlays.IBarOverlay;

public class EventHandler {
    private static final List<IBarOverlay> combined = new ArrayList<IBarOverlay>();
    private static final Map<String, IBarOverlay> registry = new HashMap<String, IBarOverlay>();

    public static void register(IBarOverlay iBarOverlay) {
        registry.put(iBarOverlay.name(), iBarOverlay);
    }

    public static void registerAll(IBarOverlay ... iBarOverlay) {
        Arrays.stream(iBarOverlay).forEach(overlay -> registry.put(overlay.name(), (IBarOverlay)overlay));
    }

    @SubscribeEvent
    public void renderBars(RenderGameOverlayEvent.Pre event) {
        switch (event.getType()) {
            case AIR: 
            case ARMOR: 
            case HEALTHMOUNT: 
            case FOOD: 
            case HEALTH: {
                event.setCanceled(true);
            }
            default: {
                return;
            }
            case ALL: 
        }
        Entity entity = ModUtils.mc.func_175606_aa();
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (player.field_71075_bZ.field_75098_d || player.func_175149_v()) {
            return;
        }
        int scaledWidth = event.getResolution().func_78326_a();
        int scaledHeight = event.getResolution().func_78328_b();
        int initial_right_height = GuiIngameForge.right_height;
        int initial_left_height = GuiIngameForge.left_height;
        ModUtils.mc.func_110434_K().func_110577_a(ModUtils.ICON_BAR);
        Supplier<Stream> supplier = () -> combined.stream().filter(iBarOverlay -> iBarOverlay.shouldRender(player));
        supplier.get().forEach(iBarOverlay -> {
            iBarOverlay.renderBar(player, scaledWidth, scaledHeight);
            if (iBarOverlay.rightHandSide()) {
                GuiIngameForge.right_height += 10;
            } else {
                GuiIngameForge.left_height += 10;
            }
        });
        GuiIngameForge.right_height = initial_right_height;
        GuiIngameForge.left_height = initial_left_height;
        supplier.get().forEach(iBarOverlay -> {
            if (iBarOverlay.shouldRenderText()) {
                iBarOverlay.renderText(player, scaledWidth, scaledHeight);
            }
            if (iBarOverlay.rightHandSide()) {
                GuiIngameForge.right_height += 10;
            } else {
                GuiIngameForge.left_height += 10;
            }
        });
        if (ModConfig.general.displayIcons) {
            GuiIngameForge.right_height = initial_right_height;
            GuiIngameForge.left_height = initial_left_height;
            supplier.get().forEach(iBarOverlay -> {
                iBarOverlay.renderIcon(player, scaledWidth, scaledHeight);
                if (iBarOverlay.rightHandSide()) {
                    GuiIngameForge.right_height += 10;
                } else {
                    GuiIngameForge.left_height += 10;
                }
            });
        }
        ModUtils.mc.func_110434_K().func_110577_a(Gui.field_110324_m);
    }

    public static void setup() {
        combined.clear();
        Arrays.stream(ModConfig.general.overlays.leftorder).filter(s -> registry.get(s) != null).forEach(e -> combined.add(registry.get(e).setSide(false)));
        Arrays.stream(ModConfig.general.overlays.rightorder).filter(s -> registry.get(s) != null).forEach(e -> combined.add(registry.get(e).setSide(true)));
    }
}

