/*
 * Decompiled with CFR 0.152.
 */
package tfar.classicbar;

import java.util.regex.Pattern;
import tfar.classicbar.Color;
import tfar.classicbar.config.ModConfig;

public class ColorUtils {
    public static final Pattern p1 = Pattern.compile("^#[0-9A-Fa-f]{6}$");

    public static Color hex2Color(String s) {
        int i1 = Integer.decode(s);
        int r = i1 >> 16 & 0xFF;
        int g = i1 >> 8 & 0xFF;
        int b = i1 & 0xFF;
        return new Color(r, g, b);
    }

    public static Color calculateScaledColor(double d1, double d2, int effect) {
        double[] colorFractions;
        String[] colorCodes;
        double d3 = d1 / d2;
        switch (effect) {
            case 16: {
                colorCodes = ModConfig.colors.advancedColors.normalColors;
                colorFractions = ModConfig.colors.advancedColors.normalFractions;
                break;
            }
            case 52: {
                colorCodes = ModConfig.colors.advancedColors.poisonedColors;
                colorFractions = ModConfig.colors.advancedColors.poisonedFractions;
                break;
            }
            case 88: {
                colorCodes = ModConfig.colors.advancedColors.witheredColors;
                colorFractions = ModConfig.colors.advancedColors.witheredFractions;
                break;
            }
            default: {
                return Color.BLACK;
            }
        }
        if (colorCodes.length != colorFractions.length) {
            return Color.BLACK;
        }
        int i1 = colorFractions.length - 1;
        int i3 = 0;
        for (int i2 = 0; i2 < i1 && !(d3 < colorFractions[i2]); ++i2) {
            ++i3;
        }
        if (d3 <= colorFractions[0]) {
            return ColorUtils.hex2Color(colorCodes[0]);
        }
        if (d3 >= colorFractions[colorFractions.length - 1]) {
            return ColorUtils.hex2Color(colorCodes[colorFractions.length - 1]);
        }
        Color c1 = ColorUtils.hex2Color(colorCodes[i3 - 1]);
        Color c2 = ColorUtils.hex2Color(colorCodes[i3]);
        double d4 = (d3 - colorFractions[i3 - 1]) / (colorFractions[i3] - colorFractions[i3 - 1]);
        return c1.colorBlend(c2, d4);
    }
}

