/*
 * Decompiled with CFR 0.152.
 */
package tfar.classicbar;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;
import tfar.classicbar.EventHandler;
import tfar.classicbar.config.ModConfig;
import tfar.classicbar.network.SyncHandler;
import tfar.classicbar.overlays.modoverlays.DecayRenderer;
import tfar.classicbar.overlays.modoverlays.LavaCharmRenderer;
import tfar.classicbar.overlays.modoverlays.LavaWaderBaubleRenderer;
import tfar.classicbar.overlays.modoverlays.ThirstBarRenderer;
import tfar.classicbar.overlays.modoverlays.TiaraBarRenderer;
import tfar.classicbar.overlays.modoverlays.VampireRenderer;
import tfar.classicbar.overlays.vanillaoverlays.AbsorptionRenderer;
import tfar.classicbar.overlays.vanillaoverlays.AirRenderer;
import tfar.classicbar.overlays.vanillaoverlays.ArmorRenderer;
import tfar.classicbar.overlays.vanillaoverlays.ArmorToughnessRenderer;
import tfar.classicbar.overlays.vanillaoverlays.HealthRenderer;
import tfar.classicbar.overlays.vanillaoverlays.HungerRenderer;
import tfar.classicbar.overlays.vanillaoverlays.MountHealthRenderer;

@Mod.EventBusSubscriber(value={Side.CLIENT})
@Mod(modid="classicbar", name="Classic Bar", version="@VERSION@", useMetadata=true, dependencies="after:randomtweaks@[1.12.2-2.7.1.0,);", clientSideOnly=true, acceptedMinecraftVersions="[1.12.2]")
public class ClassicBar {
    public static final String MODID = "classicbar";
    public static final String MODNAME = "Classic Bar";
    public static final String MODVERSION = "@VERSION@";
    public static final String DEPENDENCIES = "after:randomtweaks@[1.12.2-2.7.1.0,);";
    public static final String[] problemMods = new String[]{"mantle", "toughasnails"};
    public static final boolean TOUGHASNAILS = Loader.isModLoaded((String)"toughasnails");
    public static final boolean IBLIS = Loader.isModLoaded((String)"iblis");
    public static final boolean BAUBLES = Loader.isModLoaded((String)"baubles");
    public static final boolean RANDOMTWEAKS = Loader.isModLoaded((String)"randomtweaks");
    public static final boolean PITWEAKS = Loader.isModLoaded((String)"pitweaks");
    public static final boolean BETWEENLANDS = Loader.isModLoaded((String)"thebetweenlands");
    public static final boolean VAMPIRISM = Loader.isModLoaded((String)"vampirism");
    public static final boolean HUNGERCHANGED = IBLIS || RANDOMTWEAKS || PITWEAKS;
    public static Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        SyncHandler.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ModConfig.ConfigEventHandler());
        logger.info("Registering Vanilla Overlay");
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        EventHandler.registerAll(new AbsorptionRenderer(), new AirRenderer(), new ArmorRenderer(), new ArmorToughnessRenderer(), new HealthRenderer(), new HungerRenderer(), new MountHealthRenderer());
        logger.info("Registering Mod Overlays");
        if (Loader.isModLoaded((String)"randomthings")) {
            EventHandler.register(new LavaCharmRenderer());
        }
        if (Loader.isModLoaded((String)"lavawaderbauble")) {
            EventHandler.register(new LavaWaderBaubleRenderer());
        }
        if (BETWEENLANDS) {
            EventHandler.register(new DecayRenderer());
        }
        if (TOUGHASNAILS) {
            EventHandler.register(new ThirstBarRenderer());
        }
        if (Loader.isModLoaded((String)"botania")) {
            EventHandler.register(new TiaraBarRenderer());
        }
        if (VAMPIRISM) {
            EventHandler.register(new VampireRenderer());
        }
        EventHandler.setup();
        boolean areProblemModsPresent = Arrays.stream(problemMods).anyMatch(Loader::isModLoaded);
        if (areProblemModsPresent) {
            logger.info("Unregistering problematic overlays.");
            try {
                Field f = EventBus.class.getDeclaredField("listeners");
                f.setAccessible(true);
                ConcurrentHashMap listeners = (ConcurrentHashMap)f.get(MinecraftForge.EVENT_BUS);
                ((ConcurrentHashMap.KeySetView)listeners.keySet()).forEach(key -> {
                    String s = key.getClass().getCanonicalName();
                    if ("slimeknights.mantle.client.ExtraHeartRenderHandler".equals(s)) {
                        logger.info("Unregistered Mantle bar");
                        MinecraftForge.EVENT_BUS.unregister(key);
                    } else if ("toughasnails.handler.thirst.ThirstOverlayHandler".equals(s)) {
                        logger.info("Unregistered Thirst bar");
                        MinecraftForge.EVENT_BUS.unregister(key);
                    }
                });
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }
}

