/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.tileentity;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.event.EventFactory;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.tileentity.TileEntityWritableGrave;

public class TileEntityTombstone
extends TileEntityWritableGrave {
    private static final List<BlockPos> posForRemoval = new ArrayList<BlockPos>();
    protected final ItemStackHandler inventory = new ItemStackHandler(120);
    @Nullable
    private UUID ownerId = null;
    protected boolean needAccess = false;

    @Override
    public boolean canShowFog() {
        return true;
    }

    public void func_145843_s() {
        this.field_145846_f = TileEntityTombstone.removeTile(this.field_174879_c);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)(facing == null ? this.inventory : null);
        }
        return (T)super.getCapability(capability, facing);
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    public void giveInventory(@Nullable EntityPlayer player) {
        if (this.field_145850_b.field_72995_K || player == null || player instanceof FakePlayer) {
            return;
        }
        EventFactory.onRestoreInventory(player, this);
        for (int i2 = this.inventory.getSlots() - 1; i2 >= 0; --i2) {
            if (!ovh.corail.tombstone.helper.InventoryHelper.autoequip(this.inventory.getStackInSlot(i2), player)) continue;
            this.inventory.setStackInSlot(i2, ItemStack.field_190927_a);
        }
        IntStream.range(0, this.inventory.getSlots()).forEach(i -> {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (!stack.func_190926_b()) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stack.func_77946_l());
                this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
            }
        });
        this.removeGraveBy(player);
        EntityHelper.capPotionDuration((EntityLivingBase)player, ModEffects.ghostly_shape, 100);
        player.field_71069_bz.func_75142_b();
        LangKey.MESSAGE_OPEN_GRAVE_SUCCESS.sendSpecialMessage((ICommandSender)player, new Object[0]);
    }

    public void dropOnGroundAndRemove() {
        if (this.field_145850_b == null) {
            return;
        }
        IntStream.range(0, this.inventory.getSlots()).forEach(i -> {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (!stack.func_190926_b()) {
                InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)stack.func_77946_l());
                this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
            }
        });
        this.removeGraveBy(null);
    }

    private void removeGraveBy(@Nullable EntityPlayer player) {
        if (this.field_145850_b == null) {
            return;
        }
        DeathHandler.INSTANCE.removeGrave(new Location(this.field_174879_c, this.field_145850_b));
        Helper.removeNoEvent(this.field_145850_b, this.field_174879_c);
        if (player != null) {
            this.field_145850_b.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187873_gM, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        TileEntityTombstone.setTileForRemoval(this.field_174879_c);
        this.field_145850_b.func_175713_t(this.field_174879_c);
    }

    public <T extends Entity> void setOwner(T owner, long deathDate, boolean needAccess) {
        super.setOwner(owner, deathDate);
        this.ownerId = owner.func_110124_au();
        this.needAccess = needAccess;
    }

    public boolean isOwner(EntityPlayer owner) {
        return this.ownerId == null ? this.hasOwner() && this.ownerName.equals(owner.func_146103_bH().getName()) : this.ownerId.equals(owner.func_110124_au());
    }

    public boolean getNeedAccess() {
        return this.needAccess && (ConfigTombstone.general.decayTime == -1 || !TimeHelper.isSystemTimeElapsed(this.deathDate, TimeUnit.MINUTES.toMillis(ConfigTombstone.general.decayTime)));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        if (this.ownerId != null) {
            compound.func_186854_a("owner_id", this.ownerId);
        }
        compound.func_74757_a("needAccess", this.needAccess);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_150297_b("inventory", 10)) {
            this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        }
        if (compound.func_186855_b("owner_id")) {
            this.ownerId = compound.func_186857_a("owner_id");
        }
        this.needAccess = compound.func_74767_n("needAccess");
    }

    public AxisAlignedBB getRenderBoundingBox() {
        double renderExtension = 1.0;
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n() - renderExtension, (double)this.field_174879_c.func_177956_o() - renderExtension, (double)this.field_174879_c.func_177952_p() - renderExtension, (double)(this.field_174879_c.func_177958_n() + 1) + renderExtension, (double)(this.field_174879_c.func_177956_o() + 1) + renderExtension, (double)(this.field_174879_c.func_177952_p() + 1) + renderExtension);
    }

    public static boolean removeTile(BlockPos pos) {
        return posForRemoval.remove(pos);
    }

    public static void setTileForRemoval(BlockPos pos) {
        posForRemoval.add(pos);
    }
}

