/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.api.capability.ModPerks;
import ovh.corail.tombstone.block.BlockGrave;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.item.ItemCraftingIngredient;
import ovh.corail.tombstone.item.ItemScrollBuff;
import ovh.corail.tombstone.item.ItemVoodooPoppet;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;

public class DeathHandler {
    public static final DeathHandler INSTANCE = new DeathHandler();
    private final HashMap<UUID, GraveModel> optionFavoriteGrave = new HashMap();
    private final HashMap<UUID, Boolean> optionEquipElytraInPriority = new HashMap();
    private final HashMap<UUID, Boolean> optionKnowledgeMessage = new HashMap();
    private final HashMap<UUID, List<PotionEffect>> playerDeadList = new HashMap();
    private final HashMap<String, Location> lastGraveList = new HashMap();

    private DeathHandler() {
    }

    public List<String> getLastGraveList() {
        return new ArrayList<String>(this.lastGraveList.keySet());
    }

    public Location getLastGrave(String playerName) {
        return this.lastGraveList.getOrDefault(playerName, Location.ORIGIN);
    }

    public void removeGrave(Location pos) {
        Iterator<Map.Entry<String, Location>> it = this.lastGraveList.entrySet().iterator();
        while (it.hasNext()) {
            Location gravePos = it.next().getValue();
            if (!gravePos.equals(pos)) continue;
            it.remove();
        }
    }

    public void logLastGrave(@Nullable EntityPlayer player, int x, int y, int z, int dim) {
        if (player == null) {
            return;
        }
        this.lastGraveList.put(player.func_70005_c_(), new Location(x, y, z, dim));
        if (ConfigTombstone.general.logPlayerGrave) {
            LangKey.MESSAGE_LOG_LAST_GRAVE.sendLog(player.func_70005_c_(), LangKey.MESSAGE_LAST_GRAVE.getServerTranslation(new Object[0]), x, y, z, dim);
        }
    }

    public boolean isNoGraveLocation(Location location) {
        for (int i = 0; i < ConfigTombstone.general.noGraveLocation.length; ++i) {
            String[] res;
            if (ConfigTombstone.general.noGraveLocation[i].isEmpty() || !((res = ConfigTombstone.general.noGraveLocation[i].split(",")).length == 5 ? new Location(Integer.valueOf(res[0].trim()), Integer.valueOf(res[1].trim()), Integer.valueOf(res[2].trim()), (int)Integer.valueOf(res[3].trim())).isInRangeAndDimension(location, Integer.valueOf(res[4].trim())) : res.length == 1 && location.dim == Integer.valueOf(res[0].trim()))) continue;
            return true;
        }
        return false;
    }

    public void addPlayerDead(EntityPlayer player) {
        UUID playerUUID = player.func_110124_au();
        ArrayList<PotionEffect> effectsList = new ArrayList<PotionEffect>();
        if (ConfigTombstone.general.restoreEffectsOnDeath || EntityHelper.isPotionActive((EntityLivingBase)player, ModEffects.preservation)) {
            for (PotionEffect effect : player.func_70651_bq()) {
                if (!Helper.isAllowedEffect(effect.func_188419_a())) continue;
                effectsList.add(effect);
            }
        }
        this.playerDeadList.put(playerUUID, effectsList);
    }

    public void restorePlayerDead(EntityPlayer player) {
        UUID playerUUID;
        List<PotionEffect> effectsList;
        if (!this.isPlayerDead(player)) {
            return;
        }
        if (!(Helper.isDisabledPerk(ModPerks.ghostly_shape) || SupportMods.DIM_DOORS.isLoaded() && player.field_70170_p.field_73011_w.func_186058_p().func_186065_b().equals("limbo"))) {
            EntityHelper.addPotion((EntityLivingBase)player, ModEffects.ghostly_shape, ConfigTombstone.general.getGhostlyShapeDuration() * 20, EntityHelper.getPerkLevelWithBonus(player, ModPerks.ghostly_shape), new boolean[0]);
        }
        if ((effectsList = this.playerDeadList.get(playerUUID = player.func_110124_au())) == null) {
            return;
        }
        for (PotionEffect effect : effectsList) {
            if (!Helper.isAllowedEffect(effect.func_188419_a())) continue;
            PotionEffect activeEffect = player.func_70660_b(effect.func_188419_a());
            if (activeEffect != null) {
                if (activeEffect.func_76459_b() >= effect.func_76459_b()) continue;
                player.func_184589_d(activeEffect.func_188419_a());
            }
            player.func_70690_d(effect);
        }
        this.playerDeadList.remove(playerUUID);
    }

    public boolean isPlayerDead(EntityPlayer player) {
        return this.playerDeadList.containsKey(player.func_110124_au());
    }

    public DeathHandler setOptionFavoriteGrave(UUID id, @Nullable GraveModel graveType) {
        this.optionFavoriteGrave.put(id, graveType != null ? graveType : GraveModel.getDefaultGrave());
        return this;
    }

    public BlockGrave getFavoriteGraveBlock(UUID id) {
        switch (this.optionFavoriteGrave.getOrDefault(id, GraveModel.getDefaultGrave())) {
            case GRAVE_CROSS: {
                return ModBlocks.grave_cross;
            }
            case GRAVE_NORMAL: {
                return ModBlocks.grave_normal;
            }
            case TOMBSTONE: {
                return ModBlocks.tombstone;
            }
        }
        return ModBlocks.grave_simple;
    }

    public DeathHandler setOptionEquipElytraInPriority(UUID id, boolean value) {
        this.optionEquipElytraInPriority.put(id, value);
        return this;
    }

    public boolean getOptionEquipElytraInPriority(UUID id) {
        return this.optionEquipElytraInPriority.getOrDefault(id, false);
    }

    public DeathHandler setOptionKnowledgeMessage(UUID id, boolean value) {
        this.optionKnowledgeMessage.put(id, value);
        return this;
    }

    public boolean getOptionKnowledgeMessage(UUID id) {
        return this.optionKnowledgeMessage.getOrDefault(id, true);
    }

    public void handleMobDrops(EntityLivingBase entity, @Nullable DamageSource damageSource, List<EntityItem> drops) {
        EntityPlayerMP player;
        EntityPlayerMP entityPlayerMP = player = damageSource != null && EntityHelper.isValidPlayerMP(damageSource.func_76346_g()) ? (EntityPlayerMP)damageSource.func_76346_g() : null;
        if (entity.func_70662_br()) {
            int chanceModifier = EntityHelper.getPerkLevelWithBonus((EntityPlayer)player, ModPerks.bone_collector) * 100;
            if (Helper.getRandom(1, 1000 - chanceModifier) <= ConfigTombstone.loot.chanceGraveDust + chanceModifier) {
                drops.add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, ItemCraftingIngredient.IconType.GRAVE_DUST.getStack(Helper.getRandom(1, 2))));
            }
            if (ConfigTombstone.loot.undeadCanDropSkull && (entity instanceof EntitySkeleton || entity instanceof EntityZombie) && Helper.getRandom(1, 1000 - chanceModifier) <= 5) {
                ItemStack skullStack = new ItemStack(Items.field_151144_bL, 1, entity instanceof EntitySkeleton ? 0 : 2);
                drops.add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, skullStack));
            }
            if (!entity.func_184222_aU()) {
                ItemStack stack;
                if (ConfigTombstone.loot.chanceSoulReceptacleOnBoss > 0 && Helper.getRandom(1, 1000 - chanceModifier) < ConfigTombstone.loot.chanceSoulReceptacleOnBoss) {
                    drops.add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack((Item)ModItems.soul_receptacle)));
                }
                if (ConfigTombstone.loot.chanceRandomScrollOnBoss > 0 && Helper.getRandom(1, 1000 - chanceModifier) < ConfigTombstone.loot.chanceRandomScrollOnBoss) {
                    stack = new ItemStack((Item)ModItems.scroll_buff, 1, ItemScrollBuff.SpellBuff.getRandomBuff().ordinal());
                    NBTStackHelper.setBoolean(stack, "enchant", true);
                    drops.add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, stack));
                }
                if (ConfigTombstone.loot.chanceRandomPoppetOnBoss > 0 && Helper.getRandom(1, 1000 - chanceModifier) < ConfigTombstone.loot.chanceRandomPoppetOnBoss) {
                    stack = new ItemStack((Item)ModItems.voodoo_poppet);
                    ModItems.voodoo_poppet.addProtection(stack, ItemVoodooPoppet.PoppetProtections.getRandomProtection());
                    NBTStackHelper.setBoolean(stack, "enchant", true);
                    drops.add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, stack));
                }
                if (player != null && ConfigTombstone.loot.chanceDecorativeGraveOnBoss > 0 && Helper.getRandom(1, 1000 - chanceModifier) < ConfigTombstone.loot.chanceDecorativeGraveOnBoss) {
                    drops.add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack((Block)this.getFavoriteGraveBlock(player.func_110124_au()))));
                }
            }
        }
        if (entity instanceof EntityMob && player != null && (Helper.isContributor((EntityPlayer)player) || Helper.isDateAroundHalloween(player.field_70170_p)) && Helper.getRandom(1, 1000) <= 100) {
            drops.add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(ModItems.lollypop, 1, Helper.getRandom(0, 4))));
        }
    }

    public void clear() {
        this.optionFavoriteGrave.clear();
        this.optionEquipElytraInPriority.clear();
        this.optionKnowledgeMessage.clear();
        this.playerDeadList.clear();
        this.lastGraveList.clear();
    }
}

