/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.compatibility;

import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.api.WailaPlugin;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import ovh.corail.tombstone.block.BlockDecorativeGrave;
import ovh.corail.tombstone.block.BlockGrave;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.registry.ModBlocks;

@WailaPlugin
public class IntegrationHwyla
implements IWailaPlugin {
    public void register(IWailaRegistrar registrar) {
        IWailaDataProvider provider = new IWailaDataProvider(){

            @Nonnull
            public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
                BlockDecorativeGrave block;
                GraveModel model = ((BlockGrave)accessor.getBlock()).getGraveType();
                switch (model) {
                    case GRAVE_NORMAL: {
                        block = ModBlocks.decorative_grave_normal;
                        break;
                    }
                    case GRAVE_CROSS: {
                        block = ModBlocks.decorative_grave_cross;
                        break;
                    }
                    case TOMBSTONE: {
                        block = ModBlocks.decorative_tombstone;
                        break;
                    }
                    default: {
                        block = ModBlocks.decorative_grave_simple;
                    }
                }
                Item item = (Item)ForgeRegistries.ITEMS.getValue(block.getRegistryName());
                return item != null && item != Items.field_190931_a ? new ItemStack(item) : ItemStack.field_190927_a;
            }

            @Nonnull
            public List<String> getWailaHead(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
                String translation = TextFormatting.WHITE + accessor.getBlock().func_149732_F();
                if (tooltip.isEmpty()) {
                    tooltip.add(translation);
                } else {
                    tooltip.set(0, translation);
                }
                return tooltip;
            }
        };
        registrar.registerStackProvider(provider, BlockGrave.class);
        registrar.registerHeadProvider(provider, BlockGrave.class);
    }
}

