/*
 * Decompiled with CFR 0.152.
 */
package jco2641.thaumcomp.items;

import li.cil.oc.api.Driver;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.golems.GolemHelper;
import thaumcraft.api.golems.ISealDisplayer;
import thaumcraft.api.golems.seals.ISealEntity;
import thaumcraft.api.golems.seals.SealPos;

public class ItemSealConnector
extends Item
implements ISealDisplayer {
    public ItemSealConnector() {
        this.setRegistryName("sealconnector");
        this.func_77655_b("thaumcomp.sealconnector");
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabs.field_78026_f);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    int tierFromDriver(ItemStack stack) {
        return Driver.driverFor((ItemStack)stack).tier(stack);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            if (stack.func_77942_o()) {
                NBTTagCompound data = stack.func_77978_p();
                if (data.func_82582_d()) {
                    player.func_145747_a((ITextComponent)new TextComponentString("Seal connector not bound"));
                    return new ActionResult(EnumActionResult.PASS, (Object)stack);
                }
                if (!player.func_70093_af()) {
                    if (!data.func_74764_b("thaumcomp:coord") || !data.func_74764_b("thaumcomp:sealName")) {
                        player.func_145747_a((ITextComponent)new TextComponentString("Seal connector not bound"));
                        return new ActionResult(EnumActionResult.PASS, (Object)stack);
                    }
                    int[] tag = data.func_74759_k("thaumcomp:coord");
                    String face = EnumFacing.func_82600_a((int)tag[4]).func_176610_l();
                    String nameTag = data.func_74779_i("thaumcomp:sealName");
                    TextComponentString message = new TextComponentString("Seal connector bound to:\n");
                    message.func_150257_a((ITextComponent)new TextComponentTranslation(nameTag, new Object[0]));
                    message.func_150258_a(String.format(" Dim: %d X: %d Y: %d Z: %d Face: %s", tag[3], tag[0], tag[1], tag[2], face));
                    player.func_145747_a((ITextComponent)message);
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                }
                data.func_82580_o("thaumcomp:sealName");
                data.func_82580_o("thaumcomp:coord");
                player.func_145747_a((ITextComponent)new TextComponentString("Seal connector binding removed"));
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            player.func_145747_a((ITextComponent)new TextComponentString("Seal connector not bound"));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                int dim = world.field_73011_w.getDimension();
                ISealEntity se = GolemHelper.getSealEntity((int)dim, (SealPos)new SealPos(pos, side));
                if (se != null) {
                    if (se.getOwner().equalsIgnoreCase(player.func_110124_au().toString()) || player.field_71075_bZ.field_75098_d) {
                        player.func_184609_a(hand);
                        if (!stack.func_77942_o()) {
                            stack.func_77982_d(new NBTTagCompound());
                        }
                        NBTTagCompound data = stack.func_77978_p();
                        String sealtype = se.getSeal().getKey();
                        String sealULName = String.format("item.seal.%s.name", sealtype.split(":")[1]);
                        data.func_74778_a("thaumcomp:sealName", sealULName);
                        data.func_74783_a("thaumcomp:coord", new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), dim, side.func_176745_a()});
                        TextComponentString message = new TextComponentString("Binding to:\n");
                        message.func_150257_a((ITextComponent)new TextComponentTranslation(sealULName, new Object[0]));
                        message.func_150258_a(String.format("\nDim: %d\nX: %d\nY: %d\nZ: %d\nFace: %s", dim, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), side.func_176610_l()));
                        player.func_145747_a((ITextComponent)message);
                        return EnumActionResult.SUCCESS;
                    }
                    player.func_145747_a((ITextComponent)new TextComponentString("That is not your seal"));
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentString("No seal there"));
                }
            } else if (stack.func_77942_o()) {
                NBTTagCompound data = stack.func_77978_p();
                if (data.func_74764_b("thaumcomp:coord") && data.func_74764_b("thaumcomp:sealName")) {
                    int[] tag = data.func_74759_k("thaumcomp:coord");
                    String face = EnumFacing.func_82600_a((int)tag[4]).func_176610_l();
                    String nameTag = data.func_74779_i("thaumcomp:sealName");
                    TextComponentString message = new TextComponentString("Seal connector bound to:\n");
                    message.func_150257_a((ITextComponent)new TextComponentTranslation(nameTag, new Object[0]));
                    message.func_150258_a(String.format(" Dim: %d X: %d Y: %d Z: %d Face: %s", tag[3], tag[0], tag[1], tag[2], face));
                    player.func_145747_a((ITextComponent)message);
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentString("Seal connector not bound"));
                }
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString("Seal connector not bound"));
            }
        }
        return EnumActionResult.SUCCESS;
    }
}

