/*
 * Decompiled with CFR 0.152.
 */
package jco2641.thaumcomp.golems.seals;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import jco2641.thaumcomp.config.ModConfig;
import jco2641.thaumcomp.util.ManagedTileEntityEnvironment;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.UsernameCache;
import thaumcraft.api.golems.EnumGolemTrait;
import thaumcraft.api.golems.seals.ISealConfigArea;
import thaumcraft.api.golems.seals.ISealConfigFilter;
import thaumcraft.api.golems.seals.ISealConfigToggles;
import thaumcraft.api.golems.seals.ISealEntity;

public final class EnvironmentSealEntity
extends ManagedTileEntityEnvironment<ISealEntity> {
    private World world;

    public EnvironmentSealEntity(ISealEntity te, World world) {
        super(te, "golem_seal");
        this.world = world;
    }

    @Callback(doc="function:table -- Get the tags golems must not have to obey this seal")
    public Object[] getForbiddenTags(Context context, Arguments args) {
        EnumGolemTrait[] tags = ((ISealEntity)this.tileEntity).getSeal().getForbiddenTags();
        ArrayList<String> out = new ArrayList<String>();
        if (tags == null || tags.length < 1) {
            return new Object[]{"No tags"};
        }
        for (EnumGolemTrait trait : tags) {
            out.add(trait.getLocalizedName());
        }
        return new Object[]{out};
    }

    @Callback(doc="function:table -- Get the tags golems must have to obey this seal")
    public Object[] getRequiredTags(Context context, Arguments args) {
        EnumGolemTrait[] tags = ((ISealEntity)this.tileEntity).getSeal().getRequiredTags();
        ArrayList<String> out = new ArrayList<String>();
        if (tags == null || tags.length < 1) {
            return new Object[]{"No tags"};
        }
        for (EnumGolemTrait trait : tags) {
            out.add(trait.getLocalizedName());
        }
        return new Object[]{out};
    }

    @Callback(doc="function():string -- Get the type of the seal")
    public Object[] getType(Context context, Arguments args) {
        String sealType = ((ISealEntity)this.tileEntity).getSeal().getKey();
        String sealULName = String.format("item.seal.%s.name", sealType.split(":")[1]);
        return new Object[]{I18n.func_135052_a((String)sealULName, (Object[])new Object[0])};
    }

    @Callback(doc="function():table -- Get the filter properties and contents")
    public Object[] getFilter(Context context, Arguments args) {
        if (((ISealEntity)this.tileEntity).getSeal() instanceof ISealConfigFilter) {
            boolean blacklist = ((ISealConfigFilter)((ISealEntity)this.tileEntity).getSeal()).isBlacklist();
            boolean limited = ((ISealConfigFilter)((ISealEntity)this.tileEntity).getSeal()).hasStacksizeLimiters();
            int filterSize = ((ISealConfigFilter)((ISealEntity)this.tileEntity).getSeal()).getFilterSize();
            HashMap<ItemStack, Integer> items = new HashMap<ItemStack, Integer>();
            HashMap<String, Serializable> out = new HashMap<String, Serializable>();
            out.put("blacklist", Boolean.valueOf(blacklist));
            out.put("limited", Boolean.valueOf(limited));
            for (int i = 0; i < filterSize; ++i) {
                items.put(((ISealConfigFilter)((ISealEntity)this.tileEntity).getSeal()).getFilterSlot(i), ((ISealConfigFilter)((ISealEntity)this.tileEntity).getSeal()).getFilterSlotSize(i));
            }
            out.put("items", items);
            return new Object[]{out};
        }
        return new Object[]{"No filter"};
    }

    @Callback(doc="function():table -- Get the size of the filter in the seal")
    public Object[] getFilterSize(Context context, Arguments args) {
        if (((ISealEntity)this.tileEntity).getSeal() instanceof ISealConfigFilter) {
            int size = ((ISealConfigFilter)((ISealEntity)this.tileEntity).getSeal()).getFilterSize();
            return new Object[]{size};
        }
        return new Object[]{"No Filter"};
    }

    @Callback(doc="function(slot:integer):String -- Get the item in specified filter slot")
    public Object[] getFilterSlot(Context context, Arguments args) {
        if (((ISealEntity)this.tileEntity).getSeal() instanceof ISealConfigFilter) {
            int slot = args.checkInteger(0);
            if (slot > ((ISealConfigFilter)((ISealEntity)this.tileEntity).getSeal()).getFilterSize() || slot < 1) {
                return new Object[]{"Index out of range"};
            }
            ItemStack item = ((ISealConfigFilter)((ISealEntity)this.tileEntity).getSeal()).getFilterSlot(--slot);
            return new Object[]{item.func_82833_r()};
        }
        return new Object[]{"No filter"};
    }

    @Callback(doc="function(slot:integer):integer -- Get the stack size limit of specified filter slot")
    public Object[] getFilterSlotSize(Context context, Arguments args) {
        if (((ISealEntity)this.tileEntity).getSeal() instanceof ISealConfigFilter) {
            int slot = args.checkInteger(0);
            if (slot > ((ISealConfigFilter)((ISealEntity)this.tileEntity).getSeal()).getFilterSize() || slot < 1) {
                return new Object[]{"Slot index out of range"};
            }
            int stacksize = ((ISealConfigFilter)((ISealEntity)this.tileEntity).getSeal()).getFilterSlotSize(--slot);
            return new Object[]{stacksize};
        }
        return new Object[]{"No filter"};
    }

    @Callback(doc="function():boolean -- Does filter have item stack size limits")
    public Object[] getHasStackSizeLimiters(Context context, Arguments args) {
        if (((ISealEntity)this.tileEntity).getSeal() instanceof ISealConfigFilter) {
            boolean limited = ((ISealConfigFilter)((ISealEntity)this.tileEntity).getSeal()).hasStacksizeLimiters();
            return new Object[]{limited};
        }
        return new Object[]{"No filter"};
    }

    @Callback(doc="function():boolean -- Is the filter a blacklist or whitelist")
    public Object[] getIsBlacklist(Context context, Arguments args) {
        if (((ISealEntity)this.tileEntity).getSeal() instanceof ISealConfigFilter) {
            boolean blacklist = ((ISealConfigFilter)((ISealEntity)this.tileEntity).getSeal()).isBlacklist();
            return new Object[]{blacklist};
        }
        return new Object[]{"No filter"};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Callback(doc="function(slot:int, item:string)string -- Set item in specified filter slot, returns item in slot")
    public Object[] setFilterSlot(Context context, Arguments args) {
        if (!ModConfig.allowSetFilterSlot) return new Object[]{"API action not allowed, see config"};
        if (!(((ISealEntity)this.tileEntity).getSeal() instanceof ISealConfigFilter)) return new Object[]{"No filter"};
        int slot = args.checkInteger(0);
        if (slot > ((ISealConfigFilter)((ISealEntity)this.tileEntity).getSeal()).getFilterSize() || slot < 1) {
            return new Object[]{"Slot index out of range"};
        }
        --slot;
        String name = args.checkString(1);
        ResourceLocation rlItem = new ResourceLocation(name);
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)rlItem);
        if (item == null) {
            return new Object[]{"No such item" + name};
        }
        ItemStack itemStack = new ItemStack(item);
        ((ISealConfigFilter)((ISealEntity)this.tileEntity).getSeal()).setFilterSlot(slot, itemStack);
        return this.getFilterSlot(null, args);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Callback(doc="function(slot:int,size:int):string -- Set size of item stack in filter slot, returns slot size")
    public Object[] setFilterSlotSize(Context context, Arguments args) {
        if (!ModConfig.allowSetFilterSlotSize) return new Object[]{"API action not allowed, see config"};
        if (!(((ISealEntity)this.tileEntity).getSeal() instanceof ISealConfigFilter)) return new Object[]{"No Filter"};
        int slot = args.checkInteger(0);
        int size = args.checkInteger(1);
        if (slot > ((ISealConfigFilter)((ISealEntity)this.tileEntity).getSeal()).getFilterSize() || slot < 1) {
            return new Object[]{"Slot index out of range"};
        }
        --slot;
        if (this.getFilterSlot(null, args)[0].toString().equalsIgnoreCase("air")) {
            return this.getFilterSlotSize(null, args);
        }
        ((ISealConfigFilter)((ISealEntity)this.tileEntity).getSeal()).setFilterSlotSize(slot, size);
        return this.getFilterSlotSize(null, args);
    }

    @Callback(doc="function(blacklist:boolean):boolean -- Sets if the seal filter is a blacklist or whitelist, returns if the filter is blacklist or whitelist")
    public Object[] setIsBlacklist(Context context, Arguments args) {
        if (ModConfig.allowSetBlacklist) {
            if (!(((ISealEntity)this.tileEntity).getSeal() instanceof ISealConfigFilter)) {
                return new Object[]{"No Filter"};
            }
        } else {
            return new Object[]{"API action not allowed, see config"};
        }
        boolean bl = args.checkBoolean(0);
        ((ISealConfigFilter)((ISealEntity)this.tileEntity).getSeal()).setBlacklist(bl);
        return this.getIsBlacklist(null, null);
    }

    @Callback(doc="function():table -- Get configuration toggles")
    public Object[] getProperties(Context context, Arguments args) {
        HashMap<String, Boolean> filterProps = new HashMap<String, Boolean>();
        HashMap<String, HashMap<String, Boolean>> out = new HashMap<String, HashMap<String, Boolean>>();
        if (((ISealEntity)this.tileEntity).getSeal() instanceof ISealConfigToggles) {
            ISealConfigToggles.SealToggle[] toggles;
            for (ISealConfigToggles.SealToggle s : toggles = ((ISealConfigToggles)((ISealEntity)this.tileEntity).getSeal()).getToggles()) {
                filterProps.put(I18n.func_135052_a((String)s.getName(), (Object[])new Object[0]), s.getValue());
            }
            out.put("properties", filterProps);
            return new Object[]{out};
        }
        return new Object[]{"No properties"};
    }

    @Callback(doc="function():table -- Get the seal effect dimensions")
    public Object[] getArea(Context context, Arguments args) {
        BlockPos area = ((ISealEntity)this.tileEntity).getArea();
        HashMap<String, Integer> out = new HashMap<String, Integer>();
        out.put("X", area.func_177958_n());
        out.put("Y", area.func_177956_o());
        out.put("Z", area.func_177952_p());
        return new Object[]{out};
    }

    @Callback(doc="function():string -- Get the seal color")
    public Object[] getColor(Context context, Arguments args) {
        byte color = ((ISealEntity)this.tileEntity).getColor();
        String colorName = color == 0 ? "All" : EnumDyeColor.func_176764_b((int)(color - 1)).func_176610_l();
        return new Object[]{colorName};
    }

    @Callback(doc="function():boolean -- Is the seal locked to only controlling owner's golems")
    public Object[] getIsLocked(Context context, Arguments args) {
        boolean locked = ((ISealEntity)this.tileEntity).isLocked();
        return new Object[]{locked};
    }

    @Callback(doc="function():boolean -- Does the seal get disabled by redstone signals")
    public Object[] getIsRedstoneSensitive(Context context, Arguments args) {
        boolean sensitive = ((ISealEntity)this.tileEntity).isRedstoneSensitive();
        return new Object[]{sensitive};
    }

    @Callback(doc="function():boolean -- Is the seal currently disabled by redstone signal")
    public Object[] getIsStoppedByRedstone(Context context, Arguments args) {
        boolean stopped = ((ISealEntity)this.tileEntity).isStoppedByRedstone(this.world);
        return new Object[]{stopped};
    }

    @Callback(doc="function():string -- Get the name of the owner of the seal")
    public Object[] getOwner(Context context, Arguments args) {
        String owner = ((ISealEntity)this.tileEntity).getOwner();
        String ownerName = UsernameCache.getLastKnownUsername((UUID)UUID.fromString(owner));
        return new Object[]{ownerName};
    }

    @Callback(doc="function():int -- Get the priority of golem tasks created by this seal")
    public Object[] getPriority(Context context, Arguments args) {
        byte priority = ((ISealEntity)this.tileEntity).getPriority();
        return new Object[]{priority};
    }

    @Callback(doc="function(x:int,y:int,z:int):table -- Set the Area affected by the seal, returns area value")
    public Object[] setArea(Context context, Arguments args) {
        if (ModConfig.allowSetArea) {
            int x = args.checkInteger(0);
            int y = args.checkInteger(1);
            int z = args.checkInteger(2);
            int n = x > 8 ? 8 : (x = x < 0 ? 0 : x);
            int n2 = y > 8 ? 8 : (y = y < 0 ? 0 : y);
            z = z > 8 ? 8 : (z < 0 ? 0 : z);
            BlockPos pos = new BlockPos(x, y, z);
            if (((ISealEntity)this.tileEntity).getSeal() instanceof ISealConfigArea) {
                ((ISealEntity)this.tileEntity).setArea(pos);
                return this.getArea(null, null);
            }
        } else {
            return new Object[]{"API action not allowed, see config"};
        }
        return this.getArea(null, null);
    }

    @Callback(doc="function(color:int):string -- Set the color of the seal, returns seal color")
    public Object[] setColor(Context context, Arguments args) {
        if (!ModConfig.allowSetColor) {
            return new Object[]{"API action not allowed, see config"};
        }
        int c = args.checkInteger(0);
        c = c > 15 ? 15 : (c < -1 ? -1 : c);
        ((ISealEntity)this.tileEntity).setColor((byte)(++c));
        return this.getColor(null, null);
    }

    @Callback(doc="function(locked:boolean):boolean -- Set the locked state of the seal, returns lock state")
    public Object[] setIsLocked(Context context, Arguments args) {
        if (!ModConfig.allowSetLocked) {
            return new Object[]{"API action not allowed, see config"};
        }
        boolean l = args.checkBoolean(0);
        ((ISealEntity)this.tileEntity).setLocked(l);
        return this.getIsLocked(null, null);
    }

    @Callback(doc="function(sensitive:boolean):boolean -- Set the redstone sensitive state of the seal, returns state")
    public Object[] setIsRedstoneSensitive(Context context, Arguments args) {
        if (!ModConfig.allowSetRedstoneSensitive) {
            return new Object[]{"API action not allowed, see config"};
        }
        boolean s = args.checkBoolean(0);
        ((ISealEntity)this.tileEntity).setRedstoneSensitive(s);
        return this.getIsRedstoneSensitive(null, null);
    }

    @Callback(doc="function(priority:int):int -- Set the seal task priority, returns priority")
    public Object[] setPriority(Context context, Arguments args) {
        if (!ModConfig.allowSetPriority) {
            return new Object[]{"API action not allowed, see config"};
        }
        int p = args.checkInteger(0);
        p = p > 5 ? 5 : (p < -5 ? -5 : p);
        ((ISealEntity)this.tileEntity).setPriority((byte)p);
        return this.getPriority(null, null);
    }
}

