/*
 * Decompiled with CFR 0.152.
 */
package jco2641.thaumcomp.aspects;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import jco2641.thaumcomp.util.ManagedTileEntityEnvironment;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.prefab.DriverSidedTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;

public class DriverAspectContainer
extends DriverSidedTileEntity {
    public Class<?> getTileEntityClass() {
        return IAspectContainer.class;
    }

    public ManagedEnvironment createEnvironment(World world, BlockPos pos, EnumFacing side) {
        return new EnvironmentAspectContainer((IAspectContainer)world.func_175625_s(pos));
    }

    public static final class EnvironmentAspectContainer
    extends ManagedTileEntityEnvironment<IAspectContainer> {
        public EnvironmentAspectContainer(IAspectContainer te) {
            super(te, "aspect container");
        }

        @Callback(doc="function():table -- Get the Aspects stored in the block")
        public Object[] getAspects(Context context, Arguments args) {
            AspectList list = ((IAspectContainer)this.tileEntity).getAspects();
            HashMap<String, Integer> out = new HashMap<String, Integer>();
            for (Aspect a : list.getAspects()) {
                out.put(a.getName(), list.getAmount(a));
            }
            return new Object[]{out};
        }

        @Callback(doc="function():table -- Get the names of aspects stored in the block")
        public Object[] getAspectNames(Context context, Arguments args) {
            AspectList list = ((IAspectContainer)this.tileEntity).getAspects();
            Aspect[] array = list.getAspects();
            ArrayList<String> aspectNames = new ArrayList<String>();
            for (int i = 0; i < array.length; ++i) {
                aspectNames.add(array[i].getName());
            }
            return new Object[]{aspectNames};
        }

        @Callback(doc="function(aspect:string):number -- Get amount of specific aspect stored in this block")
        public Object[] getAspectCount(Context context, Arguments args) {
            Aspect aspect = Aspect.getAspect((String)args.checkString(0).toLowerCase());
            Preconditions.checkNotNull((Object)aspect, (Object)"Invalid aspect name");
            AspectList list = ((IAspectContainer)this.tileEntity).getAspects();
            return new Object[]{list.getAmount(aspect)};
        }
    }
}

