/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.gen;

import binnie.extratrees.gen.BinnieWorldGenTree;
import forestry.api.arboriculture.ITree;
import forestry.api.world.ITreeGenData;

public class WorldGenSpruce {

    public static class BlackSpruce
    extends BinnieWorldGenTree {
        public BlackSpruce(ITree tree) {
            super((ITreeGenData)tree, 6, 2);
        }

        @Override
        protected void generateLeaves() {
            float leafSpawn = this.height + 2;
            float bottom = this.randBetween(2, 3);
            float width = (float)this.height / this.randBetween(2.2f, 2.5f);
            float coneHeight = leafSpawn - bottom;
            while (leafSpawn > bottom) {
                float radius = 1.0f - (leafSpawn - bottom) / coneHeight;
                radius = (float)Math.sqrt(radius);
                float f = leafSpawn;
                leafSpawn = f - 1.0f;
                this.generateCylinder(new BinnieWorldGenTree.Vector(0.0f, f, 0.0f), radius *= width, 1, this.leaf, false);
            }
            this.generateCylinder(new BinnieWorldGenTree.Vector(0.0f, leafSpawn, 0.0f), 0.7f * width, 1, this.leaf, false);
        }
    }

    public static class WhiteSpruce
    extends BinnieWorldGenTree {
        public WhiteSpruce(ITree tree) {
            super((ITreeGenData)tree, 6, 2);
        }

        @Override
        protected void generateLeaves() {
            float leafSpawn = this.height + 2;
            float bottom = this.randBetween(2, 3);
            float width = (float)this.height / this.randBetween(2.2f, 2.5f);
            float coneHeight = leafSpawn - bottom;
            while (leafSpawn > bottom) {
                float radius = 1.0f - (leafSpawn - bottom) / coneHeight;
                radius = (float)Math.sqrt(radius);
                float f = leafSpawn;
                leafSpawn = f - 1.0f;
                this.generateCylinder(new BinnieWorldGenTree.Vector(0.0f, f, 0.0f), radius *= width, 1, this.leaf, false);
            }
            this.generateCylinder(new BinnieWorldGenTree.Vector(0.0f, leafSpawn, 0.0f), 0.7f * width, 1, this.leaf, false);
        }
    }

    public static class AlpineSpruce
    extends BinnieWorldGenTree {
        public AlpineSpruce(ITree tree) {
            super((ITreeGenData)tree, 5, 3);
        }

        @Override
        protected void generateLeaves() {
            float leafSpawn = this.height + 5;
            float bottom = this.randBetween(2, 3);
            float width = (float)this.height / this.randBetween(2.0f, 2.5f);
            float coneHeight = leafSpawn - bottom;
            leafSpawn -= 2.0f;
            while (leafSpawn > bottom) {
                float radius = 1.0f - (leafSpawn - bottom) / coneHeight;
                radius *= radius;
                float f = leafSpawn;
                leafSpawn = f - 1.0f;
                this.generateCylinder(new BinnieWorldGenTree.Vector(0.0f, f, 0.0f), radius *= width, 1, this.leaf, false);
            }
            float f = leafSpawn;
            leafSpawn = f - 1.0f;
            this.generateCylinder(new BinnieWorldGenTree.Vector(0.0f, f, 0.0f), 0.7f * width, 1, this.leaf, false);
            this.generateCylinder(new BinnieWorldGenTree.Vector(0.0f, leafSpawn, 0.0f), 0.4f * width, 1, this.leaf, false);
        }
    }

    public static class GiantSpruce
    extends BinnieWorldGenTree {
        public GiantSpruce(ITree tree) {
            super((ITreeGenData)tree, 15, 4);
        }

        @Override
        protected void generateLeaves() {
            float leafSpawn = this.height + 3;
            float bottom = this.randBetween(3, 4);
            float width = (float)this.height / this.randBetween(2.5f, 3.0f);
            float coneHeight = leafSpawn - bottom;
            while (leafSpawn > bottom) {
                float radius = 1.0f - (leafSpawn - bottom) / coneHeight;
                radius = 0.15f + 0.85f * radius;
                float f = leafSpawn;
                leafSpawn = f - 1.0f;
                this.generateCylinder(new BinnieWorldGenTree.Vector(0.0f, f, 0.0f), radius *= width, 1, this.leaf, false);
            }
            float f = leafSpawn;
            leafSpawn = f - 1.0f;
            this.generateCylinder(new BinnieWorldGenTree.Vector(0.0f, f, 0.0f), 0.7f * width, 1, this.leaf, false);
            this.generateCylinder(new BinnieWorldGenTree.Vector(0.0f, leafSpawn, 0.0f), 0.4f * width, 1, this.leaf, false);
        }
    }
}

