/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.guidebook.conditions;

import com.google.common.base.Strings;
import gigaherz.guidebook.guidebook.BookParsingException;
import gigaherz.guidebook.guidebook.conditions.ConditionContext;
import gigaherz.guidebook.guidebook.conditions.ConditionManager;
import java.util.function.Predicate;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.w3c.dom.Node;

public abstract class BasicConditions
implements Predicate<ConditionContext> {
    public static void register() {
        ConditionManager.register("true", (doc, node) -> new True());
        ConditionManager.register("false", (doc, node) -> new False());
        ConditionManager.register("mod-loaded", (doc, node) -> new ModLoaded(BasicConditions.parseModId(node)));
        ConditionManager.register("item-exists", (doc, node) -> new ItemExists(BasicConditions.parseItemName(node)));
    }

    private static String parseModId(Node xmlNode) {
        Node attr = xmlNode.getAttributes().getNamedItem("modid");
        if (attr == null) {
            throw new BookParsingException("Missing required XML attribute 'modid'.");
        }
        String modId = attr.getTextContent();
        if (Strings.isNullOrEmpty((String)modId)) {
            throw new BookParsingException("Missing required XML attribute 'modid'.");
        }
        return modId;
    }

    private static ResourceLocation parseItemName(Node xmlNode) {
        Node attr = xmlNode.getAttributes().getNamedItem("registry-name");
        if (attr == null) {
            throw new BookParsingException("Missing required XML attribute 'registry-name'.");
        }
        String name = attr.getTextContent();
        if (Strings.isNullOrEmpty((String)name)) {
            throw new BookParsingException("Missing required XML attribute 'registry-name'.");
        }
        return new ResourceLocation(name);
    }

    public static class ItemExists
    extends BasicConditions {
        private final ResourceLocation item;

        public ItemExists(ResourceLocation item) {
            this.item = item;
        }

        @Override
        public boolean test(ConditionContext conditionContext) {
            return ForgeRegistries.ITEMS.containsKey(this.item);
        }
    }

    public static class ModLoaded
    extends BasicConditions {
        private final String modId;

        public ModLoaded(String modId) {
            this.modId = modId;
        }

        @Override
        public boolean test(ConditionContext conditionContext) {
            return Loader.isModLoaded((String)this.modId);
        }
    }

    public static class False
    extends BasicConditions {
        @Override
        public boolean test(ConditionContext conditionContext) {
            return false;
        }
    }

    public static class True
    extends BasicConditions {
        @Override
        public boolean test(ConditionContext conditionContext) {
            return true;
        }
    }
}

