/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.machine;

import cofh.core.inventory.ComparableItemStackValidated;
import cofh.core.inventory.OreValidator;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.util.managers.machine.FurnaceManager;
import cofh.thermalfoundation.init.TFEquipment;
import cofh.thermalfoundation.item.ItemMaterial;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class SmelterManager {
    private static Map<List<ComparableItemStackValidated>, SmelterRecipe> recipeMap = new Object2ObjectOpenHashMap();
    private static Set<ComparableItemStackValidated> validationSet = new ObjectOpenHashSet();
    private static Set<ComparableItemStackValidated> lockSet = new ObjectOpenHashSet();
    private static OreValidator oreValidator = new OreValidator();
    static final ItemStack BLOCK_SAND;
    static final ItemStack BLOCK_SOUL_SAND;
    static final int ORE_MULTIPLIER = 2;
    static final int ORE_MULTIPLIER_SPECIAL = 3;
    public static final int DEFAULT_ENERGY = 4000;

    private static SmelterRecipe getRecipeFwd(ItemStack primaryInput, ItemStack secondaryInput) {
        ComparableItemStackValidated query = SmelterManager.convertInput(primaryInput);
        ComparableItemStackValidated querySecondary = SmelterManager.convertInput(secondaryInput);
        SmelterRecipe recipe = recipeMap.get(Arrays.asList(query, querySecondary));
        if (recipe == null) {
            if (SmelterManager.isItemFlux(primaryInput)) {
                querySecondary.metadata = Short.MAX_VALUE;
            } else {
                query.metadata = Short.MAX_VALUE;
            }
            recipe = recipeMap.get(Arrays.asList(query, querySecondary));
        }
        return recipe;
    }

    public static boolean isRecipeReversed(ItemStack primaryInput, ItemStack secondaryInput) {
        if (primaryInput.func_190926_b() || secondaryInput.func_190926_b()) {
            return false;
        }
        return SmelterManager.getRecipeFwd(primaryInput, secondaryInput) == null;
    }

    public static SmelterRecipe getRecipe(ItemStack primaryInput, ItemStack secondaryInput) {
        ComparableItemStackValidated querySecondary;
        if (primaryInput.func_190926_b() || secondaryInput.func_190926_b()) {
            return null;
        }
        ComparableItemStackValidated query = SmelterManager.convertInput(primaryInput);
        SmelterRecipe recipe = recipeMap.get(Arrays.asList(query, querySecondary = SmelterManager.convertInput(secondaryInput)));
        if (recipe == null) {
            recipe = recipeMap.get(Arrays.asList(querySecondary, query));
        }
        if (recipe == null) {
            if (SmelterManager.isItemFlux(primaryInput)) {
                querySecondary.metadata = Short.MAX_VALUE;
            } else {
                query.metadata = Short.MAX_VALUE;
            }
            recipe = recipeMap.get(Arrays.asList(query, querySecondary));
            if (recipe == null) {
                recipe = recipeMap.get(Arrays.asList(querySecondary, query));
            }
        }
        return recipe;
    }

    public static boolean recipeExists(ItemStack primaryInput, ItemStack secondaryInput) {
        return SmelterManager.getRecipe(primaryInput, secondaryInput) != null;
    }

    public static SmelterRecipe[] getRecipeList() {
        return recipeMap.values().toArray(new SmelterRecipe[0]);
    }

    public static boolean isItemValid(ItemStack input) {
        if (input.func_190926_b()) {
            return false;
        }
        ComparableItemStackValidated query = SmelterManager.convertInput(input);
        if (validationSet.contains(query)) {
            return true;
        }
        query.metadata = Short.MAX_VALUE;
        return validationSet.contains(query);
    }

    public static boolean isItemFlux(ItemStack input) {
        return !input.func_190926_b() && lockSet.contains(SmelterManager.convertInput(input));
    }

    public static void preInit() {
        SmelterManager.addFlux(BLOCK_SAND);
        SmelterManager.addFlux(BLOCK_SOUL_SAND);
        SmelterManager.addFlux(ItemMaterial.crystalSlagRich);
        SmelterManager.addFlux(ItemMaterial.crystalCinnabar);
    }

    public static void initialize() {
        String[] oreNames;
        SmelterManager.addDefaultRecipes("Iron", ItemMaterial.ingotIron, ItemMaterial.ingotNickel);
        SmelterManager.addDefaultRecipes("Gold", ItemMaterial.ingotGold, ItemStack.field_190927_a, 20);
        SmelterManager.addDefaultRecipes("Copper", ItemMaterial.ingotCopper, ItemMaterial.ingotGold);
        SmelterManager.addDefaultRecipes("Tin", ItemMaterial.ingotTin, ItemMaterial.ingotIron);
        SmelterManager.addDefaultRecipes("Silver", ItemMaterial.ingotSilver, ItemMaterial.ingotLead);
        SmelterManager.addDefaultRecipes("Aluminum", ItemMaterial.ingotAluminum, ItemMaterial.ingotIron);
        SmelterManager.addDefaultRecipes("Lead", ItemMaterial.ingotLead, ItemMaterial.ingotSilver);
        SmelterManager.addDefaultRecipes("Nickel", ItemMaterial.ingotNickel, ItemMaterial.ingotPlatinum, 15);
        SmelterManager.addDefaultRecipes("Platinum", ItemMaterial.ingotPlatinum, ItemMaterial.ingotIridium);
        SmelterManager.addDefaultRecipes("Iridium", ItemMaterial.ingotIridium, ItemMaterial.ingotPlatinum);
        SmelterManager.addDefaultRecipes("Mithril", ItemMaterial.ingotMithril, ItemMaterial.ingotGold);
        SmelterManager.addDefaultRecipes("Steel", ItemMaterial.ingotSteel);
        SmelterManager.addDefaultRecipes("Electrum", ItemMaterial.ingotElectrum);
        SmelterManager.addDefaultRecipes("Invar", ItemMaterial.ingotInvar);
        SmelterManager.addDefaultRecipes("Bronze", ItemMaterial.ingotBronze);
        SmelterManager.addDefaultRecipes("Constantan", ItemMaterial.ingotConstantan);
        SmelterManager.addDefaultRecipes("Signalum", ItemMaterial.ingotSignalum);
        SmelterManager.addDefaultRecipes("Lumium", ItemMaterial.ingotLumium);
        SmelterManager.addDefaultRecipes("Enderium", ItemMaterial.ingotEnderium);
        int energy = 6000;
        ItemStack ingot = new ItemStack(Items.field_151042_j);
        SmelterManager.addRecycleRecipe(energy, new ItemStack(Items.field_151040_l), ingot, 1);
        SmelterManager.addRecycleRecipe(energy, new ItemStack(Items.field_151035_b), ingot, 1);
        SmelterManager.addRecycleRecipe(energy, new ItemStack(Items.field_151036_c), ingot, 1);
        SmelterManager.addRecycleRecipe(energy, new ItemStack(Items.field_151037_a), ingot, 1);
        SmelterManager.addRecycleRecipe(energy, new ItemStack(Items.field_151019_K), ingot, 1);
        SmelterManager.addRecycleRecipe(energy, new ItemStack((Item)Items.field_151028_Y), ingot, 2);
        SmelterManager.addRecycleRecipe(energy, new ItemStack((Item)Items.field_151030_Z), ingot, 4);
        SmelterManager.addRecycleRecipe(energy, new ItemStack((Item)Items.field_151165_aa), ingot, 3);
        SmelterManager.addRecycleRecipe(energy, new ItemStack((Item)Items.field_151167_ab), ingot, 2);
        SmelterManager.addRecycleRecipe(energy, new ItemStack(Items.field_151138_bX), ingot, 2, false);
        ingot = new ItemStack(Items.field_151043_k);
        SmelterManager.addRecycleRecipe(energy, new ItemStack(Items.field_151010_B), ingot, 1);
        SmelterManager.addRecycleRecipe(energy, new ItemStack(Items.field_151005_D), ingot, 1);
        SmelterManager.addRecycleRecipe(energy, new ItemStack(Items.field_151006_E), ingot, 1);
        SmelterManager.addRecycleRecipe(energy, new ItemStack(Items.field_151011_C), ingot, 1);
        SmelterManager.addRecycleRecipe(energy, new ItemStack(Items.field_151013_M), ingot, 1);
        SmelterManager.addRecycleRecipe(energy, new ItemStack((Item)Items.field_151169_ag), ingot, 2);
        SmelterManager.addRecycleRecipe(energy, new ItemStack((Item)Items.field_151171_ah), ingot, 4);
        SmelterManager.addRecycleRecipe(energy, new ItemStack((Item)Items.field_151149_ai), ingot, 3);
        SmelterManager.addRecycleRecipe(energy, new ItemStack((Item)Items.field_151151_aj), ingot, 2);
        SmelterManager.addRecycleRecipe(energy, new ItemStack(Items.field_151136_bY), ingot, 2, false);
        for (TFEquipment.ToolSetVanilla toolSetVanilla : new TFEquipment.ToolSetVanilla[]{TFEquipment.ToolSetVanilla.IRON, TFEquipment.ToolSetVanilla.GOLD}) {
            ingot = ItemHelper.getOre((String)toolSetVanilla.ingot);
            if (toolSetVanilla.enable[0]) {
                SmelterManager.addRecycleRecipe(energy, toolSetVanilla.toolBow, ingot, 1);
            }
            if (toolSetVanilla.enable[1]) {
                SmelterManager.addRecycleRecipe(energy, toolSetVanilla.toolFishingRod, ingot, 1);
            }
            if (toolSetVanilla.enable[2]) {
                SmelterManager.addRecycleRecipe(energy, toolSetVanilla.toolShears, ingot, 1);
            }
            if (toolSetVanilla.enable[3]) {
                SmelterManager.addRecycleRecipe(energy, toolSetVanilla.toolSickle, ingot, 1);
            }
            if (toolSetVanilla.enable[4]) {
                SmelterManager.addRecycleRecipe(energy, toolSetVanilla.toolHammer, ingot, 2);
            }
            if (toolSetVanilla.enable[5]) {
                SmelterManager.addRecycleRecipe(energy, toolSetVanilla.toolExcavator, ingot, 1);
            }
            if (!toolSetVanilla.enable[6]) continue;
            SmelterManager.addRecycleRecipe(energy, toolSetVanilla.toolShield, ingot, 3);
        }
        for (TFEquipment.ToolSet toolSet : TFEquipment.ToolSet.values()) {
            ingot = ItemHelper.getOre((String)toolSet.ingot);
            if (toolSet.enable[0]) {
                SmelterManager.addRecycleRecipe(energy, toolSet.toolSword, ingot, 1);
            }
            if (toolSet.enable[1]) {
                SmelterManager.addRecycleRecipe(energy, toolSet.toolPickaxe, ingot, 1);
            }
            if (toolSet.enable[2]) {
                SmelterManager.addRecycleRecipe(energy, toolSet.toolAxe, ingot, 1);
            }
            if (toolSet.enable[3]) {
                SmelterManager.addRecycleRecipe(energy, toolSet.toolShovel, ingot, 1);
            }
            if (toolSet.enable[4]) {
                SmelterManager.addRecycleRecipe(energy, toolSet.toolHoe, ingot, 1);
            }
            if (toolSet.enable[5]) {
                SmelterManager.addRecycleRecipe(energy, toolSet.toolBow, ingot, 1);
            }
            if (toolSet.enable[6]) {
                SmelterManager.addRecycleRecipe(energy, toolSet.toolFishingRod, ingot, 1);
            }
            if (toolSet.enable[7]) {
                SmelterManager.addRecycleRecipe(energy, toolSet.toolShears, ingot, 1);
            }
            if (toolSet.enable[8]) {
                SmelterManager.addRecycleRecipe(energy, toolSet.toolSickle, ingot, 1);
            }
            if (toolSet.enable[9]) {
                SmelterManager.addRecycleRecipe(energy, toolSet.toolHammer, ingot, 2);
            }
            if (toolSet.enable[10]) {
                SmelterManager.addRecycleRecipe(energy, toolSet.toolExcavator, ingot, 1);
            }
            if (!toolSet.enable[11]) continue;
            SmelterManager.addRecycleRecipe(energy, toolSet.toolShield, ingot, 3);
        }
        for (TFEquipment.ArmorSet armorSet : TFEquipment.ArmorSet.values()) {
            ingot = ItemHelper.getOre((String)armorSet.ingot);
            if (armorSet.enable[0]) {
                SmelterManager.addRecycleRecipe(energy, armorSet.armorHelmet, ingot, 2);
            }
            if (armorSet.enable[1]) {
                SmelterManager.addRecycleRecipe(energy, armorSet.armorChestplate, ingot, 4);
            }
            if (armorSet.enable[2]) {
                SmelterManager.addRecycleRecipe(energy, armorSet.armorLegs, ingot, 3);
            }
            if (!armorSet.enable[3]) continue;
            SmelterManager.addRecycleRecipe(energy, armorSet.armorBoots, ingot, 2);
        }
        for (TFEquipment.HorseArmor horseArmor : TFEquipment.HorseArmor.values()) {
            ingot = ItemHelper.getOre((String)horseArmor.ingot);
            SmelterManager.addRecycleRecipe(energy, horseArmor.armor, ingot, 2, false);
        }
        for (String string : oreNames = OreDictionary.getOreNames()) {
            String oreType;
            if (string.startsWith("ore")) {
                if (!SmelterManager.isStandardOre(string)) continue;
                oreType = string.substring(3);
                SmelterManager.addDefaultRecipes(oreType, "");
                continue;
            }
            if (!string.startsWith("dust") || !SmelterManager.isStandardOre(string)) continue;
            oreType = string.substring(4);
            SmelterManager.addDefaultRecipes(oreType, "");
        }
    }

    public static void refresh() {
        Object2ObjectOpenHashMap tempMap = new Object2ObjectOpenHashMap(recipeMap.size());
        ObjectOpenHashSet tempSet = new ObjectOpenHashSet();
        for (Map.Entry<List<ComparableItemStackValidated>, SmelterRecipe> entry : recipeMap.entrySet()) {
            SmelterRecipe tempRecipe = entry.getValue();
            ComparableItemStackValidated primary = SmelterManager.convertInput(tempRecipe.primaryInput);
            ComparableItemStackValidated secondary = SmelterManager.convertInput(tempRecipe.secondaryInput);
            tempMap.put(Arrays.asList(primary, secondary), tempRecipe);
            tempSet.add(primary);
            tempSet.add(secondary);
        }
        recipeMap.clear();
        recipeMap = tempMap;
        validationSet.clear();
        validationSet = tempSet;
        ObjectOpenHashSet tempSet2 = new ObjectOpenHashSet();
        for (ComparableItemStackValidated entry : lockSet) {
            ComparableItemStackValidated lock = SmelterManager.convertInput(new ItemStack(entry.item, entry.stackSize, entry.metadata));
            tempSet2.add(lock);
        }
        lockSet.clear();
        lockSet = tempSet2;
    }

    public static SmelterRecipe addRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        if (primaryInput.func_190926_b() || secondaryInput.func_190926_b() || primaryOutput.func_190926_b() || energy <= 0 || SmelterManager.recipeExists(primaryInput, secondaryInput)) {
            return null;
        }
        SmelterRecipe recipe = new SmelterRecipe(primaryInput, secondaryInput, primaryOutput, secondaryOutput, secondaryOutput.func_190926_b() ? 0 : secondaryChance, energy);
        recipeMap.put(Arrays.asList(SmelterManager.convertInput(primaryInput), SmelterManager.convertInput(secondaryInput)), recipe);
        validationSet.add(SmelterManager.convertInput(primaryInput));
        validationSet.add(SmelterManager.convertInput(secondaryInput));
        return recipe;
    }

    public static SmelterRecipe addRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput) {
        return SmelterManager.addRecipe(energy, primaryInput, secondaryInput, primaryOutput, secondaryOutput, 100);
    }

    public static SmelterRecipe addRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput) {
        return SmelterManager.addRecipe(energy, primaryInput, secondaryInput, primaryOutput, ItemStack.field_190927_a, 0);
    }

    public static SmelterRecipe removeRecipe(ItemStack primaryInput, ItemStack secondaryInput) {
        SmelterRecipe recipe = recipeMap.remove(Arrays.asList(SmelterManager.convertInput(primaryInput), SmelterManager.convertInput(secondaryInput)));
        return recipe != null ? recipe : recipeMap.remove(Arrays.asList(SmelterManager.convertInput(secondaryInput), SmelterManager.convertInput(primaryInput)));
    }

    public static ComparableItemStackValidated convertInput(ItemStack stack) {
        return new ComparableItemStackValidated(stack, oreValidator);
    }

    private static void addFlux(ItemStack flux) {
        lockSet.add(SmelterManager.convertInput(flux));
    }

    private static void addDefaultRecipes(ItemStack ore, ItemStack dust, ItemStack plate, ItemStack gear, ItemStack ingot, ItemStack related, int richSlagChance) {
        if (ingot.func_190926_b()) {
            return;
        }
        SmelterManager.addOreRecipe(4000, ore, ingot, related, richSlagChance, 75);
        SmelterManager.addBasicRecipe(1000, dust, ingot, 25);
        SmelterManager.addBasicRecipe(2000, plate, ingot, 10);
        SmelterManager.addBasicRecipe(3000, gear, ItemHelper.cloneStack((ItemStack)ingot, (int)4), 20);
    }

    private static void addDefaultRecipes(String oreType, String relatedOre) {
        if (oreType == null || oreType.isEmpty()) {
            return;
        }
        String oreName = "ore" + StringHelper.titleCase((String)oreType);
        String dustName = "dust" + StringHelper.titleCase((String)oreType);
        String plateName = "plate" + StringHelper.titleCase((String)oreType);
        String gearName = "gear" + StringHelper.titleCase((String)oreType);
        String ingotName = "ingot" + StringHelper.titleCase((String)oreType);
        ItemStack ore = ItemHelper.getOre((String)oreName);
        ItemStack dust = ItemHelper.getOre((String)dustName);
        ItemStack plate = ItemHelper.getOre((String)plateName);
        ItemStack gear = ItemHelper.getOre((String)gearName);
        ItemStack ingot = ItemHelper.getOre((String)ingotName);
        ItemStack related = relatedOre.isEmpty() ? ItemStack.field_190927_a : ItemHelper.getOre((String)relatedOre);
        SmelterManager.addDefaultRecipes(ore, dust, plate, gear, ingot, related, 5);
    }

    private static void addDefaultRecipes(String oreType, ItemStack primary, ItemStack secondary, int chance) {
        String oreName = "ore" + StringHelper.titleCase((String)oreType);
        String dustName = "dust" + StringHelper.titleCase((String)oreType);
        String plateName = "plate" + StringHelper.titleCase((String)oreType);
        String gearName = "gear" + StringHelper.titleCase((String)oreType);
        ItemStack ore = ItemHelper.getOre((String)oreName);
        ItemStack dust = ItemHelper.getOre((String)dustName);
        ItemStack plate = ItemHelper.getOre((String)plateName);
        ItemStack gear = ItemHelper.getOre((String)gearName);
        SmelterManager.addDefaultRecipes(ore, dust, plate, gear, primary, secondary, chance);
    }

    private static void addDefaultRecipes(String oreType, ItemStack primary, ItemStack secondary) {
        SmelterManager.addDefaultRecipes(oreType, primary, secondary, 5);
    }

    private static void addDefaultRecipes(String oreType, ItemStack primary) {
        SmelterManager.addDefaultRecipes(oreType, primary, ItemStack.field_190927_a, 0);
    }

    private static void addOreRecipe(int energy, ItemStack input, ItemStack output, ItemStack secondary, int richSlagChance, int slagChance) {
        SmelterManager.addOreRecipe(energy, input, output, secondary, richSlagChance, slagChance, 2, 3);
    }

    private static void addOreRecipe(int energy, ItemStack input, ItemStack output, ItemStack secondary, int richSlagChance, int slagChance, int oreMultiplier, int oreMultiplierSpecial) {
        ItemStack ingot2 = ItemHelper.cloneStack((ItemStack)output, (int)oreMultiplier);
        ItemStack ingot3 = ItemHelper.cloneStack((ItemStack)output, (int)oreMultiplierSpecial);
        SmelterManager.addRecipe(energy, input, BLOCK_SAND, ingot2, ItemMaterial.crystalSlagRich, richSlagChance);
        SmelterManager.addRecipe(energy, input, ItemMaterial.crystalSlagRich, ingot3, ItemMaterial.crystalSlag, slagChance);
        if (!secondary.func_190926_b()) {
            SmelterManager.addRecipe(energy, input, ItemMaterial.crystalCinnabar, ingot3, secondary, 100);
        } else {
            SmelterManager.addRecipe(energy, input, ItemMaterial.crystalCinnabar, ingot3, ItemMaterial.crystalSlagRich, 75);
        }
    }

    private static void addBasicRecipe(int energy, ItemStack input, ItemStack output, int slagChance) {
        SmelterManager.addRecipe(energy, input, BLOCK_SAND, output, ItemMaterial.crystalSlag, slagChance);
    }

    public static void addRecycleRecipe(int energy, ItemStack input, ItemStack output, int outputSize) {
        SmelterManager.addRecycleRecipe(energy, input, output, outputSize, true);
    }

    public static void addRecycleRecipe(int energy, ItemStack input, ItemStack output, int outputSize, boolean wildcard) {
        ItemStack recycleInput = wildcard ? new ItemStack(input.func_77973_b(), 1, Short.MAX_VALUE) : input.func_77946_l();
        SmelterManager.addBasicRecipe(energy, recycleInput, ItemHelper.cloneStack((ItemStack)output, (int)outputSize), Math.min(50, outputSize * 5 + 5));
    }

    private static boolean isStandardOre(String oreName) {
        return ItemHelper.oreNameExists((String)oreName) && FurnaceManager.recipeExists((ItemStack)OreDictionary.getOres((String)oreName, (boolean)false).get(0), false);
    }

    public static boolean isOre(ItemStack stack) {
        return ItemHelper.isOre((ItemStack)stack);
    }

    static {
        oreValidator.addPrefix("block");
        oreValidator.addPrefix("ore");
        oreValidator.addPrefix("dust");
        oreValidator.addPrefix("ingot");
        oreValidator.addPrefix("nugget");
        oreValidator.addPrefix("gem");
        oreValidator.addPrefix("plate");
        oreValidator.addExact("sand");
        oreValidator.addExact("crystalSlag");
        oreValidator.addExact("crystalSlagRich");
        oreValidator.addExact("crystalCinnabar");
        oreValidator.addExact("itemSlag");
        oreValidator.addExact("itemSlagRich");
        oreValidator.addExact("itemCinnabar");
        oreValidator.addExact("fuelCoke");
        BLOCK_SAND = new ItemStack((Block)Blocks.field_150354_m);
        BLOCK_SOUL_SAND = new ItemStack(Blocks.field_150425_aM);
    }

    public static class SmelterRecipe {
        final ItemStack primaryInput;
        final ItemStack secondaryInput;
        final ItemStack primaryOutput;
        final ItemStack secondaryOutput;
        final int secondaryChance;
        final int energy;
        final boolean hasFlux;

        SmelterRecipe(ItemStack secondaryInput, ItemStack primaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance, int energy) {
            if (SmelterManager.isItemFlux(primaryInput) && !SmelterManager.isItemFlux(secondaryInput)) {
                this.primaryInput = secondaryInput;
                this.secondaryInput = primaryInput;
            } else {
                this.primaryInput = primaryInput;
                this.secondaryInput = secondaryInput;
            }
            this.primaryOutput = primaryOutput;
            this.secondaryOutput = secondaryOutput;
            this.secondaryChance = secondaryChance;
            this.energy = energy;
            this.hasFlux = SmelterManager.isItemFlux(secondaryInput) || SmelterManager.isItemFlux(primaryInput);
        }

        public ItemStack getPrimaryInput() {
            return this.primaryInput;
        }

        public ItemStack getSecondaryInput() {
            return this.secondaryInput;
        }

        public ItemStack getPrimaryOutput() {
            return this.primaryOutput;
        }

        public ItemStack getSecondaryOutput() {
            return this.secondaryOutput;
        }

        public int getSecondaryOutputChance() {
            return this.secondaryChance;
        }

        public int getEnergy() {
            return this.energy;
        }

        public boolean hasFlux() {
            return this.hasFlux;
        }
    }
}

