/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.deepresonance.network.ReturnCrystalInfoHelper;
import mcjty.lib.thirteen.Context;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketReturnCrystalInfo
implements IMessage {
    private int rfPerTick;
    private float power;

    public void fromBytes(ByteBuf buf) {
        this.rfPerTick = buf.readInt();
        this.power = buf.readFloat();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.rfPerTick);
        buf.writeFloat(this.power);
    }

    public float getPower() {
        return this.power;
    }

    public int getRfPerTick() {
        return this.rfPerTick;
    }

    public PacketReturnCrystalInfo() {
    }

    public PacketReturnCrystalInfo(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketReturnCrystalInfo(int rfPerTick, float power) {
        this.rfPerTick = rfPerTick;
        this.power = power;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> ReturnCrystalInfoHelper.setEnergyLevel(this));
        ctx.setPacketHandled(true);
    }
}

