/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.deepresonance.blocks.tank.TileTank;
import mcjty.deepresonance.fluid.DRFluidRegistry;
import mcjty.deepresonance.network.DRMessages;
import mcjty.deepresonance.network.PacketReturnTankInfo;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.thirteen.Context;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketGetTankInfo
implements IMessage {
    private BlockPos pos;

    public void fromBytes(ByteBuf buf) {
        this.pos = NetworkTools.readPos((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
    }

    public PacketGetTankInfo() {
    }

    public PacketGetTankInfo(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketGetTankInfo(BlockPos pos) {
        this.pos = pos;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            World world = ctx.getSender().func_130014_f_();
            TileEntity tileEntity = world.func_175625_s(this.pos);
            if (tileEntity instanceof TileTank) {
                TileTank tileTank = (TileTank)tileEntity;
                PacketReturnTankInfo packet = new PacketReturnTankInfo(tileTank.getFluidAmount(), tileTank.getCapacity(), DRFluidRegistry.getFluidName(tileTank.getFluid()), tileTank.getFluidTag());
                DRMessages.INSTANCE.sendTo((IMessage)packet, ctx.getSender());
            }
        });
        ctx.setPacketHandled(true);
    }
}

