/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.jei.smelter;

import java.util.List;
import javax.annotation.Nonnull;
import mcjty.deepresonance.config.ConfigMachines;
import mcjty.deepresonance.jei.smelter.SmelterRecipeWrapper;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;

public class SmelterRecipeCategory
extends BlankRecipeCategory<SmelterRecipeWrapper> {
    private final IGuiHelper guiHelper;
    private final IDrawable slot;
    private final IDrawable arrow;
    public static final String ID = "DRSmelter";

    public SmelterRecipeCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        this.slot = guiHelper.getSlotDrawable();
        this.arrow = guiHelper.createDrawable(new ResourceLocation("deepresonance", "textures/gui/guielements.png"), 144, 0, 16, 16);
    }

    @Nonnull
    public String getUid() {
        return ID;
    }

    @Nonnull
    public String getTitle() {
        return "Deep Resonance Smelter";
    }

    public String getModName() {
        return "deepresonance";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.guiHelper.createBlankDrawable(120, 60);
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        super.drawExtras(minecraft);
        this.slot.draw(minecraft, 20, 32);
        this.arrow.draw(minecraft, 46, 32);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        fontRenderer.func_175065_a("Tank below between", 10.0f, 0.0f, -1, true);
        fontRenderer.func_175065_a("40% and 60% lava", 10.0f, 10.0f, -1, true);
    }

    public void setRecipe(IRecipeLayout recipeLayout, SmelterRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup group = recipeLayout.getItemStacks();
        group.init(0, true, 20, 32);
        group.set(0, (List)ingredients.getInputs(ItemStack.class).get(0));
        IGuiFluidStackGroup fluidGroup = recipeLayout.getFluidStacks();
        fluidGroup.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            tooltip.add(TextFormatting.GREEN + "Purity: 10%");
            tooltip.add(TextFormatting.GREEN + "Strength: 10%");
            tooltip.add(TextFormatting.GREEN + "Efficiency: 10%");
        });
        fluidGroup.init(0, false, 70, 25, 30, 30, ConfigMachines.smelter.rclPerOre, true, null);
        fluidGroup.set(0, (List)ingredients.getOutputs(FluidStack.class).get(0));
    }
}

