/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.compat.computers;

import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.prefab.AbstractManagedEnvironment;
import mcjty.deepresonance.blocks.tank.TileTank;
import mcjty.lib.integration.computers.AbstractOCDriver;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TankDriver {

    public static class OCDriver
    extends AbstractOCDriver {
        public OCDriver() {
            super("deepresonance_tank", TileTank.class);
        }

        public AbstractManagedEnvironment createEnvironment(World world, BlockPos pos, EnumFacing side, TileEntity tile) {
            return new InternalManagedEnvironment((TileTank)tile);
        }

        public static class InternalManagedEnvironment
        extends AbstractOCDriver.InternalManagedEnvironment<TileTank> {
            public InternalManagedEnvironment(TileTank tile) {
                super((Object)tile, "deepresonance_tank");
            }

            @Callback(doc="function():number; Returns the maximum amount of fluid")
            public Object[] getCapacity(Context c, Arguments a) {
                return new Object[]{((TileTank)((Object)this.tile)).getCapacity()};
            }

            @Callback(doc="function():number; Returns the current amount of fluid")
            public Object[] getFluidAmount(Context c, Arguments a) {
                return new Object[]{((TileTank)((Object)this.tile)).getFluidAmount()};
            }

            @Callback(doc="function():number; Returns the quality of the RCL")
            public Object[] getQuality(Context c, Arguments a) {
                NBTTagCompound tagData = ((TileTank)((Object)this.tile)).getFluidTag();
                if (tagData == null) {
                    return new Object[]{Float.valueOf(-1.0f)};
                }
                return new Object[]{Float.valueOf(tagData.func_74760_g("quality"))};
            }

            @Callback(doc="function():number; Returns the purity of the RCL")
            public Object[] getPurity(Context c, Arguments a) {
                NBTTagCompound tagData = ((TileTank)((Object)this.tile)).getFluidTag();
                if (tagData == null) {
                    return new Object[]{Float.valueOf(-1.0f)};
                }
                return new Object[]{Float.valueOf(tagData.func_74760_g("purity"))};
            }

            @Callback(doc="function():number; Returns the strength of the RCL")
            public Object[] getStrength(Context c, Arguments a) {
                NBTTagCompound tagData = ((TileTank)((Object)this.tile)).getFluidTag();
                if (tagData == null) {
                    return new Object[]{Float.valueOf(-1.0f)};
                }
                return new Object[]{Float.valueOf(tagData.func_74760_g("strength"))};
            }

            @Callback(doc="function():number; Returns the efficiency of the RCL")
            public Object[] getEfficiency(Context c, Arguments a) {
                NBTTagCompound tagData = ((TileTank)((Object)this.tile)).getFluidTag();
                if (tagData == null) {
                    return new Object[]{Float.valueOf(-1.0f)};
                }
                return new Object[]{Float.valueOf(tagData.func_74760_g("efficiency"))};
            }

            public int priority() {
                return 4;
            }
        }
    }
}

