/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.blocks.generator;

import java.text.DecimalFormat;
import java.util.List;
import mcjty.deepresonance.blocks.GenericDRBlock;
import mcjty.deepresonance.blocks.generator.GeneratorConfiguration;
import mcjty.deepresonance.blocks.generator.GeneratorSetup;
import mcjty.deepresonance.blocks.generator.GeneratorTileEntity;
import mcjty.deepresonance.client.ClientHandler;
import mcjty.deepresonance.generatornetwork.DRGeneratorNetwork;
import mcjty.deepresonance.network.DRMessages;
import mcjty.deepresonance.network.PacketGetGeneratorInfo;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.container.EmptyContainer;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class GeneratorBlock
extends GenericDRBlock<GeneratorTileEntity, EmptyContainer> {
    public static PropertyBool ENABLED = PropertyBool.func_177716_a((String)"enabled");
    public static PropertyBool UPPER = PropertyBool.func_177716_a((String)"upper");
    public static PropertyBool LOWER = PropertyBool.func_177716_a((String)"lower");
    public static int tooltipEnergy = 0;
    public static int tooltipRefCount = 0;
    public static int tooltipRfPerTick = 0;
    private static long lastTime = 0L;

    public GeneratorBlock() {
        super(Material.field_151573_f, GeneratorTileEntity.class, EmptyContainer::new, "generator", false);
    }

    public BaseBlock.RotationType getRotationType() {
        return BaseBlock.RotationType.NONE;
    }

    public int getGuiID() {
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag advancedToolTip) {
        super.func_190948_a(itemStack, player, list, advancedToolTip);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            list.add(TextFormatting.YELLOW + "Energy: " + tagCompound.func_74762_e("energy"));
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add("Part of a generator multi-block.");
            list.add("You can place these in any configuration.");
        } else {
            list.add(TextFormatting.WHITE + ClientHandler.getShiftMessage());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity tileEntity = accessor.getTileEntity();
        if (tileEntity instanceof GeneratorTileEntity) {
            GeneratorTileEntity generatorTileEntity = (GeneratorTileEntity)tileEntity;
            currenttip.add(TextFormatting.GREEN + "ID: " + new DecimalFormat("#.##").format(generatorTileEntity.getNetworkId()));
            if (System.currentTimeMillis() - lastTime > 250L) {
                lastTime = System.currentTimeMillis();
                DRMessages.INSTANCE.sendToServer((IMessage)new PacketGetGeneratorInfo(generatorTileEntity.getNetworkId()));
            }
            currenttip.add(TextFormatting.GREEN + "Energy: " + tooltipEnergy + "/" + tooltipRefCount * GeneratorConfiguration.rfPerGeneratorBlock + " RF");
            currenttip.add(TextFormatting.YELLOW + Integer.toString(tooltipRfPerTick) + " RF/t");
        }
        return currenttip;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack itemStack) {
        TileEntity te;
        super.func_180633_a(world, pos, state, placer, itemStack);
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof GeneratorTileEntity) {
            ((GeneratorTileEntity)te).addBlockToNetwork();
            DRGeneratorNetwork.Network network = ((GeneratorTileEntity)te).getNetwork();
            if (network != null) {
                NBTTagCompound tagCompound = itemStack.func_77978_p();
                network.setEnergy(network.getEnergy() + (tagCompound == null ? 0 : tagCompound.func_74762_e("energy")));
                DRGeneratorNetwork generatorNetwork = DRGeneratorNetwork.getChannels(world);
                generatorNetwork.save();
            }
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{UPPER, LOWER, ENABLED});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(world.func_180495_p(pos.func_177984_a()).func_177230_c() == GeneratorSetup.generatorBlock)).func_177226_a((IProperty)LOWER, (Comparable)Boolean.valueOf(world.func_180495_p(pos.func_177977_b()).func_177230_c() == GeneratorSetup.generatorBlock));
    }

    public IBlockState func_176203_a(int meta) {
        return super.func_176223_P().func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf((meta & 1) != 0));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)ENABLED) != false ? 1 : 0;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess access, BlockPos pos, IBlockState metadata, int fortune) {
        DRGeneratorNetwork.Network network;
        super.getDrops(drops, access, pos, metadata, fortune);
        TileEntity te = access.func_175625_s(pos);
        if (te instanceof GeneratorTileEntity && (network = ((GeneratorTileEntity)te).getNetwork()) != null) {
            int energy = network.getEnergy() / network.getGeneratorBlocks();
            if (!drops.isEmpty()) {
                NBTTagCompound tagCompound = ((ItemStack)drops.get(0)).func_77978_p();
                if (tagCompound == null) {
                    tagCompound = new NBTTagCompound();
                    ((ItemStack)drops.get(0)).func_77982_d(tagCompound);
                }
                tagCompound.func_74768_a("energy", energy);
            }
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof GeneratorTileEntity) {
            DRGeneratorNetwork.Network network = ((GeneratorTileEntity)te).getNetwork();
            if (network != null) {
                int energy = network.getEnergy() / network.getGeneratorBlocks();
                network.setEnergy(network.getEnergy() - energy);
            }
            ((GeneratorTileEntity)te).removeBlockFromNetwork();
        }
        super.func_180663_b(world, pos, state);
        if (!world.field_72995_K) {
            IBlockState stateDown;
            IBlockState stateUp = world.func_180495_p(pos.func_177984_a());
            if (stateUp.func_177230_c() == GeneratorSetup.generatorBlock) {
                world.func_184138_a(pos.func_177984_a(), stateUp, stateUp, 3);
            }
            if ((stateDown = world.func_180495_p(pos.func_177977_b())).func_177230_c() == GeneratorSetup.generatorBlock) {
                world.func_184138_a(pos.func_177977_b(), stateDown, stateDown, 3);
            }
        }
    }
}

