/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.blocks.crystals;

import elec332.core.ElecCore;
import java.text.DecimalFormat;
import java.util.List;
import mcjty.deepresonance.blocks.GenericDRBlock;
import mcjty.deepresonance.blocks.crystals.ResonatingCrystalTESR;
import mcjty.deepresonance.blocks.crystals.ResonatingCrystalTileEntity;
import mcjty.deepresonance.network.DRMessages;
import mcjty.deepresonance.network.PacketGetCrystalInfo;
import mcjty.deepresonance.radiation.DRRadiationManager;
import mcjty.deepresonance.radiation.RadiationConfiguration;
import mcjty.lib.base.GeneralConfig;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.container.EmptyContainer;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ResonatingCrystalBlock
extends GenericDRBlock<ResonatingCrystalTileEntity, EmptyContainer> {
    public static PropertyBool EMPTY = PropertyBool.func_177716_a((String)"empty");
    public static PropertyBool GENERATED = PropertyBool.func_177716_a((String)"generated");
    public static int tooltipRFTick = 0;
    public static float tooltipPower = 0.0f;
    private static long lastTime = 0L;
    public static final AxisAlignedBB BLOCK_AABB = new AxisAlignedBB((double)0.1f, 0.0, (double)0.1f, (double)0.9f, (double)0.8f, (double)0.9f);

    public ResonatingCrystalBlock() {
        super(Material.field_151592_s, ResonatingCrystalTileEntity.class, EmptyContainer::new, "resonating_crystal", false);
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.func_149672_a(SoundType.field_185853_f);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BLOCK_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ResonatingCrystalTESR.register();
        final ModelResourceLocation emptyNaturalModel = new ModelResourceLocation(this.getRegistryName(), "empty=true,facing=north,generated=false");
        final ModelResourceLocation fullNaturalModel = new ModelResourceLocation(this.getRegistryName(), "empty=false,facing=north,generated=false");
        final ModelResourceLocation emptyGeneratedModel = new ModelResourceLocation(this.getRegistryName(), "empty=true,facing=north,generated=true");
        final ModelResourceLocation fullGeneratedModel = new ModelResourceLocation(this.getRegistryName(), "empty=false,facing=north,generated=true");
        ModelBakery.registerItemVariants((Item)Item.func_150898_a((Block)this), (ResourceLocation[])new ResourceLocation[]{emptyNaturalModel, fullNaturalModel});
        ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a((Block)this), (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                float purity;
                float power = stack.func_77978_p() == null ? 1.0f : stack.func_77978_p().func_74760_g("power");
                float f = purity = stack.func_77978_p() == null ? 1.0f : stack.func_77978_p().func_74760_g("purity");
                if (power < 1.0E-5f) {
                    if (purity > 30.0f) {
                        return emptyGeneratedModel;
                    }
                    return emptyNaturalModel;
                }
                if (purity > 30.0f) {
                    return fullGeneratedModel;
                }
                return fullNaturalModel;
            }
        });
    }

    public BaseBlock.RotationType getRotationType() {
        return BaseBlock.RotationType.HORIZROTATION;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag advancedToolTips) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        boolean oldOwnership = GeneralConfig.manageOwnership;
        GeneralConfig.manageOwnership = false;
        super.func_190948_a(itemStack, player, list, advancedToolTips);
        GeneralConfig.manageOwnership = oldOwnership;
        float power = 100.0f;
        if (tagCompound != null) {
            power = tagCompound.func_74760_g("power");
        }
        if (power > 1.0E-5f) {
            list.add("You can feel the latent power present in this crystal.");
        } else {
            list.add("This crystal is depleted. Perhaps it still has a future use?");
        }
        if (tagCompound != null) {
            DecimalFormat decimalFormat = new DecimalFormat("#.##");
            list.add(TextFormatting.GREEN + "Strength/Efficiency/Purity: " + decimalFormat.format(tagCompound.func_74760_g("strength")) + "% " + decimalFormat.format(tagCompound.func_74760_g("efficiency")) + "% " + decimalFormat.format(tagCompound.func_74760_g("purity")) + "%");
            list.add(TextFormatting.YELLOW + "Power left: " + decimalFormat.format(power) + "%");
        }
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof ResonatingCrystalTileEntity) {
            ResonatingCrystalTileEntity crystal = (ResonatingCrystalTileEntity)te;
            DecimalFormat fmt = new DecimalFormat("#.#");
            probeInfo.text(TextFormatting.GREEN + "Strength/Efficiency/Purity: " + fmt.format(crystal.getStrength()) + "% " + fmt.format(crystal.getEfficiency()) + "% " + fmt.format(crystal.getPurity()) + "%");
            int rfPerTick = crystal.getRfPerTick();
            if (mode == ProbeMode.DEBUG) {
                probeInfo.text(TextStyleClass.INFO + "RF/t: " + rfPerTick + " RF/t");
                probeInfo.text(TextStyleClass.INFO + "Power: " + fmt.format(crystal.getPower()) + "%");
                probeInfo.text(TextStyleClass.INFO + "Instability: " + fmt.format(crystal.getInstability()));
                probeInfo.text(TextStyleClass.INFO + "Resistance: " + crystal.getResistance());
                probeInfo.text(TextStyleClass.INFO + "Cooldown: " + crystal.getCooldown());
            } else {
                probeInfo.horizontal().text(TextFormatting.YELLOW + "Power: " + fmt.format(crystal.getPower()) + "% (" + rfPerTick + " RF/t)").progress((int)crystal.getPower(), 100, probeInfo.defaultProgressStyle().suffix("%").width(40).height(10).showText(false).filledColor(-65536).alternateFilledColor(-6750208));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity tileEntity = accessor.getTileEntity();
        if (tileEntity instanceof ResonatingCrystalTileEntity) {
            ResonatingCrystalTileEntity resonatingCrystalTileEntity = (ResonatingCrystalTileEntity)tileEntity;
            DecimalFormat decimalFormat = new DecimalFormat("#.##");
            currenttip.add(TextFormatting.GREEN + "Strength/Efficiency/Purity: " + decimalFormat.format(resonatingCrystalTileEntity.getStrength()) + "% " + decimalFormat.format(resonatingCrystalTileEntity.getEfficiency()) + "% " + decimalFormat.format(resonatingCrystalTileEntity.getPurity()) + "%");
            currenttip.add(TextFormatting.YELLOW + "Power left: " + decimalFormat.format(tooltipPower) + "% (" + tooltipRFTick + " RF/t)");
            if (System.currentTimeMillis() - lastTime > 250L) {
                lastTime = System.currentTimeMillis();
                DRMessages.INSTANCE.sendToServer((IMessage)new PacketGetCrystalInfo(tileEntity.func_174877_v()));
            }
        }
        return currenttip;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        if (!world.field_72995_K) {
            ResonatingCrystalBlock.explode(world, pos, false);
        }
        super.onBlockExploded(world, pos, explosion);
    }

    private static void explodeHelper(World world, BlockPos location, float radius) {
        Explosion boom = new Explosion(world, null, (double)location.func_177958_n(), (double)location.func_177956_o(), (double)location.func_177952_p(), radius, false, true);
        int x = (int)(-radius);
        while ((float)x < radius) {
            int y = (int)(-radius);
            while ((float)y < radius) {
                int z = (int)(-radius);
                while ((float)z < radius) {
                    BlockPos targetPosition = location.func_177982_a(x, y, z);
                    double dist = Math.sqrt(location.func_177951_i((Vec3i)targetPosition));
                    if (dist < (double)radius) {
                        Block block = world.func_180495_p(targetPosition).func_177230_c();
                        IBlockState state = world.func_180495_p(targetPosition);
                        if (block != null && !block.isAir(state, (IBlockAccess)world, targetPosition) && block.func_176195_g(state, world, targetPosition) > 0.0f && (dist < (double)(radius - 1.0f) || (double)world.field_73012_v.nextFloat() > 0.7)) {
                            block.onBlockExploded(world, targetPosition, boom);
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public static void explode(World world, BlockPos pos, boolean strong) {
        TileEntity theCrystalTile = world.func_175625_s(pos);
        ElecCore.tickHandler.registerCallServer(() -> {
            float forceMultiplier = 1.0f;
            if (theCrystalTile instanceof ResonatingCrystalTileEntity) {
                ResonatingCrystalTileEntity crystal = (ResonatingCrystalTileEntity)theCrystalTile;
                float explosionStrength = crystal.getPower() * crystal.getStrength() / 10000.0f;
                forceMultiplier = explosionStrength * (RadiationConfiguration.maximumExplosionMultiplier - RadiationConfiguration.minimumExplosionMultiplier) + RadiationConfiguration.minimumExplosionMultiplier;
                if (forceMultiplier > RadiationConfiguration.absoluteMaximumExplosionMultiplier) {
                    forceMultiplier = RadiationConfiguration.absoluteMaximumExplosionMultiplier;
                }
                if (forceMultiplier > 0.001f) {
                    DRRadiationManager radiationManager = DRRadiationManager.getManager(world);
                    DRRadiationManager.RadiationSource source = radiationManager.getOrCreateRadiationSource(new GlobalCoordinate(pos, world.field_73011_w.getDimension()));
                    float radiationRadius = DRRadiationManager.calculateRadiationRadius(crystal.getStrength(), crystal.getEfficiency(), crystal.getPurity());
                    float radiationStrength = DRRadiationManager.calculateRadiationStrength(crystal.getStrength(), crystal.getPurity());
                    source.update(radiationRadius * RadiationConfiguration.radiationExplosionFactor, radiationStrength / RadiationConfiguration.radiationExplosionFactor, 1000);
                }
            }
            if (forceMultiplier > 0.001f) {
                ResonatingCrystalBlock.explodeHelper(world, pos, forceMultiplier);
                if (strong) {
                    // empty if block
                }
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public int getGuiID() {
        return -1;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING_HORIZ, EMPTY, GENERATED});
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState metadata, int fortune) {
        super.getDrops(drops, world, pos, metadata, fortune);
        for (ItemStack drop : drops) {
            NBTTagCompound tagCompound;
            if (!drop.func_77942_o() || !(tagCompound = drop.func_77978_p()).func_74764_b("glowing")) continue;
            tagCompound.func_74757_a("glowing", false);
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        boolean empty = false;
        boolean generated = false;
        if (te instanceof ResonatingCrystalTileEntity) {
            ResonatingCrystalTileEntity resonatingCrystalTileEntity = (ResonatingCrystalTileEntity)te;
            empty = resonatingCrystalTileEntity.isEmpty();
            generated = resonatingCrystalTileEntity.getPurity() > 30.0f;
        }
        return super.func_176221_a(state, worldIn, pos).func_177226_a((IProperty)EMPTY, (Comparable)Boolean.valueOf(empty)).func_177226_a((IProperty)GENERATED, (Comparable)Boolean.valueOf(generated));
    }
}

