/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.darksteel.upgrade.stepassist;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.api.upgrades.IRule;
import crazypants.enderio.base.config.config.DarkSteelConfig;
import crazypants.enderio.base.handler.darksteel.AbstractUpgrade;
import crazypants.enderio.base.handler.darksteel.Rules;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgradeManager;
import crazypants.enderio.base.item.darksteel.upgrade.jump.JumpUpgrade;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="enderio")
public class StepAssistUpgrade
extends AbstractUpgrade {
    @Nonnull
    private static final String UPGRADE_NAME = "step_assist";
    @Nonnull
    public static final StepAssistUpgrade INSTANCE = new StepAssistUpgrade();

    @SubscribeEvent
    public static void registerDarkSteelUpgrades(@Nonnull RegistryEvent.Register<IDarkSteelUpgrade> event) {
        event.getRegistry().register((IForgeRegistryEntry)INSTANCE);
    }

    public static boolean isEquipped(@Nonnull EntityPlayer player) {
        return INSTANCE.hasUpgrade(player.func_184582_a(EntityEquipmentSlot.FEET));
    }

    public StepAssistUpgrade() {
        super(UPGRADE_NAME, 0, "enderio.darksteel.upgrade.step_assist", DarkSteelConfig.stepAssistCost);
    }

    @Override
    @Nonnull
    public List<IRule> getRules() {
        return new NNList((Object[])new IRule[]{Rules.forSlot(EntityEquipmentSlot.FEET), EnergyUpgrade.HAS_ANY, JumpUpgrade.HAS_ANY, Rules.itemTypeTooltip(EntityEquipmentSlot.FEET)});
    }

    @Override
    public boolean canOtherBeRemoved(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item, @Nonnull IDarkSteelUpgrade other) {
        return !EnergyUpgradeManager.isLowestPowerUpgrade(other) && JumpUpgrade.JUMP_ONE != other;
    }

    @Override
    public boolean keybindingDefault() {
        return true;
    }
}

