/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.fluid;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.fluid.IFluidCoolant;
import crazypants.enderio.base.fluid.IFluidFuel;
import crazypants.enderio.base.fluid.IFluidRegister;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FluidFuelRegister
implements IFluidRegister {
    public static final FluidFuelRegister instance = new FluidFuelRegister();
    @Nonnull
    private static final String KEY_FLUID_NAME = "fluidName";
    @Nonnull
    private static final String KEY_POWER_PER_CYCLE = "powerPerCycle";
    @Nonnull
    private static final String KEY_TOTAL_BURN_TIME = "totalBurnTime";
    @Nonnull
    private static final String KEY_COOLING_PER_MB = "coolingPerMb";
    private final Map<String, IFluidCoolant> coolants = new HashMap<String, IFluidCoolant>();
    private final Map<String, IFluidFuel> fuels = new HashMap<String, IFluidFuel>();
    private final List<IFluidRegister> otherRegisters = new ArrayList<IFluidRegister>();

    private FluidFuelRegister() {
    }

    public void addRegister(IFluidRegister register) {
        if (register != null) {
            this.otherRegisters.add(register);
        }
    }

    public void addCoolant(NBTTagCompound tag) {
        if (tag == null) {
            return;
        }
        if (!tag.func_74764_b(KEY_FLUID_NAME)) {
            return;
        }
        if (!tag.func_74764_b(KEY_COOLING_PER_MB)) {
            return;
        }
        this.addCoolant(tag.func_74779_i(KEY_FLUID_NAME), tag.func_74760_g(KEY_COOLING_PER_MB));
    }

    public void addCoolant(String fluidName, float degreesCoolingPerMB) {
        this.addCoolant((Fluid)NullHelper.notnullF((Object)FluidRegistry.getFluid((String)fluidName), (String)("Invalid fluid " + fluidName)), degreesCoolingPerMB);
    }

    @Override
    public void addCoolant(@Nonnull Fluid fluid, float degreesCoolingPerMB) {
        this.coolants.put(fluid.getName(), new CoolantImpl(fluid, degreesCoolingPerMB));
        for (IFluidRegister reg : this.otherRegisters) {
            reg.addCoolant(fluid, degreesCoolingPerMB);
        }
    }

    @Override
    @Nullable
    public IFluidCoolant getCoolant(@Nonnull Fluid fluid) {
        IFluidCoolant res = this.coolants.get(fluid.getName());
        if (res == null && !this.coolants.containsKey(fluid.getName())) {
            IFluidRegister reg;
            Iterator<IFluidRegister> iterator = this.otherRegisters.iterator();
            while (iterator.hasNext() && (res = (reg = iterator.next()).getCoolant(fluid)) == null) {
            }
            this.coolants.put(fluid.getName(), res);
        }
        return res;
    }

    @Override
    @Nullable
    public IFluidCoolant getCoolant(@Nonnull FluidStack fluid) {
        Fluid fluid2 = fluid.getFluid();
        if (fluid2 == null) {
            return null;
        }
        return this.getCoolant(fluid2);
    }

    public void addFuel(NBTTagCompound tag) {
        if (tag == null) {
            return;
        }
        if (!tag.func_74764_b(KEY_FLUID_NAME)) {
            return;
        }
        if (!tag.func_74764_b(KEY_POWER_PER_CYCLE)) {
            return;
        }
        if (!tag.func_74764_b(KEY_TOTAL_BURN_TIME)) {
            return;
        }
        this.addFuel(tag.func_74779_i(KEY_FLUID_NAME), tag.func_74762_e(KEY_POWER_PER_CYCLE), tag.func_74762_e(KEY_TOTAL_BURN_TIME));
    }

    public void addFuel(String fluidName, int powerPerCycleRF, int totalBurnTime) {
        this.addFuel((Fluid)NullHelper.notnullF((Object)FluidRegistry.getFluid((String)fluidName), (String)("Invalid fluid " + fluidName)), powerPerCycleRF, totalBurnTime);
    }

    @Override
    public void addFuel(@Nonnull Fluid fluid, int powerPerCycleRF, int totalBurnTime) {
        this.fuels.put(fluid.getName(), new FuelImpl(fluid, powerPerCycleRF, totalBurnTime));
        for (IFluidRegister reg : this.otherRegisters) {
            reg.addFuel(fluid, powerPerCycleRF, totalBurnTime);
        }
    }

    @Override
    @Nullable
    public IFluidFuel getFuel(@Nonnull Fluid fluid) {
        IFluidFuel res = this.fuels.get(fluid.getName());
        if (res == null && !this.fuels.containsKey(fluid.getName())) {
            IFluidRegister reg;
            Iterator<IFluidRegister> iterator = this.otherRegisters.iterator();
            while (iterator.hasNext() && (res = (reg = iterator.next()).getFuel(fluid)) == null) {
            }
            this.fuels.put(fluid.getName(), res);
        }
        return res;
    }

    @Override
    @Nullable
    public IFluidFuel getFuel(@Nonnull FluidStack fluid) {
        Fluid fluid2 = fluid.getFluid();
        if (fluid2 == null) {
            return null;
        }
        return this.getFuel(fluid2);
    }

    public static class CoolantImpl
    implements IFluidCoolant {
        @Nonnull
        private final Fluid fluid;
        private final float degreesCoolingPerMB;

        public CoolantImpl(@Nonnull Fluid fluid, float degreesCoolingPerMB) {
            this.fluid = fluid;
            this.degreesCoolingPerMB = degreesCoolingPerMB;
        }

        @Override
        @Nonnull
        public Fluid getFluid() {
            return this.fluid;
        }

        @Override
        public double getDegreesCoolingPerMBPerK() {
            return this.degreesCoolingPerMB;
        }
    }

    public static class FuelImpl
    implements IFluidFuel {
        @Nonnull
        private final Fluid fluid;
        private final int powerPerCycle;
        private final int totalBurningTime;

        public FuelImpl(@Nonnull Fluid fluid, int powerPerCycle, int totalBurningTime) {
            this.fluid = fluid;
            this.powerPerCycle = powerPerCycle;
            this.totalBurningTime = totalBurningTime;
        }

        @Override
        @Nonnull
        public Fluid getFluid() {
            return this.fluid;
        }

        @Override
        public int getTotalBurningTime() {
            return this.totalBurningTime;
        }

        @Override
        public int getPowerPerCycle() {
            return this.powerPerCycle;
        }
    }
}

