/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.agriculture.mysticalagriculture;

import com.blakebr0.mysticalagriculture.config.ModConfig;
import com.blakebr0.mysticalagriculture.items.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thelm.jaopca.agriculture.mysticalagriculture.ModuleMysticalAgriculture;
import thelm.jaopca.api.IOreEntry;
import thelm.jaopca.api.ItemEntry;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.block.IBlockWithProperty;
import thelm.jaopca.api.utils.JAOPCAStateMap;

public class BlockCropsBase
extends BlockCrops
implements IBlockWithProperty {
    public static final AxisAlignedBB CROPS_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);
    public final IOreEntry oreEntry;
    public final ItemEntry itemEntry;
    public int tier = -1;
    protected Block crux = null;
    protected Item seed = null;
    protected Item essence = null;

    public BlockCropsBase(Material material, MapColor mapColor, ItemEntry itemEntry, IOreEntry oreEntry) {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176488_a, (Comparable)Integer.valueOf(0)));
        this.func_149663_c("jaopca." + itemEntry.name);
        this.setRegistryName("jaopca:block_" + itemEntry.name + oreEntry.getOreName());
        this.oreEntry = oreEntry;
        this.itemEntry = itemEntry;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        float f;
        this.func_176475_e(world, pos, state);
        if (this.getTier() >= 6 && world.func_180495_p(pos.func_177979_c(2)).func_177230_c() != this.getCrux()) {
            return;
        }
        int i = this.func_185527_x(state);
        if (world.func_175671_l(pos.func_177984_a()) >= 9 && i < this.func_185526_g() && rand.nextInt((int)(35.0f / (f = BlockCropsBase.func_180672_a((Block)this, (World)world, (BlockPos)pos))) + 1) == 0) {
            world.func_180501_a(pos, this.func_185528_e(i + 1), 2);
        }
    }

    public IOreEntry getOreEntry() {
        return this.oreEntry;
    }

    public ItemEntry getItemEntry() {
        return this.itemEntry;
    }

    public int getTier() {
        if (this.tier == -1) {
            this.tier = ModuleMysticalAgriculture.CROP_TIERS.get(this.getOreEntry());
        }
        return this.tier;
    }

    protected boolean func_185514_i(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150458_ak;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return false;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Crop;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CROPS_AABB;
    }

    public Block getCrux() {
        if (this.getTier() >= 6 && this.crux == null) {
            this.crux = (Block)JAOPCAApi.BLOCKS_TABLE.get((Object)"crux", (Object)this.getOreEntry().getOreName());
        }
        if (this.crux != null) {
            return this.crux;
        }
        return Blocks.field_150350_a;
    }

    public Item func_149866_i() {
        if (this.seed == null) {
            this.seed = (Item)JAOPCAApi.ITEMS_TABLE.get((Object)"mysticalSeeds", (Object)this.getOreEntry().getOreName());
        }
        return this.seed;
    }

    public Item func_149865_P() {
        if (this.essence == null) {
            this.essence = (Item)JAOPCAApi.ITEMS_TABLE.get((Object)"essence", (Object)this.getOreEntry().getOreName());
        }
        return this.essence;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        int age = (Integer)state.func_177229_b((IProperty)field_176488_a);
        Random rand = RANDOM;
        int essence = 0;
        int fertilizer = 0;
        int seeds = 1;
        if (age == 7) {
            if (this.getTier() < 6 && ModConfig.confSeedChance > 0) {
                seeds = rand.nextInt(100 / ModConfig.confSeedChance) > 0 ? 1 : 2;
            }
            if (ModConfig.confFertilizedEssenceChance > 0) {
                fertilizer = rand.nextInt(100 / ModConfig.confFertilizedEssenceChance) > 0 ? 0 : 1;
            }
            if (ModConfig.confEssenceChance > 0) {
                essence = rand.nextInt(100 / ModConfig.confEssenceChance) > 0 ? 1 : 2;
            }
        }
        drops.add(new ItemStack(this.func_149866_i(), seeds, 0));
        if (essence > 0) {
            drops.add(new ItemStack(this.func_149865_P(), essence, 0));
        }
        if (fertilizer > 0 && ModConfig.confFertilizedEssence) {
            drops.add(new ItemStack((Item)ModItems.itemFertilizedEssence, fertilizer, 0));
        }
        return drops;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ResourceLocation rl = null;
        switch (this.getOreEntry().getOreType()) {
            case DUST: {
                rl = new ResourceLocation("jaopca:crops_dust");
                break;
            }
            case GEM: 
            case GEM_ORELESS: {
                rl = new ResourceLocation("jaopca:crops_gem");
                break;
            }
            default: {
                rl = new ResourceLocation("jaopca:crops_ingot");
            }
        }
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new JAOPCAStateMap.Builder(rl).build());
    }

    public BlockCropsBase setSoundType(SoundType sound) {
        super.func_149672_a(sound);
        return this;
    }

    public BlockCropsBase setLightOpacity(int opacity) {
        super.func_149713_g(opacity);
        return this;
    }

    public BlockCropsBase setLightLevel(float value) {
        super.func_149715_a(value);
        return this;
    }

    public BlockCropsBase setResistance(float resistance) {
        super.func_149752_b(resistance);
        return this;
    }

    public BlockCropsBase setHardness(float hardness) {
        super.func_149711_c(hardness);
        return this;
    }
}

