/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.agriculture.agricraft;

import com.infinityraider.infinitylib.render.tessellation.ITessellator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import thelm.jaopca.agriculture.agricraft.EnumRenderType;

@SideOnly(value=Side.CLIENT)
public class JAOPCAPlantRenderer {
    public static void renderPlant(ITessellator tessellator, List<Pair<String, Boolean>> iconLocations, EnumRenderType renderType, int color) {
        List icons = iconLocations.stream().map(pair -> Pair.of((Object)tessellator.getIcon(new ResourceLocation((String)pair.getLeft())), (Object)pair.getRight())).collect(Collectors.toList());
        switch (renderType) {
            case CROSS: {
                for (Pair pair2 : icons) {
                    if (pair2.getLeft() == null) continue;
                    JAOPCAPlantRenderer.renderCrossPattern(tessellator, (TextureAtlasSprite)pair2.getLeft(), (Boolean)pair2.getRight() != false ? color : 0xFFFFFF);
                }
                break;
            }
            case HASH: {
                for (Pair pair3 : icons) {
                    if (pair3.getLeft() == null) continue;
                    JAOPCAPlantRenderer.renderHashTagPattern(tessellator, (TextureAtlasSprite)pair3.getLeft(), (Boolean)pair3.getRight() != false ? color : 0xFFFFFF);
                }
                break;
            }
        }
    }

    private static void renderHashTagPattern(ITessellator tessellator, TextureAtlasSprite icon, int color) {
        float rPrev = tessellator.getRed();
        float gPrev = tessellator.getGreen();
        float bPrev = tessellator.getBlue();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        tessellator.setColorRGB(r, g, b);
        tessellator.drawScaledFaceDouble(0.0f, 0.0f, 16.0f, 16.0f, EnumFacing.NORTH, icon, 4.0f);
        tessellator.drawScaledFaceDouble(0.0f, 0.0f, 16.0f, 16.0f, EnumFacing.EAST, icon, 4.0f);
        tessellator.drawScaledFaceDouble(0.0f, 0.0f, 16.0f, 16.0f, EnumFacing.NORTH, icon, 12.0f);
        tessellator.drawScaledFaceDouble(0.0f, 0.0f, 16.0f, 16.0f, EnumFacing.EAST, icon, 12.0f);
        tessellator.setColorRGB(rPrev, gPrev, bPrev);
    }

    private static void renderCrossPattern(ITessellator tessellator, TextureAtlasSprite icon, int color) {
        float rPrev = tessellator.getRed();
        float gPrev = tessellator.getGreen();
        float bPrev = tessellator.getBlue();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        tessellator.setColorRGB(r, g, b);
        tessellator.pushMatrix();
        tessellator.translate(0.5f, 0.0f, 0.5f);
        tessellator.rotate(45.0f, 0.0f, 1.0f, 0.0f);
        tessellator.translate(-0.5f, 0.0f, -0.5f);
        tessellator.drawScaledFaceDouble(0.0f, 0.0f, 16.0f, 16.0f, EnumFacing.NORTH, icon, 8.0f);
        tessellator.drawScaledFaceDouble(0.0f, 0.0f, 16.0f, 16.0f, EnumFacing.EAST, icon, 8.0f);
        tessellator.popMatrix();
        tessellator.setColorRGB(rPrev, gPrev, bPrev);
    }
}

