/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.EventHandler;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import java.util.ArrayList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;

public class TileEntityElectricLantern
extends TileEntityImmersiveConnectable
implements IEBlockInterfaces.ISpawnInterdiction,
ITickable,
IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IActiveState,
IEBlockInterfaces.ILightValue {
    public int energyStorage = 0;
    private int energyDraw = Config.IEConfig.Machines.lantern_energyDraw;
    private int maximumStorage = Config.IEConfig.Machines.lantern_maximumStorage;
    public boolean active = false;
    private boolean interdictionList = false;
    private boolean flipped = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.interdictionList && Config.IEConfig.Machines.lantern_spawnPrevent) {
            ArrayList<IEBlockInterfaces.ISpawnInterdiction> arrayList = EventHandler.interdictionTiles;
            synchronized (arrayList) {
                if (!EventHandler.interdictionTiles.contains(this)) {
                    EventHandler.interdictionTiles.add(this);
                }
            }
            this.interdictionList = true;
        }
        boolean b = this.active;
        if (this.energyStorage >= this.energyDraw) {
            this.energyStorage -= this.energyDraw;
            if (!this.active) {
                this.active = true;
            }
        } else if (this.active) {
            this.active = false;
        }
        if (this.active != b) {
            this.markContainingBlockForUpdate(null);
            this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.func_174877_v());
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 1, 0);
        }
    }

    @Override
    public double getInterdictionRangeSquared() {
        return this.active ? 1024.0 : 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void func_145843_s() {
        ArrayList<IEBlockInterfaces.ISpawnInterdiction> arrayList = EventHandler.interdictionTiles;
        synchronized (arrayList) {
            EventHandler.interdictionTiles.remove(this);
        }
        super.func_145843_s();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onChunkUnload() {
        ArrayList<IEBlockInterfaces.ISpawnInterdiction> arrayList = EventHandler.interdictionTiles;
        synchronized (arrayList) {
            EventHandler.interdictionTiles.remove(this);
        }
        super.onChunkUnload();
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.active = nbt.func_74767_n("active");
        this.energyStorage = nbt.func_74762_e("energyStorage");
        this.flipped = nbt.func_74767_n("flipped");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74757_a("active", this.active);
        nbt.func_74768_a("energyStorage", this.energyStorage);
        nbt.func_74757_a("flipped", this.flipped);
    }

    @Override
    protected boolean canTakeLV() {
        return true;
    }

    @Override
    public boolean isEnergyOutput() {
        return true;
    }

    @Override
    protected boolean isRelay() {
        return true;
    }

    @Override
    public int outputEnergy(int amount, boolean simulate, int energyType) {
        if (amount > 0 && this.energyStorage < this.maximumStorage) {
            if (!simulate) {
                int rec = Math.min(this.maximumStorage - this.energyStorage, this.energyDraw);
                this.energyStorage += rec;
                return rec;
            }
            return Math.min(this.maximumStorage - this.energyStorage, this.energyDraw);
        }
        return 0;
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        if (id == 1) {
            this.markContainingBlockForUpdate(null);
            this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.func_174877_v());
            return true;
        }
        return super.func_145842_c(id, arg);
    }

    @Override
    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        int zDif;
        int xDif;
        int n = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)this.func_174877_v()) && con.end != null ? con.end.func_177958_n() - this.func_174877_v().func_177958_n() : (xDif = con.end.equals((Object)this.func_174877_v()) && con.start != null ? con.start.func_177958_n() - this.func_174877_v().func_177958_n() : 0));
        int n2 = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)this.func_174877_v()) && con.end != null ? con.end.func_177952_p() - this.func_174877_v().func_177952_p() : (zDif = con.end.equals((Object)this.func_174877_v()) && con.start != null ? con.start.func_177952_p() - this.func_174877_v().func_177952_p() : 0));
        if (Math.abs(xDif) >= Math.abs(zDif)) {
            return new Vec3d(xDif < 0 ? 0.25 : (xDif > 0 ? 0.75 : 0.5), this.flipped ? 0.9375 : 0.0625, 0.5);
        }
        return new Vec3d(0.5, this.flipped ? 0.9375 : 0.0625, zDif < 0 ? 0.25 : (zDif > 0 ? 0.75 : 0.5));
    }

    @Override
    public float[] getBlockBounds() {
        return new float[]{0.1875f, 0.0f, 0.1875f, 0.8125f, 1.0f, 0.8125f};
    }

    @Override
    public IEProperties.PropertyBoolInverted getBoolProperty(Class<? extends IEBlockInterfaces.IUsesBooleanProperty> inf) {
        return IEProperties.BOOLEANS[0];
    }

    @Override
    public boolean getIsActive() {
        return this.active;
    }

    @Override
    public int getLightValue() {
        return this.active ? 15 : 0;
    }

    @Override
    public EnumFacing getFacing() {
        return this.flipped ? EnumFacing.UP : EnumFacing.NORTH;
    }

    @Override
    public void setFacing(EnumFacing facing) {
    }

    @Override
    public int getFacingLimitation() {
        return -1;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return false;
    }

    @Override
    public boolean canRotate(EnumFacing axis) {
        return false;
    }

    @Override
    public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ) {
        this.flipped = !this.flipped;
        this.markContainingBlockForUpdate(null);
        this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), this.active ? 1 : 0, 0);
        return true;
    }

    @Override
    public boolean moveConnectionTo(ImmersiveNetHandler.Connection c, BlockPos newEnd) {
        return true;
    }
}

