/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.compat;

import astavie.thermallogistics.attachment.ICrafter;
import astavie.thermallogistics.compat.ICrafterWrapper;
import astavie.thermallogistics.process.RequestItem;
import cofh.core.block.TileReconfigurable;
import cofh.core.inventory.InventoryCraftingFalse;
import cofh.core.util.core.SideConfig;
import cofh.core.util.helpers.FluidHelper;
import cofh.thermalexpansion.block.machine.TileCrafter;
import cofh.thermalexpansion.item.ItemFrame;
import java.lang.reflect.Field;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class CompatTE
implements ICrafterWrapper<TileCrafter> {
    public static final Class<TileCrafter> TILE = TileCrafter.class;
    public static final ItemStack MACHINE_FRAME = ItemFrame.frameMachine;
    private static final Field sideConfig;

    @Override
    public <I> void populate(TileCrafter tile, byte side, ICrafter.Recipe<I> recipe, Class<I> itemClass) {
        if (itemClass == ItemStack.class) {
            this.populateItems(tile, side, recipe);
        } else if (itemClass == FluidStack.class) {
            this.populateFluids(tile, side, recipe);
        }
    }

    private void populateItems(TileCrafter tile, byte side, ICrafter.Recipe<ItemStack> recipe) {
        boolean[] extraction;
        int i;
        SideConfig sides = null;
        try {
            sides = (SideConfig)sideConfig.get(tile);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (SideConfig.allowInsertion((int)sides.sideTypes[tile.sideCache[side]])) {
            FluidStack fluid = null;
            if (tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
                for (int i2 = 0; i2 < 9; ++i2) {
                    ItemStack stack = tile.inventory[20 + i2];
                    if (!FluidHelper.isFluidHandler((ItemStack)stack)) continue;
                    fluid = FluidHelper.getFluidForFilledItem((ItemStack)stack);
                    break;
                }
            }
            RequestItem request = new RequestItem(null);
            for (i = 0; i < 9; ++i) {
                ItemStack stack = tile.inventory[20 + i];
                if (fluid != null && FluidHelper.isFluidEqual((FluidStack)fluid, (FluidStack)FluidHelper.getFluidForFilledItem((ItemStack)stack))) continue;
                request.addStack(stack);
            }
            for (i = 0; i < recipe.inputs.size() && i != request.stacks.size(); ++i) {
                recipe.inputs.set(i, request.stacks.get(i));
            }
        }
        if ((extraction = new boolean[]{false, false, true, true, true, false, false, true, true})[sides.sideTypes[tile.sideCache[side]]]) {
            InventoryCraftingFalse matrix = new InventoryCraftingFalse(3, 3);
            for (i = 0; i < 9; ++i) {
                matrix.func_70299_a(i, tile.inventory[20 + i]);
            }
            recipe.outputs.set(0, CraftingManager.func_82787_a((InventoryCrafting)matrix, (World)tile.func_145831_w()));
        }
    }

    private void populateFluids(TileCrafter tile, byte side, ICrafter.Recipe<FluidStack> recipe) {
        SideConfig sides = null;
        try {
            sides = (SideConfig)sideConfig.get(tile);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (SideConfig.allowInsertion((int)sides.sideTypes[tile.sideCache[side]]) && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            ItemStack stack;
            int i;
            FluidStack fluid = null;
            for (i = 0; i < 9; ++i) {
                stack = tile.inventory[20 + i];
                if (!FluidHelper.isFluidHandler((ItemStack)stack)) continue;
                fluid = FluidHelper.getFluidForFilledItem((ItemStack)stack);
                break;
            }
            if (fluid != null && fluid.amount != 0) {
                fluid = fluid.copy();
                fluid.amount = 0;
                for (i = 0; i < 9; ++i) {
                    FluidStack f;
                    stack = tile.inventory[20 + i];
                    if (!FluidHelper.isFluidHandler((ItemStack)stack) || !FluidHelper.isFluidEqual((FluidStack)fluid, (FluidStack)(f = FluidHelper.getFluidForFilledItem((ItemStack)stack)))) continue;
                    fluid.amount += f.amount;
                }
                if (fluid.amount > 0) {
                    recipe.inputs.set(0, fluid);
                }
            }
        }
    }

    static {
        Field field = null;
        try {
            field = TileReconfigurable.class.getDeclaredField("sideConfig");
            field.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        sideConfig = field;
    }
}

