/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.client.gui.tab;

import astavie.thermallogistics.attachment.ICrafter;
import astavie.thermallogistics.client.TLTextures;
import astavie.thermallogistics.util.RequesterReference;
import astavie.thermallogistics.util.StackHandler;
import cofh.core.gui.GuiContainerCore;
import cofh.core.gui.element.tab.TabBase;
import cofh.core.init.CoreTextures;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTileInfo;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.StringHelper;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;

public class TabLink
extends TabBase {
    private static final int HEIGHT = 18;
    private final ICrafter<?> crafter;
    private int num;
    private int max;
    private int first = 0;

    public TabLink(GuiContainerCore gui, ICrafter<?> crafter) {
        this(gui, 1, crafter);
    }

    public TabLink(GuiContainerCore gui, int side, ICrafter<?> crafter) {
        super(gui, side);
        this.crafter = crafter;
        this.maxHeight = 96;
        this.backgroundColor = 12872960;
        this.num = Math.min((this.maxHeight - 24) / 18, crafter.getLinked().size());
        this.max = crafter.getLinked().size() - this.num;
    }

    public void update() {
        super.update();
        if (this.max != this.crafter.getLinked().size() - this.num || this.num > this.crafter.getLinked().size()) {
            this.num = Math.min((this.maxHeight - 24) / 18, this.crafter.getLinked().size());
            this.max = this.crafter.getLinked().size() - this.num;
            if (this.first > this.max) {
                this.first = this.max;
            }
        }
    }

    protected void drawForeground() {
        GlStateManager.func_179140_f();
        this.drawTabIcon(TLTextures.ICON_LINK);
        if (!this.isFullyOpened()) {
            return;
        }
        int mouseX = this.gui.getMouseX() - this.posX();
        int mouseY = this.gui.getMouseY() - this.posY;
        if (this.first > 0) {
            this.gui.drawIcon(CoreTextures.ICON_ARROW_UP, this.sideOffset() + this.maxWidth - 20, 16);
        } else {
            this.gui.drawIcon(CoreTextures.ICON_ARROW_UP_INACTIVE, this.sideOffset() + this.maxWidth - 20, 16);
        }
        if (this.first < this.max) {
            this.gui.drawIcon(CoreTextures.ICON_ARROW_DOWN, this.sideOffset() + this.maxWidth - 20, 76);
        } else {
            this.gui.drawIcon(CoreTextures.ICON_ARROW_DOWN_INACTIVE, this.sideOffset() + this.maxWidth - 20, 76);
        }
        this.getFontRenderer().func_175063_a(this.getTitle(), (float)(this.sideOffset() + 18), 6.0f, this.headerColor);
        RenderHelper.func_74518_a();
        RenderHelper.func_74520_c();
        for (int i = this.first; i < this.first + this.num; ++i) {
            int x = this.sideOffset() + 2;
            int y = 21 + (i - this.first) * 18;
            RequesterReference<?> link = this.crafter.getLinked().get(i);
            this.gui.drawItemStack(link.getTileIcon(), x, y, false, null);
            this.gui.drawItemStack(link.getIcon(), x + 18, y, false, null);
            this.gui.drawIcon(TLTextures.ICON_ARROW_RIGHT, x + 36, y);
            int max = 2;
            int num = link.outputs.size() > max ? max - 1 : link.outputs.size();
            for (int j = 0; j < num; ++j) {
                StackHandler.render(this.gui, x + (j + 3) * 18, y, link.outputs.get(j), true);
            }
            if (num < link.outputs.size()) {
                this.gui.getFontRenderer().func_78276_b("...", x + (max + 2) * 18 + 1, y + 4, this.textColor);
            }
            if (mouseX >= x + 90 && mouseX < x + 106 && mouseY >= y && mouseY < y + 16) {
                this.gui.drawIcon(CoreTextures.ICON_CANCEL, x + 90, y);
                continue;
            }
            this.gui.drawIcon(CoreTextures.ICON_CANCEL_INACTIVE, x + 90, y);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void addTooltip(List<String> list) {
        if (!this.isFullyOpened()) {
            list.add(this.getTitle());
        } else {
            int mouseX = this.gui.getMouseX() - this.posX();
            int mouseY = this.gui.getMouseY() - this.posY;
            for (int i = this.first; i < this.first + this.num; ++i) {
                int x = this.sideOffset() + 2;
                int y = 21 + (i - this.first) * 18;
                RequesterReference<?> link = this.crafter.getLinked().get(i);
                if (mouseX >= x - 1 && mouseX < x + 17 && mouseY >= y - 1 && mouseY < y + 17) {
                    list.addAll(this.gui.func_191927_a(link.getTileIcon()));
                }
                if (mouseX >= x + 17 && mouseX < x + 35 && mouseY >= y - 1 && mouseY < y + 17) {
                    list.addAll(this.gui.func_191927_a(link.getIcon()));
                }
                int max = 2;
                int num = link.outputs.size() > max ? max - 1 : link.outputs.size();
                for (int j = 0; j < num; ++j) {
                    if (mouseX < x + (j + 3) * 18 - 1 || mouseX >= x + (j + 3) * 18 + 17 || mouseY < y - 1 || mouseY >= y + 17) continue;
                    list.addAll(StackHandler.getTooltip(this.gui, link.outputs.get(j)));
                }
            }
        }
    }

    private String getTitle() {
        return StringHelper.localize((String)"info.logistics.tab.link");
    }

    public boolean onMousePressed(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (!this.isFullyOpened()) {
            return false;
        }
        int shiftedMouseX = mouseX - this.posX();
        int shiftedMouseY = mouseY - this.posY;
        if (shiftedMouseX < 108) {
            int x = shiftedMouseX - this.sideOffset() - 2;
            int y = shiftedMouseY - 22;
            if (x >= 90 && y >= 0 && y < 18 * this.num) {
                int n = this.first + y / 18;
                this.crafter.getLinked().remove(n);
                this.num = Math.min((this.maxHeight - 24) / 18, this.crafter.getLinked().size());
                this.max = this.crafter.getLinked().size() - this.num;
                if (this.first > this.max) {
                    this.first = this.max;
                }
                PacketTileInfo packet = this.crafter.getNewPacket((byte)0);
                packet.addByte(2);
                packet.addInt(n);
                PacketHandler.sendToServer((PacketBase)packet);
                GuiContainerCore.playClickSound((float)1.0f);
                return true;
            }
            return super.onMousePressed(mouseX, mouseY, mouseButton);
        }
        this.first = shiftedMouseY < 52 ? MathHelper.clamp((int)(this.first - 1), (int)0, (int)this.max) : MathHelper.clamp((int)(this.first + 1), (int)0, (int)this.max);
        return true;
    }

    public boolean onMouseWheel(int mouseX, int mouseY, int movement) {
        if (!this.isFullyOpened()) {
            return false;
        }
        if (movement > 0) {
            this.first = MathHelper.clamp((int)(this.first - 1), (int)0, (int)this.max);
            return true;
        }
        if (movement < 0) {
            this.first = MathHelper.clamp((int)(this.first + 1), (int)0, (int)this.max);
            return true;
        }
        return false;
    }
}

