/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.client.gui;

import astavie.thermallogistics.client.gui.element.ElementTextFieldAmount;
import astavie.thermallogistics.client.gui.element.ElementTextFieldClear;
import astavie.thermallogistics.tile.TileTerminal;
import astavie.thermallogistics.util.StackHandler;
import cofh.core.gui.GuiContainerCore;
import cofh.core.gui.element.ElementButtonManaged;
import cofh.core.gui.element.ElementSlider;
import cofh.core.gui.element.ElementTextField;
import cofh.core.gui.element.listbox.SliderVertical;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTileInfo;
import cofh.core.util.helpers.RenderHelper;
import cofh.core.util.helpers.StringHelper;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Triple;

public abstract class GuiTerminal<I>
extends GuiContainerCore {
    protected final ElementTextField search = new ElementTextFieldClear(this, 80, 5, 88, 10);
    protected final ElementSlider slider = new SliderVertical((GuiContainerCore)this, 174, 18, 12, 52, 0);
    protected final ElementTextField amount = new ElementTextFieldAmount(this, 44, 77, 53, 10);
    protected final List<Triple<I, Long, Boolean>> filter = NonNullList.func_191196_a();
    protected final TileTerminal<I> tile;
    protected I selected;
    protected final ElementButtonManaged button = new ElementButtonManaged(this, 100, 74, 50, 16, ""){

        public void onClick() {
            GuiTerminal.this.request(GuiTerminal.this.selected, GuiTerminal.this.amount.getText().isEmpty() ? 1 : Integer.parseInt(GuiTerminal.this.amount.getText()));
        }
    };
    private String cache = "";

    protected void request(I stack, int amount) {
        PacketTileInfo packet = PacketTileInfo.newPacket(this.tile);
        packet.addByte(0);
        StackHandler.writePacket((PacketBase)packet, stack, this.tile.getItemClass(), true);
        packet.addInt(amount);
        PacketHandler.sendToServer((PacketBase)packet);
    }

    public GuiTerminal(TileTerminal<I> tile, Container container, ResourceLocation texture) {
        super(container, texture);
        this.tile = tile;
    }

    protected Slot requester() {
        return (Slot)this.field_147002_h.field_75151_b.get(0);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.name = this.tile.customName;
        if (this.name.isEmpty()) {
            this.name = StringHelper.localize((String)this.tile.getTileName());
        }
        this.elements.add(this.search);
        this.elements.add(this.slider);
        boolean visible = this.requester().func_75216_d();
        this.amount.setVisible(visible);
        this.button.setVisible(visible);
        this.button.setText(StringHelper.localize((String)"gui.logistics.terminal.request"));
        this.elements.add(this.amount);
        this.elements.add(this.button);
    }

    public void func_73876_c() {
        super.func_73876_c();
        boolean visible = this.requester().func_75216_d();
        this.amount.setVisible(visible && this.selected != null);
        this.button.setVisible(visible);
        if (!visible) {
            this.selected = null;
        }
        this.button.setEnabled(false);
        long count = 1L;
        if (!this.amount.getText().isEmpty()) {
            count = Long.parseLong(this.amount.getText());
        }
        if (this.amount.isEnabled()) {
            for (Triple stack : this.tile.terminal) {
                if (!this.isSelected(stack.getLeft())) continue;
                this.button.setEnabled(count <= Integer.MAX_VALUE && ((Boolean)stack.getRight() != false || (Long)stack.getMiddle() >= count));
                break;
            }
        }
        if (this.tile.refresh || !this.search.getText().equals(this.cache)) {
            this.tile.refresh = false;
            this.cache = this.search.getText();
            this.updateFilter();
            this.slider.setLimits(0, Math.max((this.filter.size() - 1) / 9 - 2, 0));
            this.slider.setEnabled(this.filter.size() > 27);
        }
    }

    public void addTooltips(List<String> tooltip) {
        super.addTooltips(tooltip);
        if (this.selected != null && this.button.isVisible() && this.mouseX >= 25 && this.mouseX < 43 && this.mouseY >= 73 && this.mouseY < 91) {
            tooltip.addAll(StackHandler.getTooltip(this, this.selected));
        }
        int i = this.slider.getValue() * 9;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                int slot = i + x + y * 9;
                if (slot >= this.filter.size()) {
                    return;
                }
                int posX = 8 + x * 18;
                int posY = 18 + y * 18;
                if (this.mouseX < posX - 1 || this.mouseX >= posX + 17 || this.mouseY < posY - 1 || this.mouseY >= posY + 17) continue;
                tooltip.addAll(StackHandler.getTooltip(this, this.filter.get(slot).getLeft()));
            }
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        RenderHelper.enableGUIStandardItemLighting();
        if (this.selected != null && this.button.isVisible()) {
            StackHandler.render((GuiContainerCore)this, 26, 74, this.selected, false);
        }
        int i = this.slider.getValue() * 9;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                int slot = i + x + y * 9;
                if (slot >= this.filter.size()) {
                    return;
                }
                int posX = 8 + x * 18;
                int posY = 18 + y * 18;
                Triple<I, Long, Boolean> triple = this.filter.get(slot);
                if (this.isSelected(triple.getLeft())) {
                    GlStateManager.func_179140_f();
                    GlStateManager.func_179097_i();
                    this.func_73733_a(posX, posY, posX + 16, posY + 16, -3815995, -3815995);
                    GlStateManager.func_179145_e();
                    GlStateManager.func_179126_j();
                }
                GlStateManager.func_179126_j();
                StackHandler.render((GuiContainerCore)this, posX, posY, triple.getLeft(), (Long)triple.getMiddle() == 0L ? "Craft" : StringHelper.getScaledNumber((long)((Long)triple.getMiddle())));
            }
        }
    }

    protected void func_73864_a(int mX, int mY, int mouseButton) throws IOException {
        if (this.button.isVisible()) {
            int mouseX = mX - this.field_147003_i - 7;
            int mouseY = mY - this.field_147009_r - 17;
            if (mouseX >= 0 && mouseX < 162 && mouseY >= 0 && mouseY < 54) {
                int posX = mouseX / 18;
                int posY = mouseY / 18;
                int slot = this.slider.getValue() * 9 + posX + posY * 9;
                if (slot < this.filter.size()) {
                    this.selected = this.filter.get(slot).getLeft();
                    this.updateAmount(this.filter.get(slot));
                } else {
                    this.selected = null;
                }
                return;
            }
        }
        super.func_73864_a(mX, mY, mouseButton);
    }

    protected void func_73869_a(char characterTyped, int keyPressed) throws IOException {
        if (keyPressed == 28 && this.amount.isFocused()) {
            this.button.onMousePressed(0, 0, 0);
        } else {
            super.func_73869_a(characterTyped, keyPressed);
        }
    }

    protected abstract boolean isSelected(I var1);

    protected abstract void updateFilter();

    protected abstract void updateAmount(Triple<I, Long, Boolean> var1);

    protected boolean onMouseWheel(int mouseX, int mouseY, int wheelMovement) {
        return mouseX >= 7 && mouseX < 169 && mouseY >= 17 && mouseY < 71 && this.slider.onMouseWheel(mouseX, mouseY, wheelMovement);
    }

    protected int getCenteredOffset(String string) {
        return 8;
    }
}

