/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.attachment;

import astavie.thermallogistics.ThermalLogistics;
import astavie.thermallogistics.attachment.ICrafter;
import astavie.thermallogistics.attachment.IRequester;
import astavie.thermallogistics.client.TLTextures;
import astavie.thermallogistics.client.gui.GuiCrafter;
import astavie.thermallogistics.compat.ICrafterWrapper;
import astavie.thermallogistics.container.ContainerCrafter;
import astavie.thermallogistics.process.Process;
import astavie.thermallogistics.process.ProcessFluid;
import astavie.thermallogistics.process.Request;
import astavie.thermallogistics.process.RequestFluid;
import astavie.thermallogistics.util.RequesterReference;
import astavie.thermallogistics.util.StackHandler;
import codechicken.lib.fluid.FluidUtils;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTileInfo;
import cofh.core.util.helpers.BlockHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.thermaldynamics.ThermalDynamics;
import cofh.thermaldynamics.duct.attachments.filter.IFilterFluid;
import cofh.thermaldynamics.duct.attachments.servo.ServoFluid;
import cofh.thermaldynamics.duct.attachments.servo.ServoItem;
import cofh.thermaldynamics.duct.fluid.DuctUnitFluid;
import cofh.thermaldynamics.duct.item.DuctUnitItem;
import cofh.thermaldynamics.duct.item.GridItem;
import cofh.thermaldynamics.duct.tiles.DuctUnit;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermaldynamics.multiblock.Route;
import cofh.thermaldynamics.render.RenderDuct;
import cofh.thermaldynamics.util.ListWrapper;
import com.google.common.primitives.Ints;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandler;

public class CrafterFluid
extends ServoFluid
implements ICrafter<FluidStack> {
    public static final ResourceLocation ID = new ResourceLocation("thermallogistics", "crafter_fluid");
    public static final int[] SIZE = new int[]{1, 2, 3, 4, 6};
    public static final int[][] SPLITS = new int[][]{{1}, {2, 1}, {3, 1}, {4, 2, 1}, {6, 3, 2, 1}};
    private final List<ICrafter.Recipe<FluidStack>> recipes = NonNullList.func_191196_a();
    private final List<RequesterReference<?>> linked = NonNullList.func_191196_a();
    private final ProcessFluid process = new ProcessFluid(this);
    private final RequestFluid sent = new RequestFluid(null);
    private final IFilterFluid filter = new Filter(this);

    public CrafterFluid(TileGrid tile, byte side, int type) {
        super(tile, side, type);
        ICrafter.Recipe<FluidStack> recipe = new ICrafter.Recipe<FluidStack>(new RequestFluid(null));
        recipe.inputs.addAll(Collections.nCopies(SIZE[type] * 2, null));
        recipe.outputs.addAll(Collections.nCopies(SIZE[type], null));
        this.recipes.add(recipe);
    }

    public CrafterFluid(TileGrid tile, byte side) {
        super(tile, side);
    }

    public boolean canSend() {
        return false;
    }

    public boolean allowDuctConnection() {
        return true;
    }

    public String getInfo() {
        return "tab.thermallogistics.crafterFluid";
    }

    public ResourceLocation getId() {
        return ID;
    }

    public ItemStack getPickBlock() {
        return new ItemStack((Item)ThermalLogistics.Items.crafter, 1, this.type);
    }

    public String getName() {
        return this.getPickBlock().func_77977_a() + ".name";
    }

    public boolean render(IBlockAccess world, BlockRenderLayer layer, CCRenderState ccRenderState) {
        if (layer != BlockRenderLayer.SOLID) {
            return false;
        }
        Translation trans = Vector3.fromTileCenter((TileEntity)this.baseTile).translation();
        RenderDuct.modelConnection[this.isPowered ? 1 : 2][this.side].render(ccRenderState, new IVertexOperation[]{trans, new IconTransformation(TLTextures.CRAFTER[this.stuffed ? 1 : 0][this.type])});
        return true;
    }

    private void checkLinked() {
        Iterator<RequesterReference<?>> iterator = this.linked.iterator();
        while (iterator.hasNext()) {
            IRequester<?> requester = iterator.next().getAttachment();
            if (!(requester instanceof ICrafter)) {
                iterator.remove();
                this.markDirty();
                continue;
            }
            ICrafter crafter = (ICrafter)requester;
            if (crafter.hasLinked(this)) continue;
            iterator.remove();
            this.markDirty();
        }
    }

    @Override
    public void claim(ICrafter<FluidStack> crafter, FluidStack stack) {
        Iterator iterator = this.process.requests.iterator();
        while (iterator.hasNext()) {
            Request request = (Request)iterator.next();
            if (!request.attachment.references(crafter)) continue;
            request.decreaseStack(stack);
            if (request.stacks.isEmpty()) {
                iterator.remove();
            }
            return;
        }
    }

    @Override
    public boolean hasRequests() {
        return this.recipes.stream().anyMatch(recipe -> !recipe.requests.isEmpty()) || this.linked.stream().anyMatch(reference -> ((ICrafter)reference.getAttachment()).getRecipes().stream().anyMatch(recipe -> !recipe.requests.isEmpty()));
    }

    public void tick(int pass) {
        if (pass == 0 && ((DuctUnitFluid.Cache[])this.fluidDuct.tileCache)[this.side] != null && !(((DuctUnitFluid.Cache[])this.fluidDuct.tileCache)[this.side] instanceof CacheWrapper)) {
            ((DuctUnitFluid.Cache[])this.fluidDuct.tileCache)[this.side] = new CacheWrapper(((DuctUnitFluid.Cache[])this.fluidDuct.tileCache)[this.side].tile, this);
        }
        if (pass != 1 || this.fluidDuct.getGrid() == null || !this.isPowered || !this.isValidInput) {
            return;
        }
        this.checkLinked();
        boolean changed = false;
        for (ICrafter.Recipe<FluidStack> recipe : this.recipes) {
            changed |= ProcessFluid.checkRequests(this, recipe.requests, IRequester::getInputFrom);
        }
        if (changed) {
            HashSet<FluidStack> set = new HashSet<FluidStack>();
            block1: for (FluidStack stack : this.process.getStacks()) {
                for (FluidStack compare : set) {
                    if (!this.itemsIdentical(stack, compare)) continue;
                    compare.amount += stack.amount;
                    continue block1;
                }
                set.add(stack.copy());
            }
            Map map = set.stream().collect(Collectors.toMap(Function.identity(), item -> Math.max(item.amount - this.required((FluidStack)item), 0)));
            map.entrySet().removeIf(e -> (Integer)e.getValue() == 0);
            Iterator iterator = this.process.requests.iterator();
            while (iterator.hasNext() && !map.isEmpty()) {
                Request request = (Request)iterator.next();
                Iterator iterator1 = request.stacks.iterator();
                block4: while (iterator1.hasNext() && !map.isEmpty()) {
                    FluidStack stack = (FluidStack)iterator1.next();
                    Iterator iterator2 = map.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry entry = iterator2.next();
                        if (!this.itemsIdentical((FluidStack)entry.getKey(), stack)) continue;
                        int shrink = Math.min(stack.amount, entry.getValue());
                        stack.amount -= shrink;
                        entry.setValue(entry.getValue() - shrink);
                        if (stack.amount <= 0) {
                            iterator1.remove();
                        }
                        if (entry.getValue() != 0) continue block4;
                        iterator2.remove();
                        continue block4;
                    }
                }
                if (!request.stacks.isEmpty()) continue;
                iterator.remove();
            }
        }
        this.process.tick();
    }

    public IFilterFluid getFluidFilter() {
        return this.filter;
    }

    public void onNeighborChange() {
        boolean wasPowered = this.isPowered;
        super.onNeighborChange();
        if (wasPowered && !this.isPowered) {
            this.process.requests.clear();
            this.sent.stacks.clear();
            for (ICrafter.Recipe<FluidStack> recipe : this.recipes) {
                recipe.requests.clear();
                recipe.leftovers.stacks.clear();
            }
        }
    }

    public void checkSignal() {
        boolean wasPowered = this.isPowered;
        super.checkSignal();
        if (wasPowered && !this.isPowered) {
            this.process.requests.clear();
            this.sent.stacks.clear();
            for (ICrafter.Recipe<FluidStack> recipe : this.recipes) {
                recipe.requests.clear();
                recipe.leftovers.stacks.clear();
            }
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        NBTTagList recipes = new NBTTagList();
        for (ICrafter.Recipe<FluidStack> recipe : this.recipes) {
            Object stack22;
            NBTTagList inputs = new NBTTagList();
            for (Object stack22 : recipe.inputs) {
                inputs.func_74742_a((NBTBase)(stack22 == null ? new NBTTagCompound() : stack22.writeToNBT(new NBTTagCompound())));
            }
            NBTTagList outputs = new NBTTagList();
            stack22 = recipe.outputs.iterator();
            while (stack22.hasNext()) {
                FluidStack stack3 = (FluidStack)stack22.next();
                outputs.func_74742_a((NBTBase)(stack3 == null ? new NBTTagCompound() : stack3.writeToNBT(new NBTTagCompound())));
            }
            NBTTagList requests = new NBTTagList();
            for (Request request : recipe.requests) {
                requests.func_74742_a((NBTBase)RequestFluid.writeNBT(request));
            }
            NBTTagList leftovers = new NBTTagList();
            for (FluidStack stack4 : recipe.leftovers.stacks) {
                leftovers.func_74742_a((NBTBase)stack4.writeToNBT(new NBTTagCompound()));
            }
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74782_a("inputs", (NBTBase)inputs);
            nBTTagCompound.func_74782_a("outputs", (NBTBase)outputs);
            nBTTagCompound.func_74782_a("requests", (NBTBase)requests);
            nBTTagCompound.func_74782_a("leftovers", (NBTBase)leftovers);
            recipes.func_74742_a((NBTBase)nBTTagCompound);
        }
        NBTTagList sent = new NBTTagList();
        for (FluidStack stack : this.sent.stacks) {
            sent.func_74742_a((NBTBase)stack.writeToNBT(new NBTTagCompound()));
        }
        NBTTagList nBTTagList = new NBTTagList();
        for (RequesterReference<?> reference : this.linked) {
            nBTTagList.func_74742_a((NBTBase)RequesterReference.writeNBT(reference));
        }
        tag.func_74782_a("recipes", (NBTBase)recipes);
        tag.func_74782_a("process", (NBTBase)this.process.writeNbt());
        tag.func_74782_a("sent", (NBTBase)sent);
        tag.func_74782_a("linked", (NBTBase)nBTTagList);
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.recipes.clear();
        this.sent.stacks.clear();
        if (tag.func_74764_b("Inputs") || tag.func_74764_b("Outputs") || tag.func_74764_b("Linked")) {
            ICrafter.Recipe<FluidStack> recipe = new ICrafter.Recipe<FluidStack>(new RequestFluid(null));
            recipe.inputs.addAll(Collections.nCopies(SIZE[this.type] * 2, null));
            recipe.outputs.addAll(Collections.nCopies(SIZE[this.type], null));
            NBTTagList inputs = tag.func_150295_c("Inputs", 10);
            for (int i = 0; i < inputs.func_74745_c(); ++i) {
                NBTTagCompound compound = inputs.func_150305_b(i);
                recipe.inputs.set(compound.func_74762_e("Slot"), FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound));
            }
            NBTTagList outputs = tag.func_150295_c("Outputs", 10);
            for (int i = 0; i < outputs.func_74745_c(); ++i) {
                NBTTagCompound compound = outputs.func_150305_b(i);
                recipe.outputs.set(compound.func_74762_e("Slot"), FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound));
            }
            this.recipes.add(recipe);
            NBTTagList linked = tag.func_150295_c("Linked", 10);
            for (int i = 0; i < linked.func_74745_c(); ++i) {
                NBTTagCompound compound = linked.func_150305_b(i);
                this.linked.add(RequesterReference.readNBT(compound));
            }
        } else {
            NBTTagList recipes = tag.func_150295_c("recipes", 10);
            for (int i = 0; i < recipes.func_74745_c(); ++i) {
                NBTTagCompound nbt = recipes.func_150305_b(i);
                ICrafter.Recipe<FluidStack> recipe = new ICrafter.Recipe<FluidStack>(new RequestFluid(null));
                NBTTagList inputs = nbt.func_150295_c("inputs", 10);
                for (int j = 0; j < inputs.func_74745_c(); ++j) {
                    recipe.inputs.add(FluidStack.loadFluidStackFromNBT((NBTTagCompound)inputs.func_150305_b(j)));
                }
                NBTTagList outputs = nbt.func_150295_c("outputs", 10);
                for (int j = 0; j < outputs.func_74745_c(); ++j) {
                    recipe.outputs.add(FluidStack.loadFluidStackFromNBT((NBTTagCompound)outputs.func_150305_b(j)));
                }
                NBTTagList requests = nbt.func_150295_c("requests", 10);
                for (int j = 0; j < requests.func_74745_c(); ++j) {
                    recipe.requests.add(RequestFluid.readNBT(requests.func_150305_b(j)));
                }
                NBTTagList leftovers = nbt.func_150295_c("leftovers", 10);
                for (int j = 0; j < leftovers.func_74745_c(); ++j) {
                    recipe.leftovers.stacks.add(FluidStack.loadFluidStackFromNBT((NBTTagCompound)leftovers.func_150305_b(j)));
                }
                this.recipes.add(recipe);
            }
            this.process.readNbt(tag.func_150295_c("process", 10));
            NBTTagList sent = tag.func_150295_c("sent", 10);
            for (int i = 0; i < sent.func_74745_c(); ++i) {
                this.sent.stacks.add(FluidStack.loadFluidStackFromNBT((NBTTagCompound)sent.func_150305_b(i)));
            }
            NBTTagList linked = tag.func_150295_c("linked", 10);
            for (int i = 0; i < linked.func_74745_c(); ++i) {
                this.linked.add(RequesterReference.readNBT(linked.func_150305_b(i)));
            }
        }
    }

    public void writePortableData(EntityPlayer player, NBTTagCompound tag) {
        super.writePortableData(player, tag);
        NBTTagList recipes = new NBTTagList();
        for (ICrafter.Recipe<FluidStack> recipe : this.recipes) {
            Object stack2;
            NBTTagList inputs = new NBTTagList();
            for (Object stack2 : recipe.inputs) {
                inputs.func_74742_a((NBTBase)(stack2 == null ? new NBTTagCompound() : stack2.writeToNBT(new NBTTagCompound())));
            }
            NBTTagList outputs = new NBTTagList();
            stack2 = recipe.outputs.iterator();
            while (stack2.hasNext()) {
                FluidStack stack3 = (FluidStack)stack2.next();
                outputs.func_74742_a((NBTBase)(stack3 == null ? new NBTTagCompound() : stack3.writeToNBT(new NBTTagCompound())));
            }
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74782_a("inputs", (NBTBase)inputs);
            nbt.func_74782_a("outputs", (NBTBase)outputs);
            recipes.func_74742_a((NBTBase)nbt);
        }
        tag.func_74778_a("DisplayType", new ItemStack((Item)ThermalLogistics.Items.crafter).func_77977_a() + ".name");
        tag.func_74768_a("recipesType", this.type);
        tag.func_74778_a("recipesClass", "FluidStack");
        tag.func_74782_a("recipes", (NBTBase)recipes);
    }

    public void readPortableData(EntityPlayer player, NBTTagCompound tag) {
        super.readPortableData(player, tag);
        if (tag.func_74762_e("recipesType") == this.type && tag.func_74779_i("recipesClass").equals("FluidStack")) {
            this.recipes.clear();
            this.sent.stacks.clear();
            NBTTagList recipes = tag.func_150295_c("recipes", 10);
            for (int i = 0; i < recipes.func_74745_c(); ++i) {
                NBTTagCompound nbt = recipes.func_150305_b(i);
                ICrafter.Recipe<FluidStack> recipe = new ICrafter.Recipe<FluidStack>(new RequestFluid(null));
                NBTTagList inputs = nbt.func_150295_c("inputs", 10);
                for (int j = 0; j < inputs.func_74745_c(); ++j) {
                    recipe.inputs.add(FluidStack.loadFluidStackFromNBT((NBTTagCompound)inputs.func_150305_b(j)));
                }
                NBTTagList outputs = nbt.func_150295_c("outputs", 10);
                for (int j = 0; j < outputs.func_74745_c(); ++j) {
                    recipe.outputs.add(FluidStack.loadFluidStackFromNBT((NBTTagCompound)outputs.func_150305_b(j)));
                }
                this.recipes.add(recipe);
            }
            this.markDirty();
        }
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerCrafter(inventory, this);
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiCrafter(inventory, this);
    }

    public void handleInfoPacketType(byte a, PacketBase payload, boolean isServer, EntityPlayer player) {
        block25: {
            block20: {
                int j;
                int i;
                block21: {
                    block23: {
                        int recipe;
                        byte message;
                        block22: {
                            ICrafter.Recipe<FluidStack> r;
                            FluidStack stack;
                            int index;
                            block24: {
                                if (a != 0) break block20;
                                if (!isServer) break block21;
                                message = payload.getByte();
                                if (message != 0) break block22;
                                int recipe2 = payload.getInt();
                                boolean input = payload.getBool();
                                index = payload.getInt();
                                stack = payload.getFluidStack();
                                if (recipe2 >= this.recipes.size()) break block23;
                                r = this.recipes.get(recipe2);
                                if (!input) break block24;
                                if (index < r.inputs.size()) {
                                    r.inputs.set(index, stack);
                                    this.markDirty();
                                }
                                break block23;
                            }
                            if (index >= r.outputs.size()) break block23;
                            r.outputs.set(index, stack);
                            this.markDirty();
                            break block23;
                        }
                        if (message == 1) {
                            int split = payload.getInt();
                            if (Ints.contains((int[])SPLITS[this.type], (int)split)) {
                                this.split(split);
                                this.markDirty();
                            }
                        } else if (message == 2) {
                            int n = payload.getInt();
                            if (n < this.linked.size()) {
                                this.linked.remove(n);
                            }
                        } else if (message == 3) {
                            ICrafterWrapper<?> wrapper;
                            TileEntity tile = BlockHelper.getAdjacentTileEntity((TileEntity)this.baseTile, (int)this.side);
                            if (tile != null && (wrapper = ThermalLogistics.INSTANCE.getWrapper(tile.getClass())) != null) {
                                this.recipes.clear();
                                this.sent.stacks.clear();
                                ICrafter.Recipe<FluidStack> recipe3 = new ICrafter.Recipe<FluidStack>(new RequestFluid(null));
                                recipe3.inputs.addAll(Collections.nCopies(SIZE[this.type] * 2, null));
                                recipe3.outputs.addAll(Collections.nCopies(SIZE[this.type], null));
                                wrapper.populateCast(tile, (byte)(this.side ^ 1), recipe3, FluidStack.class);
                                this.recipes.add(recipe3);
                                this.markDirty();
                            }
                        } else if (message == 4 && (recipe = payload.getInt()) < this.recipes.size()) {
                            int i2;
                            ICrafter.Recipe<FluidStack> r = this.recipes.get(recipe);
                            for (i2 = 0; i2 < r.inputs.size(); ++i2) {
                                r.inputs.set(i2, payload.getFluidStack());
                            }
                            for (i2 = 0; i2 < r.outputs.size(); ++i2) {
                                r.outputs.set(i2, payload.getFluidStack());
                            }
                        }
                    }
                    PacketHandler.sendToAllAround((PacketBase)this.getGuiPacket(), (TileEntity)this.baseTile);
                    break block25;
                }
                byte message = payload.getByte();
                if (message == 0) {
                    this.recipes.clear();
                    int size = payload.getInt();
                    for (i = 0; i < size; ++i) {
                        ICrafter.Recipe<FluidStack> recipe = new ICrafter.Recipe<FluidStack>(new RequestFluid(null));
                        int inputs = payload.getInt();
                        for (j = 0; j < inputs; ++j) {
                            recipe.inputs.add(payload.getFluidStack());
                        }
                        int outputs = payload.getInt();
                        for (int j2 = 0; j2 < outputs; ++j2) {
                            recipe.outputs.add(payload.getFluidStack());
                        }
                        this.recipes.add(recipe);
                    }
                }
                if (message == 0 || message == 1) {
                    this.linked.clear();
                    int links = payload.getInt();
                    for (i = 0; i < links; ++i) {
                        RequesterReference reference = RequesterReference.readPacket(payload);
                        int outputs = payload.getInt();
                        for (j = 0; j < outputs; ++j) {
                            reference.outputs.add(StackHandler.readPacket(payload));
                        }
                        this.linked.add(reference);
                    }
                }
                break block25;
            }
            super.handleInfoPacketType(a, payload, isServer, player);
        }
    }

    @Override
    public void split(int split) {
        FluidStack[] inputs = new FluidStack[SIZE[this.type] * 2];
        FluidStack[] outputs = new FluidStack[SIZE[this.type]];
        int recipeSize = SIZE[this.type] / this.recipes.size();
        for (int i = 0; i < this.recipes.size(); ++i) {
            ICrafter.Recipe<FluidStack> recipe = this.recipes.get(i);
            for (int j = 0; j < recipeSize; ++j) {
                inputs[(i * recipeSize + j) * 2] = (FluidStack)recipe.inputs.get(j * 2);
                inputs[(i * recipeSize + j) * 2 + 1] = (FluidStack)recipe.inputs.get(j * 2 + 1);
                outputs[i * recipeSize + j] = (FluidStack)recipe.outputs.get(j);
            }
        }
        this.recipes.clear();
        this.sent.stacks.clear();
        int recipes = SIZE[this.type] / split;
        for (int i = 0; i < recipes; ++i) {
            ICrafter.Recipe<FluidStack> recipe = new ICrafter.Recipe<FluidStack>(new RequestFluid(null));
            for (int j = 0; j < split; ++j) {
                recipe.inputs.add(inputs[(i * split + j) * 2]);
                recipe.inputs.add(inputs[(i * split + j) * 2 + 1]);
                recipe.outputs.add(outputs[i * split + j]);
            }
            this.recipes.add(recipe);
        }
    }

    @Override
    public Class<FluidStack> getItemClass() {
        return FluidStack.class;
    }

    private PacketTileInfo getGuiPacket() {
        PacketTileInfo packet = this.getNewPacket((byte)0);
        packet.addByte(0);
        packet.addInt(this.recipes.size());
        for (ICrafter.Recipe<FluidStack> recipe : this.recipes) {
            packet.addInt(recipe.inputs.size());
            for (FluidStack input : recipe.inputs) {
                packet.addFluidStack(input);
            }
            packet.addInt(recipe.outputs.size());
            for (FluidStack output : recipe.outputs) {
                packet.addFluidStack(output);
            }
        }
        this.writeSyncPacket(packet);
        return packet;
    }

    private void writeSyncPacket(PacketTileInfo packet) {
        this.checkLinked();
        packet.addInt(this.linked.size());
        for (RequesterReference<?> reference : this.linked) {
            RequesterReference.writePacket((PacketBase)packet, reference);
            ICrafter crafter = (ICrafter)reference.getAttachment();
            List outputs = crafter.getOutputs();
            packet.addInt(outputs.size());
            for (Object object : outputs) {
                StackHandler.writePacket((PacketBase)packet, object, crafter.getItemClass(), true);
            }
        }
    }

    @Override
    public int getIndex() {
        return 0;
    }

    @Override
    public void sync(EntityPlayer player) {
        PacketTileInfo packet = this.getNewPacket((byte)0);
        packet.addByte(1);
        this.writeSyncPacket(packet);
        PacketHandler.sendTo((PacketBase)packet, (EntityPlayer)player);
    }

    @Override
    public List<RequesterReference<?>> getLinked() {
        return this.linked;
    }

    public boolean openGui(EntityPlayer player) {
        if (ServerHelper.isServerWorld((World)this.baseTile.world())) {
            PacketHandler.sendTo((PacketBase)this.getGuiPacket(), (EntityPlayer)player);
            player.openGui((Object)ThermalDynamics.instance, 10 + this.side, this.baseTile.func_145831_w(), this.baseTile.x(), this.baseTile.y(), this.baseTile.z());
        }
        return true;
    }

    @Override
    public List<FluidStack> getOutputs() {
        NonNullList outputs = NonNullList.func_191196_a();
        for (ICrafter.Recipe<FluidStack> recipe : this.recipes) {
            outputs.addAll(this.getOutputs(recipe));
        }
        return outputs;
    }

    private List<FluidStack> getOutputs(ICrafter.Recipe<FluidStack> recipe) {
        RequestFluid request = new RequestFluid(null);
        for (FluidStack fluid : recipe.outputs) {
            if (fluid == null) continue;
            request.addStack(fluid);
        }
        return request.stacks;
    }

    @Override
    public List<ICrafter.Recipe<FluidStack>> getRecipes() {
        return this.recipes;
    }

    @Override
    public Set<RequesterReference<FluidStack>> getBlacklist() {
        HashSet<RequesterReference<FluidStack>> list = new HashSet<RequesterReference<FluidStack>>();
        list.add(this.getReference());
        for (Request request : this.process.requests) {
            list.addAll(request.blacklist);
        }
        return list;
    }

    @Override
    public boolean request(IRequester<FluidStack> requester, FluidStack stack) {
        for (ICrafter.Recipe<FluidStack> recipe : this.recipes) {
            FluidStack output = null;
            for (FluidStack fluidStack : recipe.outputs) {
                if (!FluidHelper.isFluidEqual((FluidStack)fluidStack, (FluidStack)stack)) continue;
                if (output == null) {
                    output = fluidStack;
                    continue;
                }
                output.amount += fluidStack.amount;
            }
            if (output == null) continue;
            this.markDirty();
            this.process.offset = this.baseTile.world().func_82737_E() + 1L;
            for (Request request : recipe.requests) {
                if (!request.attachment.references(requester)) continue;
                request.addStack(stack);
                return true;
            }
            recipe.requests.add(new RequestFluid(requester.getReference(), stack));
            return true;
        }
        return false;
    }

    @Override
    public void link(ICrafter<?> crafter, boolean recursion) {
        if (!this.linked.contains(crafter.getReference())) {
            Iterator<RequesterReference<?>> iterator = this.linked.iterator();
            while (iterator.hasNext()) {
                IRequester<?> requester = iterator.next().getAttachment();
                if (!(requester instanceof ICrafter)) {
                    iterator.remove();
                    continue;
                }
                ICrafter other = (ICrafter)requester;
                if (!other.hasLinked(this)) {
                    iterator.remove();
                    continue;
                }
                if (!recursion) continue;
                other.link(crafter, false);
            }
            this.linked.add(crafter.getReference());
            crafter.link(this, false);
            this.markDirty();
        }
    }

    @Override
    public boolean hasLinked(ICrafter<?> crafter) {
        return this.linked.contains(crafter.getReference());
    }

    @Override
    public List<FluidStack> getInputFrom(IRequester<FluidStack> requester) {
        return this.process.getStacks(requester);
    }

    @Override
    public List<FluidStack> getOutputTo(IRequester<FluidStack> requester) {
        NonNullList stacks = NonNullList.func_191196_a();
        for (ICrafter.Recipe<FluidStack> recipe : this.recipes) {
            stacks.addAll(Process.getStacks(recipe.requests, requester));
        }
        return stacks;
    }

    @Override
    public boolean isEnabled() {
        return this.isPowered;
    }

    @Override
    public int amountRequired(FluidStack stack) {
        int amount = this.required(stack);
        for (FluidStack item : this.process.getStacks()) {
            if (!this.itemsIdentical(item, stack)) continue;
            amount -= item.amount;
        }
        return Math.max(amount, 0);
    }

    private int required(FluidStack stack) {
        int amount = 0;
        for (int i = 0; i < this.recipes.size(); ++i) {
            ICrafter.Recipe<FluidStack> recipe = this.recipes.get(i);
            int inputAmount = 0;
            for (FluidStack input : recipe.inputs) {
                if (input == null || !this.itemsIdentical(input, stack)) continue;
                inputAmount += input.amount;
            }
            if (inputAmount == 0) continue;
            int recipes = this.getRequiredRecipes(i);
            for (RequesterReference<?> reference : this.linked) {
                recipes = Math.max(recipes, ((ICrafter)reference.getAttachment()).getRequiredRecipes(i));
            }
            amount += inputAmount * recipes;
        }
        for (FluidStack item : this.sent.stacks) {
            if (!this.itemsIdentical(item, stack)) continue;
            amount -= item.amount;
        }
        return Math.max(amount, 0);
    }

    @Override
    public int getMaxSend() {
        return ServoItem.maxSize[this.type];
    }

    private boolean itemsIdentical(FluidStack a, FluidStack b) {
        return a.getFluid() == b.getFluid() && (((ServoFluid)this).filter.getFlag(2) || FluidStack.areFluidStackTagsEqual((FluidStack)a, (FluidStack)b));
    }

    @Override
    public float getThrottle() {
        return throttle[this.type];
    }

    @Override
    public int getRequiredRecipes(int index) {
        if (index >= this.recipes.size()) {
            return 0;
        }
        ICrafter.Recipe<FluidStack> recipe = this.recipes.get(index);
        int recipes = 0;
        for (FluidStack output : this.getOutputs(recipe)) {
            int count = 0;
            block1: for (Request request : recipe.requests) {
                for (FluidStack item : request.stacks) {
                    if (!FluidHelper.isFluidEqual((FluidStack)output, (FluidStack)item)) continue;
                    count += item.amount;
                    continue block1;
                }
            }
            if ((count -= recipe.leftovers.getCount(output)) <= 0) continue;
            recipes = Math.max(recipes, (count - 1) / output.amount + 1);
        }
        return recipes;
    }

    @Override
    public DuctUnit getDuct() {
        return this.fluidDuct;
    }

    @Override
    public TileEntity getTile() {
        return this.baseTile;
    }

    @Override
    public byte getSide() {
        return this.side;
    }

    @Override
    public byte getSpeed() {
        return 0;
    }

    @Override
    public ListWrapper<Route<DuctUnitItem, GridItem>> getRoutes() {
        return null;
    }

    @Override
    public boolean hasMultiStack() {
        return false;
    }

    @Override
    public IItemHandler getCachedInv() {
        return null;
    }

    @Override
    public TileEntity getCachedTile() {
        return this.myTile;
    }

    @Override
    public ItemStack getIcon() {
        return this.getPickBlock();
    }

    @Override
    public void onFinishCrafting(IRequester<FluidStack> requester, FluidStack stack) {
        for (int i = 0; i < this.recipes.size(); ++i) {
            ICrafter.Recipe<FluidStack> recipe = this.recipes.get(i);
            if (recipe.requests.isEmpty()) continue;
            FluidStack output = null;
            for (FluidStack out : recipe.outputs) {
                if (!FluidHelper.isFluidEqual((FluidStack)out, (FluidStack)stack)) continue;
                if (output == null) {
                    output = out;
                    continue;
                }
                output.amount += out.amount;
            }
            if (output == null) continue;
            Iterator iterator = recipe.requests.iterator();
            while (iterator.hasNext()) {
                Request<FluidStack> request = iterator.next();
                if (!request.attachment.references(requester)) continue;
                request.decreaseStack(stack);
                if (request.stacks.isEmpty()) {
                    iterator.remove();
                }
                int count = stack.amount;
                Iterator iterator1 = recipe.leftovers.stacks.iterator();
                while (iterator1.hasNext()) {
                    FluidStack leftovers = (FluidStack)iterator1.next();
                    if (!FluidHelper.isFluidEqual((FluidStack)leftovers, (FluidStack)stack)) continue;
                    int amount = Math.min(leftovers.amount, stack.amount);
                    leftovers.amount -= amount;
                    count -= amount;
                    if (leftovers.amount > 0) break;
                    iterator1.remove();
                    break;
                }
                int recipes = (count - 1) / output.amount + 1;
                if (count > 0 && recipes > 0) {
                    int leftover = count % output.amount > 0 ? output.amount - count % output.amount : 0;
                    for (FluidStack fluidStack : recipe.inputs) {
                        if (fluidStack == null) continue;
                        this.sent.decreaseStack(FluidUtils.copy((FluidStack)fluidStack, (int)(fluidStack.amount * recipes)));
                    }
                    for (FluidStack fluidStack : this.getOutputs(recipe)) {
                        int amount = FluidHelper.isFluidEqual((FluidStack)fluidStack, (FluidStack)stack) ? leftover : fluidStack.amount * recipes;
                        if (amount <= 0) continue;
                        recipe.leftovers.addStack(FluidUtils.copy((FluidStack)fluidStack, (int)amount));
                    }
                    this.checkLinked();
                    for (RequesterReference requesterReference : this.linked) {
                        requesterReference.getAttachment().onFinishCrafting(i, recipes);
                    }
                }
                this.markDirty();
                return;
            }
        }
    }

    @Override
    public void onFinishCrafting(int index, int recipes) {
        if (index >= this.recipes.size()) {
            return;
        }
        ICrafter.Recipe<FluidStack> recipe = this.recipes.get(index);
        for (FluidStack in : recipe.inputs) {
            if (in == null) continue;
            this.sent.decreaseStack(FluidUtils.copy((FluidStack)in, (int)(in.amount * recipes)));
        }
        for (FluidStack out : recipe.outputs) {
            if (out == null) continue;
            recipe.leftovers.addStack(FluidUtils.copy((FluidStack)out, (int)(out.amount * recipes)));
        }
        this.markDirty();
    }

    @Override
    public void markDirty() {
        this.baseTile.markChunkDirty();
    }

    @Override
    public int tickDelay() {
        return ServoItem.tickDelays[this.type];
    }

    private static class Tank
    implements IFluidHandler {
        private final CrafterFluid crafter;
        private final IFluidHandler handler;

        private Tank(CrafterFluid crafter, IFluidHandler handler) {
            this.crafter = crafter;
            this.handler = handler;
        }

        public IFluidTankProperties[] getTankProperties() {
            return this.handler.getTankProperties();
        }

        public int fill(FluidStack resource, boolean doFill) {
            this.crafter.checkLinked();
            int required = Math.min(resource.amount, this.crafter.required(resource));
            if (required == 0) {
                return 0;
            }
            int fill = this.handler.fill(FluidUtils.copy((FluidStack)resource, (int)required), doFill);
            if (doFill) {
                this.crafter.sent.addStack(FluidUtils.copy((FluidStack)resource, (int)fill));
                this.crafter.markDirty();
            }
            return fill;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return this.handler.drain(resource, doDrain);
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return this.handler.drain(maxDrain, doDrain);
        }
    }

    private static class CacheWrapper
    extends DuctUnitFluid.Cache {
        private final CrafterFluid crafter;

        private CacheWrapper(TileEntity tile, @Nonnull CrafterFluid crafter) {
            super(tile, crafter.filter);
            this.crafter = crafter;
        }

        public IFluidHandler getHandler(int side) {
            return new Tank(this.crafter, super.getHandler(side));
        }
    }

    private static class Filter
    implements IFilterFluid {
        private final CrafterFluid crafter;

        private Filter(CrafterFluid crafter) {
            this.crafter = crafter;
        }

        public boolean allowFluid(FluidStack fluid) {
            return this.crafter.recipes.stream().anyMatch(recipe -> recipe.inputs.stream().anyMatch(input -> FluidHelper.isFluidEqual((FluidStack)input, (FluidStack)fluid)));
        }
    }
}

