/*
 * Decompiled with CFR 0.152.
 */
package landmaster.plustic.traits;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import landmaster.plustic.util.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public class HailHydra
extends AbstractTrait {
    public static final HailHydra hailhydra = new HailHydra();

    public HailHydra() {
        super("hailhydra", 0xFFFFFF);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void onUpdate(ItemStack tool, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (isSelected && !world.field_72995_K && random.nextFloat() < 0.02f) {
            ImmutableList extras = entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70643_av() != null ? ImmutableList.of((Object)((EntityLivingBase)entity).func_70643_av()) : ImmutableList.of();
            HailHydra.entExplode(world, entity, (Collection<Entity>)extras, 1.0f);
        }
    }

    @SubscribeEvent
    public void onDetonate(ExplosionEvent.Detonate event) {
        if (!event.getWorld().field_72995_K && event.getExplosion() instanceof HExplosion) {
            event.getAffectedEntities().remove(event.getExplosion().func_94613_c());
        }
    }

    @SubscribeEvent
    public void defend(LivingHurtEvent event) {
        ItemStack tool = event.getEntityLiving().func_184614_ca();
        if (event.getEntity().func_130014_f_().field_72995_K || !TinkerUtil.hasTrait((NBTTagCompound)TagUtil.getTagSafe((ItemStack)tool), (String)this.getIdentifier())) {
            return;
        }
        if (random.nextFloat() < 0.3f) {
            HailHydra.entExplode(event.getEntity().func_130014_f_(), event.getEntity(), (Collection)HailHydra.getAttacker(event.getSource()).map(ImmutableList::of).orElse(ImmutableList.of()), 1.3f);
        }
        if (random.nextFloat() < event.getAmount() / 8.0f) {
            event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76444_x, 1600, 3));
            event.getEntityLiving().func_145747_a((ITextComponent)new TextComponentTranslation("msg.plustic.hailhydra.use", new Object[0]));
        }
    }

    @Nonnull
    private static Optional<Entity> getAttacker(DamageSource source) {
        if (source instanceof EntityDamageSource) {
            return Optional.ofNullable(((EntityDamageSource)source).func_76346_g());
        }
        return Optional.empty();
    }

    private static void entExplode(World world, Entity entity, Collection<Entity> extraTargets, float power) {
        List ents = world.func_175647_a(EntityLiving.class, Utils.AABBfromVecs(entity.func_174791_d().func_178786_a(9.0, 9.0, 9.0), entity.func_174791_d().func_72441_c(9.0, 9.0, 9.0)), ent -> ent instanceof IMob && ent != entity && !extraTargets.contains(ent));
        ents.addAll(extraTargets);
        if (!ents.isEmpty()) {
            Entity target = (Entity)ents.get(random.nextInt(ents.size()));
            HExplosion explosion = new HExplosion(world, entity, target.field_70165_t, target.field_70163_u, target.field_70161_v, power, false, false);
            if (!ForgeEventFactory.onExplosionStart((World)world, (Explosion)explosion)) {
                explosion.func_77278_a();
                explosion.func_77279_a(true);
            }
        }
    }

    private static class HExplosion
    extends Explosion {
        public HExplosion(World worldIn, Entity entityIn, double x, double y, double z, float size, boolean flaming, boolean smoking) {
            super(worldIn, entityIn, x, y, z, size, flaming, smoking);
        }
    }
}

