/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.api.tile.IExtraDialInformation;
import teamroots.embers.block.BlockFluidGauge;
import teamroots.embers.block.BlockStirling;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.upgrade.UpgradeStirling;
import teamroots.embers.util.Misc;

public class TileEntityStirling
extends TileEntity
implements ITickable,
ITileEntityBase,
IExtraDialInformation,
IExtraCapabilityInformation {
    public int activeTicks = 0;
    public UpgradeStirling upgrade;
    public FluidTank tank = new FluidTank(4000){

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid != null && fluid.getFluid() == FluidRegistry.getFluid((String)"steam");
        }
    };
    private Random random = new Random();

    public TileEntityStirling() {
        this.upgrade = new UpgradeStirling(this);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        NBTTagCompound tankTag = new NBTTagCompound();
        this.tank.writeToNBT(tankTag);
        tag.func_74782_a("tank", (NBTBase)tankTag);
        tag.func_74768_a("active", this.activeTicks);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.tank.readFromNBT(tag.func_74775_l("tank"));
        this.activeTicks = tag.func_74762_e("active");
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public EnumFacing getFacing() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() instanceof BlockStirling) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockStirling.FACING);
        }
        return null;
    }

    public void setActive(int ticks) {
        this.activeTicks = Math.max(ticks, this.activeTicks);
        this.func_70296_d();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == EmbersCapabilities.UPGRADE_PROVIDER_CAPABILITY) {
            return this.getFacing() == facing;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.getFacing().func_176734_d() == facing || facing == null;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == EmbersCapabilities.UPGRADE_PROVIDER_CAPABILITY && this.getFacing() == facing) {
            return (T)this.upgrade;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (this.getFacing().func_176734_d() == facing || facing == null)) {
            return (T)this.tank;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        --this.activeTicks;
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (this.activeTicks > 0 && this.field_145850_b.field_72995_K && state.func_177230_c() instanceof BlockStirling) {
            EnumFacing[] planars;
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockStirling.FACING);
            float frontoffset = -0.6f;
            float yoffset = 0.2f;
            float wideoffset = 0.5f;
            float breadthoffset = 0.4f;
            Vec3d frontOffset = new Vec3d(0.5 - (double)((float)facing.func_82601_c() * frontoffset), 0.5 - (double)((float)facing.func_96559_d() * frontoffset), 0.5 - (double)((float)facing.func_82599_e() * frontoffset));
            Vec3d baseOffset = new Vec3d(0.5 - (double)((float)facing.func_82601_c() * yoffset), 0.5 - (double)((float)facing.func_96559_d() * yoffset), 0.5 - (double)((float)facing.func_82599_e() * yoffset));
            switch (facing.func_176740_k()) {
                case X: {
                    planars = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH};
                    break;
                }
                case Y: {
                    planars = new EnumFacing[]{EnumFacing.EAST, EnumFacing.WEST, EnumFacing.NORTH, EnumFacing.SOUTH};
                    break;
                }
                case Z: {
                    planars = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP, EnumFacing.EAST, EnumFacing.WEST};
                    break;
                }
                default: {
                    planars = null;
                }
            }
            for (void var13_16 : planars) {
                IBlockState sideState = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a((EnumFacing)var13_16));
                if (sideState.func_193401_d((IBlockAccess)this.field_145850_b, this.field_174879_c.func_177972_a((EnumFacing)var13_16), var13_16.func_176734_d()) != BlockFaceShape.UNDEFINED) continue;
                EnumFacing cross = facing.func_176732_a(var13_16.func_176740_k());
                float x1 = (float)this.func_174877_v().func_177958_n() + (float)baseOffset.field_72450_a + (float)var13_16.func_82601_c() * wideoffset;
                float y1 = (float)this.func_174877_v().func_177956_o() + (float)baseOffset.field_72448_b + (float)var13_16.func_96559_d() * wideoffset;
                float z1 = (float)this.func_174877_v().func_177952_p() + (float)baseOffset.field_72449_c + (float)var13_16.func_82599_e() * wideoffset;
                float x2 = (float)this.func_174877_v().func_177958_n() + (float)frontOffset.field_72450_a + (float)var13_16.func_82601_c() * wideoffset + (float)cross.func_82601_c() * (this.random.nextFloat() - 0.5f) * 2.0f * breadthoffset;
                float y2 = (float)this.func_174877_v().func_177956_o() + (float)frontOffset.field_72448_b + (float)var13_16.func_96559_d() * wideoffset + (float)cross.func_96559_d() * (this.random.nextFloat() - 0.5f) * 2.0f * breadthoffset;
                float z2 = (float)this.func_174877_v().func_177952_p() + (float)frontOffset.field_72449_c + (float)var13_16.func_82599_e() * wideoffset + (float)cross.func_82599_e() * (this.random.nextFloat() - 0.5f) * 2.0f * breadthoffset;
                int lifetime = 24 + this.random.nextInt(8);
                float motionx = (x2 - x1) / (float)lifetime;
                float motiony = (y2 - y1) / (float)lifetime;
                float motionz = (z2 - z1) / (float)lifetime;
                ParticleUtil.spawnParticleVapor(this.func_145831_w(), x1, y1, z1, motionx, motiony, motionz, 255.0f, 64.0f, 16.0f, 1.0f, 2.0f, 3.0f, lifetime);
            }
            float x = (float)this.func_174877_v().func_177958_n() + (float)frontOffset.field_72450_a;
            float y = (float)this.func_174877_v().func_177956_o() + (float)frontOffset.field_72448_b;
            float z = (float)this.func_174877_v().func_177952_p() + (float)frontOffset.field_72449_c;
            int n = 16 + this.random.nextInt(16);
            float motionx = (float)(Math.abs(facing.func_82601_c()) - 1) * (this.random.nextFloat() - 0.5f) * 2.0f * wideoffset / (float)n;
            float motiony = (float)(Math.abs(facing.func_96559_d()) - 1) * (this.random.nextFloat() - 0.5f) * 2.0f * wideoffset / (float)n;
            float motionz = (float)(Math.abs(facing.func_82599_e()) - 1) * (this.random.nextFloat() - 0.5f) * 2.0f * wideoffset / (float)n;
            ParticleUtil.spawnParticleVapor(this.func_145831_w(), x, y, z, motionx, motiony, motionz, 255.0f, 64.0f, 16.0f, 1.0f, 3.0f, 4.0f, n * 2);
        }
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
    }

    public FluidStack getFluidStack() {
        return this.tank.getFluid();
    }

    public int getCapacity() {
        return this.tank.getCapacity();
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE(this);
    }

    @Override
    public void addDialInformation(EnumFacing facing, List<String> information, String dialType) {
        if ("fluid".equals(dialType)) {
            information.clear();
            information.add(BlockFluidGauge.formatFluidStack(this.getFluidStack(), this.getCapacity()));
        }
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public void addCapabilityDescription(List<String> strings, Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.INPUT, "embers.tooltip.goggles.fluid", I18n.func_135052_a((String)"embers.tooltip.goggles.fluid.steam", (Object[])new Object[0])));
        }
    }
}

