/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.itemmod;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import teamroots.embers.RegistryManager;
import teamroots.embers.SoundManager;
import teamroots.embers.api.EmbersAPI;
import teamroots.embers.api.itemmod.ItemModUtil;
import teamroots.embers.api.itemmod.ModifierBase;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageFlameShieldFX;
import teamroots.embers.util.EmberInventoryUtil;

public class ModifierFlameBarrier
extends ModifierBase {
    public ModifierFlameBarrier() {
        super(ModifierBase.EnumType.ARMOR, "flame_barrier", 2.0, true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onHit(LivingHurtEvent event) {
        if (event.getEntity() instanceof EntityPlayer && event.getSource().func_76346_g() instanceof EntityLivingBase) {
            int blastingLevel = ItemModUtil.getArmorModifierLevel((EntityLivingBase)((EntityPlayer)event.getEntity()), EmbersAPI.FLAME_BARRIER);
            float strength = (float)(2.0 * (Math.atan(0.6 * (double)blastingLevel) / Math.PI));
            if (blastingLevel > 0 && EmberInventoryUtil.getEmberTotal((EntityPlayer)event.getEntity()) >= this.cost) {
                EmberInventoryUtil.removeEmber((EntityPlayer)event.getEntity(), this.cost);
                event.getSource().func_76346_g().func_70097_a(RegistryManager.damage_ember, strength * event.getAmount() * 0.5f);
                event.getSource().func_76346_g().func_70015_d(blastingLevel + 1);
                event.getEntity().func_184185_a(SoundManager.FIREBALL_HIT, 1.0f, 1.0f);
                event.getEntity().func_130014_f_().func_184148_a(null, event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v, SoundManager.FIREBALL_HIT, SoundCategory.PLAYERS, 1.0f, 1.0f);
                if (!event.getEntity().field_70170_p.field_72995_K) {
                    PacketHandler.INSTANCE.sendToAll((IMessage)new MessageFlameShieldFX(event.getEntity().field_70165_t, event.getEntity().field_70163_u + (double)event.getEntity().field_70131_O / 2.0, event.getEntity().field_70161_v));
                }
            }
        }
    }
}

