/*
 * Decompiled with CFR 0.152.
 */
package com.corwinjv.mobtotems.items.baubles;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.corwinjv.mobtotems.interfaces.IChargeable;
import com.corwinjv.mobtotems.items.ModItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(modid="baubles", iface="baubles.api.IBauble")
public class BaubleItem
extends ModItem
implements IBauble,
IChargeable {
    protected static final String CHARGE_LEVEL = "CHARGE_LEVEL";

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        this.initNbtData(stack);
    }

    protected NBTTagCompound initNbtData(ItemStack stack) {
        NBTTagCompound nbtTagCompound = stack.func_77978_p();
        if (nbtTagCompound == null) {
            nbtTagCompound = new NBTTagCompound();
        }
        nbtTagCompound.func_74768_a(CHARGE_LEVEL, 0);
        stack.func_77982_d(nbtTagCompound);
        return nbtTagCompound;
    }

    @Override
    public int getChargeLevel(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = this.initNbtData(stack);
        }
        return tagCompound.func_74762_e(CHARGE_LEVEL);
    }

    @Override
    public void setChargeLevel(ItemStack stack, int chargeLevel) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = this.initNbtData(stack);
        }
        tagCompound.func_74768_a(CHARGE_LEVEL, chargeLevel);
    }

    @Override
    public void decrementChargeLevel(ItemStack stack, int amount) {
        int chargeLevel = this.getChargeLevel(stack);
        if ((chargeLevel -= amount) < 0) {
            chargeLevel = 0;
        }
        this.setChargeLevel(stack, chargeLevel);
    }

    @Override
    public void incrementChargeLevel(ItemStack stack, int amount) {
        int chargeLevel = this.getChargeLevel(stack);
        if ((chargeLevel += amount) > this.getMaxChargeLevel()) {
            chargeLevel = this.getMaxChargeLevel();
        }
        this.setChargeLevel(stack, chargeLevel);
    }

    @Override
    public int getMaxChargeLevel() {
        return 16;
    }

    public void onBaubleActivated(ItemStack stack, EntityPlayer player) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.TRINKET;
    }

    @Override
    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Override
    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Override
    public boolean willAutoSync(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }
}

