/*
 * Decompiled with CFR 0.152.
 */
package com.corwinjv.mobtotems.blocks.tiles;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import com.corwinjv.mobtotems.blocks.tiles.base.ModTileEntity;
import com.corwinjv.mobtotems.interfaces.IChargeable;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;

public class IncenseKindlingBoxTileEntity
extends ModTileEntity
implements ITickable {
    private static final String TIME_LIVED = "TIME_LIVED";
    private static final long UPDATE_TICKS = 20L;
    private static final long PARTICLE_UPDATE_TICKS = 40L;
    public static final double TMP_MANA_GAIN_DIST = 8.0;
    public static final int CHARGE_GAIN_PER_TICK = 2;
    private static final long TTL = 200L;
    private long timeLived = 0L;

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound ret = super.func_189515_b(compound);
        ret.func_74772_a(TIME_LIVED, this.timeLived);
        return ret;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        long time = 0L;
        if (compound.func_74764_b(TIME_LIVED)) {
            time = compound.func_74763_f(TIME_LIVED);
        }
        this.timeLived = time;
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.performTTLUpdate();
            long worldTime = this.func_145831_w().func_72820_D();
            if (worldTime % 20L == 0L) {
                this.performChargeAura();
            }
        } else {
            long worldTime = this.func_145831_w().func_72820_D();
            if (worldTime % 40L == 0L) {
                this.spawnParticleEffects();
            }
        }
    }

    private void performTTLUpdate() {
        ++this.timeLived;
        if (this.timeLived > 200L) {
            this.func_145831_w().func_175655_b(this.field_174879_c, false);
        }
    }

    private void performChargeAura() {
        BlockPos targetPos = this.func_174877_v();
        Predicate<EntityPlayer> playerWithinRangePredicate = input -> input != null && input.func_180425_c().func_185332_f(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p()) < 8.0;
        List playersWithinRange = this.func_145831_w().func_175644_a(EntityPlayer.class, playerWithinRangePredicate::test);
        for (EntityPlayer player : playersWithinRange) {
            IBaublesItemHandler baublesItemHandler = BaublesApi.getBaublesHandler(player);
            for (int i = 0; i < baublesItemHandler.getSlots(); ++i) {
                ItemStack baubleStack = baublesItemHandler.getStackInSlot(i);
                if (baubleStack == ItemStack.field_190927_a || !(baubleStack.func_77973_b() instanceof IChargeable)) continue;
                ((IChargeable)baubleStack.func_77973_b()).incrementChargeLevel(baubleStack, 2);
            }
        }
    }

    private void spawnParticleEffects() {
        double startX = (double)this.field_174879_c.func_177958_n() - 8.0;
        double startY = (double)this.field_174879_c.func_177956_o() - 8.0;
        double startZ = (double)this.field_174879_c.func_177952_p() - 8.0;
        for (double x = startX; x < (double)this.field_174879_c.func_177958_n() + 8.0; x += 1.0) {
            for (double y = startY; y < (double)this.field_174879_c.func_177956_o() + 8.0; y += 1.0) {
                for (double z = startZ; z < (double)this.field_174879_c.func_177952_p() + 8.0; z += 1.0) {
                    BlockPos blockPos = new BlockPos(x, y, z);
                    Block block = this.func_145831_w().func_180495_p(blockPos).func_177230_c();
                    Block blockAbove = this.func_145831_w().func_180495_p(new BlockPos(x, y + 1.0, z)).func_177230_c();
                    if (!(this.field_174879_c.func_185332_f(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()) < 8.0) || !block.func_181623_g() || !(blockAbove instanceof BlockAir)) continue;
                    Random rand = this.func_145831_w().field_73012_v;
                    float width = 0.75f;
                    float height = 0.75f;
                    double motionX = rand.nextGaussian() * 0.02;
                    double motionY = rand.nextGaussian() * 0.02;
                    double motionZ = rand.nextGaussian() * 0.02;
                    this.field_145850_b.func_175688_a(EnumParticleTypes.CLOUD, x + (double)(rand.nextFloat() * width * 2.0f) - (double)width, y + 1.0 + (double)(rand.nextFloat() * height), z + (double)(rand.nextFloat() * width * 2.0f) - (double)width, motionX, motionY, motionZ, new int[0]);
                    width = 1.0f;
                    height = 1.0f;
                    motionX = rand.nextGaussian() * 0.02;
                    motionY = rand.nextGaussian() * 0.02;
                    motionZ = rand.nextGaussian() * 0.02;
                    this.field_145850_b.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, x + (double)(rand.nextFloat() * width * 2.0f) - (double)width, y + 0.5 + (double)(rand.nextFloat() * height), z + (double)(rand.nextFloat() * width * 2.0f) - (double)width, motionX, motionY, motionZ, new int[0]);
                }
            }
        }
    }
}

